/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.common.utils;

import com.jhscale.common.content.JHContents;
import com.jhscale.common.em.BusinessData;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;

public class PojoUtils {
    private PojoUtils() {
    }

    public static final <T> void init(T entity) {
        PojoUtils.init(entity, JHContents.DEFAULT_INVENT_CODE);
    }

    public static final <T> void init(T entity, Long createMan) {
        Class<?> entityClass = entity.getClass();
        try {
            PropertyDescriptor[] descriptors;
            for (PropertyDescriptor descriptor : descriptors = Introspector.getBeanInfo(entityClass).getPropertyDescriptors()) {
                try {
                    switch (descriptor.getName()) {
                        case "state": {
                            descriptor.getWriteMethod().invoke(entity, BusinessData.\u6b63\u5e38.getType());
                            break;
                        }
                        case "createMan": {
                            descriptor.getWriteMethod().invoke(entity, createMan);
                            break;
                        }
                        case "createTime": {
                            descriptor.getWriteMethod().invoke(entity, new Date());
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    System.err.println(String.format("\u521d\u59cb\u5316[%s]\u5f02\u5e38:%s", descriptor.getName(), e.getMessage()));
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            System.err.println(String.format("\u521d\u59cb\u5316\u5f02\u5e38:%s", e.getMessage()));
            e.printStackTrace();
        }
    }

    public static final <T> void initAll(T entity) {
        PojoUtils.initAll(entity, JHContents.DEFAULT_INVENT_CODE);
    }

    public static final <T> void initAll(T entity, Long createMan) {
        Class<?> entityClass = entity.getClass();
        try {
            PropertyDescriptor[] descriptors = Introspector.getBeanInfo(entityClass).getPropertyDescriptors();
            Date initDate = new Date();
            for (PropertyDescriptor descriptor : descriptors) {
                try {
                    switch (descriptor.getName()) {
                        case "state": {
                            descriptor.getWriteMethod().invoke(entity, BusinessData.\u6b63\u5e38.getType());
                            break;
                        }
                        case "createMan": {
                            descriptor.getWriteMethod().invoke(entity, createMan);
                            break;
                        }
                        case "createTime": {
                            descriptor.getWriteMethod().invoke(entity, initDate);
                            break;
                        }
                        case "lastupdateMan": {
                            descriptor.getWriteMethod().invoke(entity, createMan);
                            break;
                        }
                        case "lastupdateTime": {
                            descriptor.getWriteMethod().invoke(entity, initDate);
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    System.err.println(String.format("\u521d\u59cb\u5316[%s]\u5f02\u5e38:%s", descriptor.getName(), e.getMessage()));
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            System.err.println(String.format("\u521d\u59cb\u5316\u5f02\u5e38:%s", e.getMessage()));
            e.printStackTrace();
        }
    }

    public static final <T> void initUpdate(T entity) {
        PojoUtils.initUpdate(entity, JHContents.DEFAULT_INVENT_CODE);
    }

    public static final <T> void initUpdate(T entity, Long lastUpdateMan) {
        Class<?> entityClass = entity.getClass();
        try {
            PropertyDescriptor[] descriptors;
            for (PropertyDescriptor descriptor : descriptors = Introspector.getBeanInfo(entityClass).getPropertyDescriptors()) {
                try {
                    switch (descriptor.getName()) {
                        case "lastupdateMan": {
                            descriptor.getWriteMethod().invoke(entity, lastUpdateMan);
                            break;
                        }
                        case "lastupdateTime": {
                            descriptor.getWriteMethod().invoke(entity, new Date());
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    System.err.println(String.format("\u66f4\u65b0\u521d\u59cb\u5316[%s]\u5f02\u5e38:%s", descriptor.getName(), e.getMessage()));
                    e.printStackTrace();
                }
            }
        }
        catch (IntrospectionException e) {
            System.err.println(String.format("\u66f4\u65b0\u521d\u59cb\u5316\u5f02\u5e38:%s", e.getMessage()));
            e.printStackTrace();
        }
    }

    public static <T> T clone(T src) {
        Object result = null;
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             ObjectOutputStream oos = new ObjectOutputStream(baos);){
            oos.writeObject(src);
            oos.flush();
            try (ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                 ObjectInputStream ois = new ObjectInputStream(bais);){
                result = ois.readObject();
            }
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
        }
        return (T)result;
    }
}

