/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.common.utils;

import com.jhscale.common.exception.ProfessionalException;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class RegexUtil {
    public static final String TELREGEX = "^1[3456789][0-9]{9}$";
    public static final String PWDREGEX = "^[a-zA-Z][a-zA-Z0-9_]{5,15}$";
    public static final String EMAILREGEX = "^([a-zA-Z0-9]+[-|_|\\_|\\.]?)*[a-zA-Z0-9]+@([a-zA-Z0-9]+[_|\\_|\\.]?)*[a-zA-Z0-9]+\\.[a-zA-Z]{2,3}$";
    public static final String MACREGEX = "0023F0[a-zA-Z0-9]{6}$";
    public static final String EQUIPMENT_UNIQUE_REGEX = "^[A-Za-z0-9]{12,30}$";
    public static final String BUSINESS_IDENTIFY = "^[^_IOZSVa-z\\W]{2}\\d{6}[^_IOZSVa-z\\W]{10}$";
    private static final String PACKAGE_REGEX = "^([a-zA-Z]+[.][a-zA-Z]+)[.]*.*";

    private RegexUtil() {
    }

    public static boolean regexBusinessIdentify(String identify) {
        Pattern pattern = Pattern.compile(BUSINESS_IDENTIFY);
        return pattern.matcher(identify).matches();
    }

    public static boolean regexPhoneNum(String telNum) throws ProfessionalException {
        Pattern pattern = Pattern.compile(TELREGEX);
        if (!pattern.matcher(telNum).matches()) {
            throw new ProfessionalException("\u624b\u673a\u53f7\u7801\u4e0d\u5339\u914d\u89c4\u5219");
        }
        return true;
    }

    public static boolean regexPhoneNumResult(String telNum) {
        Pattern pattern = Pattern.compile(TELREGEX);
        return pattern.matcher(telNum).matches();
    }

    public static boolean regexPwd(String passwd) throws ProfessionalException {
        Pattern pattern = Pattern.compile(PWDREGEX);
        if (!pattern.matcher(passwd).matches()) {
            throw new ProfessionalException("\u5bc6\u7801\u89c4\u5219[\u5b57\u6bcd + 5\u523015\u4f4d\u5b57\u6bcd\u6216\u6570\u5b57]");
        }
        return true;
    }

    public static boolean regexEmail(String email) throws ProfessionalException {
        Pattern pattern = Pattern.compile(EMAILREGEX);
        if (!pattern.matcher(email).matches()) {
            throw new ProfessionalException("\u90ae\u7bb1\u4e0d\u5339\u914d\u89c4\u5219");
        }
        return true;
    }

    public static boolean regexEmailResult(String email) {
        Pattern pattern = Pattern.compile(EMAILREGEX);
        return pattern.matcher(email).matches();
    }

    public static boolean matcher(String source, String regexp) {
        Pattern pattern = Pattern.compile(regexp);
        return pattern.matcher(source).matches();
    }

    public static boolean isNumber(String numStr) {
        return RegexUtil.matcher(numStr, "^[0-9]*[1-9][0-9]*$");
    }

    public static String isNumOrEmail(String account, String areaCode) throws ProfessionalException {
        Pattern pPattern = Pattern.compile(TELREGEX);
        Pattern ePattern = Pattern.compile(EMAILREGEX);
        if (ePattern.matcher(account).matches()) {
            return "E";
        }
        if (RegexUtil.isNumber(account) && (StringUtils.isNotBlank((CharSequence)areaCode) && !"0086".equals(areaCode) || (StringUtils.isBlank((CharSequence)areaCode) || "0086".equals(areaCode)) && pPattern.matcher(account).matches())) {
            return "P";
        }
        throw new ProfessionalException("\u8d26\u53f7\u975e\u624b\u673a\u53f7\u7801\u6216\u90ae\u7bb1");
    }

    public static String isNumOrEmail(String account) {
        Pattern ePattern = Pattern.compile(EMAILREGEX);
        if (ePattern.matcher(account).matches()) {
            return "E";
        }
        return "P";
    }

    public static boolean checkMoblieAndEmail(String userName) {
        Pattern ePattern = Pattern.compile(EMAILREGEX);
        return !RegexUtil.isNumber(userName) && !ePattern.matcher(userName).matches();
    }

    public static boolean checkMac(String mac) {
        Pattern mPaggern = Pattern.compile(MACREGEX);
        return mPaggern.matcher(mac).matches();
    }

    public static boolean checkUnique(String unique) {
        Pattern mPaggern = Pattern.compile(EQUIPMENT_UNIQUE_REGEX);
        return mPaggern.matcher(unique).matches();
    }

    public static boolean checkOrderNo(String orderNo) {
        return RegexUtil.isNumber(orderNo) && orderNo.length() == 25;
    }

    public static boolean checkJavaPackage(String packageStr) {
        return Pattern.compile(PACKAGE_REGEX).matcher(packageStr).matches();
    }
}

