/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.common.utils;

import com.jhscale.common.model.simple.RLocation;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Scanner;
import org.apache.commons.lang3.StringUtils;

public class SystemtUtils {
    private static final String WIN_PING_FORMAT = "ping %s";
    private static final String CENTOS_PING_FROMAT = "ping %s -w %s";
    private static final double EARTH_RADIUS = 6371.0;

    public static boolean isWindows() {
        return System.getProperties().getProperty("os.name").toUpperCase().indexOf("WINDOWS") != -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NetWork checkNetwork(String url) {
        Runtime runtime = Runtime.getRuntime();
        InputStream is = null;
        InputStreamReader isr = null;
        BufferedReader br = null;
        NetWork netWork = null;
        try {
            Process process = runtime.exec(String.format(WIN_PING_FORMAT, url));
            is = process.getInputStream();
            isr = new InputStreamReader(is, "GBK");
            br = new BufferedReader(isr);
            String line = null;
            StringBuffer sb = new StringBuffer();
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
            if (StringUtils.isNotBlank((CharSequence)sb) && sb.indexOf("TTL") > 0) {
                netWork = new NetWork();
                String connectStr = sb.toString();
                connectStr = connectStr.split("\u6570\u636e\u5305: \u5df2\u53d1\u9001 =")[1];
                netWork.setSendCount(Integer.parseInt(connectStr.substring(0, connectStr.indexOf("\uff0c")).trim()));
                connectStr = connectStr.split("\u5df2\u63a5\u6536 =")[1];
                netWork.setAcceptCount(Integer.parseInt(connectStr.substring(0, connectStr.indexOf("\uff0c")).trim()));
                connectStr = connectStr.split("\u4e22\u5931 =")[1];
                netWork.setLoseCount(Integer.parseInt(connectStr.substring(0, connectStr.indexOf("(")).trim()));
                connectStr = connectStr.split("\u6700\u77ed =")[1];
                netWork.setMinTime(Integer.parseInt(connectStr.substring(0, connectStr.indexOf("ms")).trim()));
                connectStr = connectStr.split("\u6700\u957f =")[1];
                netWork.setMaxTime(Integer.parseInt(connectStr.substring(0, connectStr.indexOf("ms")).trim()));
                connectStr = connectStr.split("\u5e73\u5747 =")[1];
                netWork.setAvgTime(Integer.parseInt(connectStr.substring(0, connectStr.indexOf("ms")).trim()));
            }
            SystemtUtils.close(is, isr, br);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            SystemtUtils.close(is, isr, br);
        }
        return netWork;
    }

    public static boolean checkBaiduState() {
        return SystemtUtils.checkNetworkState("baidu.com");
    }

    public static boolean checkNetworkState(String target_name) {
        return SystemtUtils.checkNetworkState(target_name, 10);
    }

    public static boolean checkNetworkState(String target_name, int out_time) {
        return SystemtUtils.isWindows() ? SystemtUtils.checkWinNetworkState(target_name) : SystemtUtils.checkCentosNetworkState(target_name, out_time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkWinNetworkState(String target_name) {
        boolean connect;
        block7: {
            boolean bl;
            Runtime runtime = Runtime.getRuntime();
            connect = false;
            InputStream is = null;
            InputStreamReader isr = null;
            BufferedReader br = null;
            try {
                Process process = runtime.exec(String.format(WIN_PING_FORMAT, target_name));
                is = process.getInputStream();
                isr = new InputStreamReader(is, "GBK");
                br = new BufferedReader(isr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    if (!line.contains("TTL")) continue;
                    boolean bl2 = true;
                    SystemtUtils.close(is, isr, br);
                    return bl2;
                }
                bl = false;
                SystemtUtils.close(is, isr, br);
            }
            catch (IOException e) {
                e.printStackTrace();
                break block7;
            }
            finally {
                SystemtUtils.close(is, isr, br);
            }
            return bl;
        }
        return connect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkCentosNetworkState(String target_name, int out_time) {
        Runtime runtime = Runtime.getRuntime();
        BufferedReader bufferedReader = null;
        try {
            Process process = runtime.exec(String.format(CENTOS_PING_FROMAT, target_name, out_time));
            if (null == process) {
                boolean bl = false;
                return bl;
            }
            bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream(), "UTF-8"));
            String line = null;
            while (null != (line = bufferedReader.readLine())) {
                System.out.println(line);
                if (line.startsWith("bytes from", 3)) {
                    boolean e = true;
                    return e;
                }
                if (!line.startsWith("from")) continue;
                boolean e = true;
                return e;
            }
            boolean e = false;
            return e;
        }
        catch (IOException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static void close(InputStream is, InputStreamReader isr, BufferedReader br) {
        try {
            if (is != null) {
                is.close();
            }
            if (isr != null) {
                isr.close();
            }
            if (br != null) {
                br.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void sleep(int time) {
        SystemtUtils.sleep(time, false);
    }

    public static void sleep(int time, boolean log) {
        int min = 0;
        do {
            ++min;
            try {
                if (min % 10 == 0 && log) {
                    System.out.println("\u4f11\u7720[ " + time + "s ]-\u7b2c[" + min + "]\u79d2");
                }
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } while (min < time);
    }

    public static void millis_sleep(long time) {
        SystemtUtils.millis_sleep(time, false);
    }

    public static void millis_sleep(long time, boolean log) {
        int millis = 0;
        do {
            ++millis;
            try {
                if (millis % 10000 == 0 && log) {
                    System.out.println("\u4f11\u7720[ " + time + "s ]-\u7b2c[" + millis + "]\u6beb\u79d2");
                }
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } while ((long)millis < time);
    }

    public static List<NetworkInfo> network_info() {
        ArrayList<NetworkInfo> networkInfo = new ArrayList<NetworkInfo>();
        try {
            Enumeration<NetworkInterface> nifs = NetworkInterface.getNetworkInterfaces();
            while (nifs.hasMoreElements()) {
                NetworkInterface nif = nifs.nextElement();
                Enumeration<InetAddress> address = nif.getInetAddresses();
                while (address.hasMoreElements()) {
                    InetAddress addr = address.nextElement();
                    if (!(addr instanceof Inet4Address)) continue;
                    networkInfo.add(new NetworkInfo(nif.getName(), addr));
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        return networkInfo;
    }

    public static String lan_ip() {
        String ip;
        block3: {
            ip = null;
            try {
                List<NetworkInfo> networkInfoList = SystemtUtils.network_info();
                if (networkInfoList == null || networkInfoList.isEmpty()) break block3;
                for (NetworkInfo networkInfo : networkInfoList) {
                    String hostAddress = networkInfo.getAddress().getHostAddress();
                    if (hostAddress.endsWith(".1")) continue;
                    ip = hostAddress;
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ip;
    }

    public static String route_ip() {
        String lan_ip = SystemtUtils.lan_ip();
        String route_ip = null;
        if (StringUtils.isNotBlank((CharSequence)lan_ip)) {
            int index = lan_ip.lastIndexOf(".");
            route_ip = lan_ip.substring(0, index) + ".1";
        }
        return route_ip;
    }

    public static String route_broadcast() {
        String lan_ip = SystemtUtils.lan_ip();
        String route_broadcast = null;
        if (StringUtils.isNotBlank((CharSequence)lan_ip)) {
            int index = lan_ip.lastIndexOf(".");
            route_broadcast = lan_ip.substring(0, index) + ".255";
        }
        return route_broadcast;
    }

    public static String scanner(String description) {
        Scanner scanner = new Scanner(System.in);
        System.out.print(description + ": ");
        return scanner.nextLine();
    }

    public static String command(String ... commands) {
        return SystemtUtils.isWindows() ? SystemtUtils.win_command(commands) : SystemtUtils.linux_command(commands);
    }

    public static String command(File directory, String ... commands) {
        return SystemtUtils.isWindows() ? SystemtUtils.win_command(directory, commands) : SystemtUtils.linux_command(directory, commands);
    }

    public static String win_command(String ... commands) {
        Process process = null;
        BufferedReader reader = null;
        StringBuilder builder = new StringBuilder();
        try {
            String line;
            ArrayList<String> commandList = new ArrayList<String>();
            commandList.add("cmd.exe");
            commandList.add("/c");
            commandList.addAll(Arrays.asList(commands));
            ProcessBuilder processBuilder = new ProcessBuilder(commandList.toArray(new String[0]));
            processBuilder.redirectErrorStream(true);
            process = processBuilder.start();
            reader = new BufferedReader(new InputStreamReader(process.getInputStream(), "GBK"));
            while ((line = reader.readLine()) != null) {
                builder.append(line);
            }
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                throw new RuntimeException("Command exited with non-zero status code: " + exitCode);
            }
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException("Failed to execute command: " + e.getMessage());
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
            if (process != null) {
                process.destroy();
            }
        }
        return builder.toString();
    }

    public static String win_command(File directory, String ... commands) {
        Process process = null;
        BufferedReader reader = null;
        StringBuilder builder = new StringBuilder();
        try {
            String line;
            ArrayList<String> commandList = new ArrayList<String>();
            commandList.add("cmd.exe");
            commandList.add("/c");
            commandList.addAll(Arrays.asList(commands));
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
            processBuilder.directory(directory);
            processBuilder.command(commandList.toArray(new String[0]));
            processBuilder.redirectErrorStream(true);
            process = processBuilder.start();
            reader = new BufferedReader(new InputStreamReader(process.getInputStream(), "GBK"));
            while ((line = reader.readLine()) != null) {
                builder.append(line);
            }
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                throw new RuntimeException("Command exited with non-zero status code: " + exitCode);
            }
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException("Failed to execute command: " + e.getMessage());
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
            if (process != null) {
                process.destroy();
            }
        }
        return builder.toString();
    }

    public static String linux_command(String ... commands) {
        Process process = null;
        BufferedReader reader = null;
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            ArrayList<String> commandList = new ArrayList<String>();
            commandList.add("/bin/sh");
            commandList.add("-c");
            commandList.addAll(Arrays.asList(commands));
            ProcessBuilder processBuilder = new ProcessBuilder(commandList.toArray(new String[0]));
            processBuilder.redirectErrorStream(true);
            process = processBuilder.start();
            reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                throw new RuntimeException("Command exited with non-zero status code: " + exitCode);
            }
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException("Failed to execute command: " + e.getMessage());
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
            if (process != null) {
                process.destroy();
            }
        }
        return sb.toString();
    }

    public static String linux_command(File directory, String ... commands) {
        Process process = null;
        BufferedReader reader = null;
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            ArrayList<String> commandList = new ArrayList<String>();
            commandList.add("/bin/sh");
            commandList.add("-c");
            commandList.addAll(Arrays.asList(commands));
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
            processBuilder.directory(directory);
            processBuilder.command(commandList.toArray(new String[0]));
            processBuilder.redirectErrorStream(true);
            process = processBuilder.start();
            reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                throw new RuntimeException("Command exited with non-zero status code: " + exitCode);
            }
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException("Failed to execute command: " + e.getMessage());
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
            if (process != null) {
                process.destroy();
            }
        }
        return sb.toString();
    }

    public static double haversineKilometreDistance(RLocation r1, RLocation r2) {
        double dLat = Math.toRadians(r2.getLat() - r1.getLat());
        double dLon = Math.toRadians(r2.getLon() - r1.getLon());
        double a = Math.sin(dLat / 2.0) * Math.sin(dLat / 2.0) + Math.cos(Math.toRadians(r1.getLat())) * Math.cos(Math.toRadians(r2.getLat())) * Math.sin(dLon / 2.0) * Math.sin(dLon / 2.0);
        double c = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
        return 6371.0 * c;
    }

    public static double haversineMetreDistance(RLocation r1, RLocation r2) {
        return SystemtUtils.haversineKilometreDistance(r1, r2) * 1000.0;
    }

    public static class NetWork {
        private int sendCount;
        private int acceptCount;
        private int loseCount;
        private int maxTime;
        private int minTime;
        private int avgTime;

        public int getSendCount() {
            return this.sendCount;
        }

        public void setSendCount(int sendCount) {
            this.sendCount = sendCount;
        }

        public int getAcceptCount() {
            return this.acceptCount;
        }

        public void setAcceptCount(int acceptCount) {
            this.acceptCount = acceptCount;
        }

        public int getLoseCount() {
            return this.loseCount;
        }

        public void setLoseCount(int loseCount) {
            this.loseCount = loseCount;
        }

        public int getMaxTime() {
            return this.maxTime;
        }

        public void setMaxTime(int maxTime) {
            this.maxTime = maxTime;
        }

        public int getMinTime() {
            return this.minTime;
        }

        public void setMinTime(int minTime) {
            this.minTime = minTime;
        }

        public int getAvgTime() {
            return this.avgTime;
        }

        public void setAvgTime(int avgTime) {
            this.avgTime = avgTime;
        }
    }

    public static class NetworkInfo {
        private String card;
        private InetAddress address;

        public NetworkInfo() {
        }

        public NetworkInfo(String card, InetAddress address) {
            this.card = card;
            this.address = address;
        }

        public String getCard() {
            return this.card;
        }

        public void setCard(String card) {
            this.card = card;
        }

        public InetAddress getAddress() {
            return this.address;
        }

        public void setAddress(InetAddress address) {
            this.address = address;
        }
    }
}

