/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.common.utils;

import com.jhscale.common.exception.GeneralException;
import com.jhscale.common.model.inter.JSONModel;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class UniqueUtils {
    private static final Map<String, BoardStrategy> boardStrategyMap = new HashMap<String, BoardStrategy>();

    public static MainBoard unique(MainBoard board, BoardStrategy otherStrategy) throws GeneralException {
        BoardStrategy boardStrategy = boardStrategyMap.get(board.getBoard());
        String unique = null;
        if (boardStrategy != null) {
            unique = boardStrategy.strategy(board);
        }
        if (StringUtils.isBlank(unique) && otherStrategy != null) {
            unique = otherStrategy.strategy(board);
        }
        board.setUnique(unique);
        return board;
    }

    static {
        boardStrategyMap.put(Board.YSA.getSimple(), new YSA_Board());
        boardStrategyMap.put(Board.YSB.getSimple(), new YSB_Board());
    }

    public static enum Board {
        YSA("YSA", ""),
        YSB("YSB", "");

        private String simple;
        private String name;

        private Board(String simple, String name) {
            this.simple = simple;
            this.name = name;
        }

        public static Board board(String board) {
            if (StringUtils.isNotBlank((CharSequence)board)) {
                for (Board board1 : Board.values()) {
                    if (!board.equals(board1.getSimple())) continue;
                    return board1;
                }
            }
            return null;
        }

        public String getSimple() {
            return this.simple;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class MainBoard
    implements JSONModel {
        private int serial;
        private String board;
        private String serialBoard;
        private String sysType;
        private String sysVersion;
        private String lan;
        private String unique;
        private Date prod = new Date();

        public MainBoard() {
        }

        public MainBoard(String board, String serialBoard, String sysType, String sysVersion, String lan) {
            this.board = board;
            this.serialBoard = serialBoard;
            this.sysType = sysType;
            this.sysVersion = sysVersion;
            this.lan = lan;
        }

        public MainBoard(String board, String serialBoard, String sysType, String sysVersion, String lan, Date prod) {
            this.board = board;
            this.serialBoard = serialBoard;
            this.sysType = sysType;
            this.sysVersion = sysVersion;
            this.lan = lan;
            this.prod = prod;
        }

        public int getSerial() {
            return this.serial;
        }

        public void setSerial(int serial) {
            this.serial = serial;
        }

        public String getBoard() {
            return this.board;
        }

        public void setBoard(String board) {
            this.board = board;
        }

        public String getSerialBoard() {
            return this.serialBoard;
        }

        public void setSerialBoard(String serialBoard) {
            this.serialBoard = serialBoard;
        }

        public String getSysType() {
            return this.sysType;
        }

        public void setSysType(String sysType) {
            this.sysType = sysType;
        }

        public String getSysVersion() {
            return this.sysVersion;
        }

        public void setSysVersion(String sysVersion) {
            this.sysVersion = sysVersion;
        }

        public String getLan() {
            return this.lan;
        }

        public void setLan(String lan) {
            this.lan = lan;
        }

        public String getUnique() {
            return this.unique;
        }

        public void setUnique(String unique) {
            this.unique = unique;
        }

        public Date getProd() {
            return this.prod;
        }

        public void setProd(Date prod) {
            this.prod = prod;
        }
    }

    public static class YSB_Board
    implements BoardStrategy {
        @Override
        public String strategy(MainBoard mainBoard) {
            return StringUtils.isNotBlank((CharSequence)mainBoard.getSerialBoard()) ? mainBoard.getSerialBoard() : "";
        }
    }

    public static class YSA_Board
    implements BoardStrategy {
        @Override
        public String strategy(MainBoard mainBoard) {
            return (StringUtils.isNotBlank((CharSequence)mainBoard.getSerialBoard()) ? mainBoard.getSerialBoard() : "") + (StringUtils.isNotBlank((CharSequence)mainBoard.getLan()) ? mainBoard.getLan() : "");
        }
    }

    public static interface BoardStrategy {
        public String strategy(MainBoard var1) throws GeneralException;
    }
}

