/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.common.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jhscale.common.utils.JSONUtils;
import com.jhscale.common.utils.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.InputSource;

public class XMLUtils {
    private XMLUtils() {
    }

    public static boolean isXML(String xml) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = documentBuilderFactory.newDocumentBuilder();
            builder.parse(new InputSource(new StringReader(xml)));
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static <T> T xmlToObject(String xml, Class<T> clazz) {
        Object xmlObject = null;
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{clazz});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            StringReader sr = new StringReader(xml);
            xmlObject = unmarshaller.unmarshal((Reader)sr);
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        return (T)xmlObject;
    }

    public static String jsonObjectToXML(Object obj) {
        if (Objects.isNull(obj)) {
            return null;
        }
        StringBuilder xml = new StringBuilder();
        if (obj instanceof JSONObject) {
            JSONObject jsonObject2 = (JSONObject)obj;
            jsonObject2.getInnerMap().forEach((k, v) -> {
                if (Objects.nonNull(v)) {
                    xml.append("<").append((String)k).append(">").append(XMLUtils.objToXML(v)).append("</").append((String)k).append(">");
                }
            });
        } else if (obj instanceof JSONArray) {
            JSONArray jsonArray = (JSONArray)obj;
            if (jsonArray.size() > 0) {
                jsonArray.forEach(jsonObject -> {
                    if (Objects.nonNull(jsonObject)) {
                        String name = jsonObject.getClass().getSimpleName();
                        name = StringUtil.firstToLowerCase(name);
                        xml.append("<").append(name).append(">").append(XMLUtils.objToXML(jsonObject)).append("</").append(name).append(">");
                    }
                });
            }
        } else {
            xml.append(obj);
        }
        return xml.toString();
    }

    private static String objToXML(Object obj) {
        if (Objects.isNull(obj)) {
            return null;
        }
        StringBuilder xml = new StringBuilder();
        if (obj instanceof List) {
            List list = (List)obj;
            if (!list.isEmpty()) {
                list.forEach(o -> {
                    if (Objects.nonNull(o)) {
                        String name = o.getClass().getSimpleName();
                        name = StringUtil.firstToLowerCase(name);
                        xml.append("<").append(name).append(">").append(XMLUtils.objToXML(o)).append("</").append(name).append(">");
                    }
                });
            }
        } else if (obj instanceof Map) {
            ((Map)obj).forEach((k, v) -> {
                if (Objects.nonNull(v)) {
                    xml.append("<").append(k).append(">").append(XMLUtils.objToXML(v)).append("</").append(k).append(">");
                }
            });
        } else if (obj instanceof String || obj instanceof Integer || obj instanceof Long || obj instanceof Short || obj instanceof Double || obj instanceof Boolean || obj instanceof BigDecimal || obj instanceof Byte) {
            xml.append(obj.toString());
        } else {
            Field[] fields = obj.getClass().getDeclaredFields();
            if (fields != null && fields.length > 0) {
                for (Field field : fields) {
                    try {
                        field.setAccessible(true);
                        Object o2 = field.get(obj);
                        if (o2 == null) continue;
                        xml.append("<").append(field.getName()).append(">").append(XMLUtils.objToXML(o2)).append("</").append(field.getName()).append(">");
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return xml.toString();
    }

    public static String objectAllToXML(Object bean) {
        if (Objects.isNull(bean)) {
            return null;
        }
        StringBuilder xml = new StringBuilder();
        xml.append("<xml>");
        String objToXML = XMLUtils.objToXML(bean);
        if (StringUtils.isNotBlank((CharSequence)objToXML)) {
            xml.append(objToXML);
        }
        xml.append("</xml>");
        return xml.toString();
    }

    public static String objectToXML(Object bean) {
        if (Objects.isNull(bean)) {
            return null;
        }
        Map map = JSONUtils.objectToObject(bean, Map.class);
        if (Objects.isNull(map) || map.isEmpty()) {
            return null;
        }
        StringBuilder xml = new StringBuilder();
        xml.append("<xml>");
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!StringUtils.isNotBlank((CharSequence)value)) continue;
            xml.append("<").append(key).append(">");
            xml.append((String)entry.getValue());
            xml.append("</").append(key).append(">");
        }
        xml.append("</xml>");
        return xml.toString();
    }

    public static Map<String, Object> xmlToMap(String xml) {
        try {
            SAXReader saxReader = new SAXReader();
            Document document = saxReader.read((InputStream)new ByteArrayInputStream(xml.getBytes()));
            return XMLUtils.Dom2Map(document);
        }
        catch (DocumentException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Map<String, Object> Dom2Map(Document doc) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (doc == null) {
            return map;
        }
        Element root = doc.getRootElement();
        Iterator iterator = root.elementIterator();
        while (iterator.hasNext()) {
            Element e = (Element)iterator.next();
            if (e.elements().size() > 0) {
                map.put(e.getName(), XMLUtils.Dom2Map(e));
                continue;
            }
            map.put(e.getName(), e.getText());
        }
        return map;
    }

    private static Map Dom2Map(Element e) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List list = e.elements();
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                Element iter = (Element)list.get(i);
                List<Map> mapList = new ArrayList<Object>();
                if (iter.elements().size() > 0) {
                    Map m = XMLUtils.Dom2Map(iter);
                    if (map.get(iter.getName()) != null) {
                        Object obj = map.get(iter.getName());
                        if (!obj.getClass().getName().equals("java.util.ArrayList")) {
                            mapList = new ArrayList();
                            mapList.add((Map)obj);
                            mapList.add(m);
                        }
                        if (obj.getClass().getName().equals("java.util.ArrayList")) {
                            mapList = (List)obj;
                            mapList.add(m);
                        }
                        map.put(iter.getName(), mapList);
                        continue;
                    }
                    map.put(iter.getName(), m);
                    continue;
                }
                if (map.get(iter.getName()) != null) {
                    Object obj = map.get(iter.getName());
                    if (!obj.getClass().getName().equals("java.util.ArrayList")) {
                        mapList = new ArrayList();
                        mapList.add((Map)obj);
                        mapList.add((Map)((Object)iter.getText()));
                    }
                    if (obj.getClass().getName().equals("java.util.ArrayList")) {
                        mapList = (List)obj;
                        mapList.add((Map)((Object)iter.getText()));
                    }
                    map.put(iter.getName(), mapList);
                    continue;
                }
                map.put(iter.getName(), iter.getText());
            }
        } else {
            map.put(e.getName(), e.getText());
        }
        return map;
    }
}

