/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.common.utils.paycode;

import com.jhscale.common.utils.paycode.PWDDictionary;
import com.jhscale.common.utils.paycode.PWDDictionaryUtils;
import java.util.ArrayList;
import java.util.List;

public class PWDDictionayBulid {
    private int[] source = PWDDictionaryUtils.dictionary;
    private String prefix;
    private int offset;
    private int length = 100;
    private int size;
    private int version_length = 2;

    public static PWDDictionayBulid getInstance() {
        return new PWDDictionayBulid();
    }

    public PWDDictionayBulid addSource(int[] source) {
        this.source = source;
        return this;
    }

    public PWDDictionayBulid addPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public PWDDictionayBulid addOffset(int offset, int size) {
        this.offset = offset;
        this.size = size;
        return this;
    }

    public PWDDictionayBulid addOffset(String sysversion, int size) {
        this.offset = Integer.parseInt(sysversion);
        this.size = size;
        return this;
    }

    public PWDDictionayBulid addPWDLength(int length) {
        this.length = length;
        return this;
    }

    public PWDDictionayBulid addVersionLength(int version_length) {
        this.version_length = version_length;
        return this;
    }

    public boolean hasNext() {
        return this.size != 0;
    }

    public synchronized PWDDictionary next() {
        PWDDictionary dictionary = new PWDDictionary();
        dictionary.setPrefix(this.prefix);
        dictionary.setUnix(Long.parseLong(String.valueOf(System.currentTimeMillis() / 60000L)));
        dictionary.setEncryptDictionaries(PWDDictionaryUtils.getEncryptDictionaries(this.source, this.length));
        dictionary.setDecryptDictionaries(PWDDictionaryUtils.getDecryptDictionaries(dictionary.getEncryptDictionaries()));
        String version = String.valueOf(this.offset());
        if (version.length() == 1) {
            version = "0" + version;
        }
        dictionary.setVersion(version);
        ++this.offset;
        --this.size;
        return dictionary;
    }

    public List<PWDDictionary> bulid() {
        ArrayList<PWDDictionary> dictionaries = new ArrayList<PWDDictionary>();
        while (this.hasNext()) {
            PWDDictionary next = this.next();
            if (next == null) continue;
            dictionaries.add(next);
        }
        return dictionaries;
    }

    public int offset() {
        return this.offset >= 100 ? this.offset - 100 : this.offset;
    }
}

