/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.common.utils.paycode;

import com.jhscale.common.em.SequenceRule;
import com.jhscale.common.exception.GeneralException;
import com.jhscale.common.exception.GeneralInternational;
import com.jhscale.common.exception.ProfessionalException;
import com.jhscale.common.exception.TechnologyException;
import com.jhscale.common.utils.paycode.Dectyption;
import com.jhscale.common.utils.paycode.Enctyption;
import com.jhscale.common.utils.paycode.IDectyptionActuator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;

public class PaycodeManager {
    private Enctyption enctyption;
    private Dectyption dectyption;
    private Map<Long, Integer> uninMap = new ConcurrentHashMap<Long, Integer>();

    public static PaycodeManager getInstance() {
        return Singleton.paycodeManager;
    }

    public PaycodeManager addEnctyption(Enctyption enctyption) {
        this.enctyption = enctyption;
        return this;
    }

    public PaycodeManager addDectyption(Dectyption dectyption) {
        this.dectyption = dectyption;
        return this;
    }

    public String bulidPaycode(long sign) throws ProfessionalException {
        String pwdversionStr;
        int pwdversion;
        String sysversionStr;
        int sysversion;
        if (Objects.isNull(this.enctyption)) {
            throw new ProfessionalException(GeneralInternational.\u52a0\u5bc6\u5b57\u5178\u4e0d\u5b58\u5728);
        }
        int encryptIndex = (int)(Math.random() * (double)this.enctyption.getEncryptDictionaries().length);
        int[] encryptDictionary = this.enctyption.getEncryptDictionaries()[encryptIndex];
        int frame = (int)(Math.random() * 100.0);
        String frameStr = String.valueOf(frame);
        if (frameStr.length() == 1) {
            frameStr = "0" + frameStr;
        }
        if ((sysversion = this.enctyption.sysversion() + frame) >= 100) {
            sysversion -= 100;
        }
        if ((sysversionStr = String.valueOf(sysversion)).length() == 1) {
            sysversionStr = "0" + sysversionStr;
        }
        if ((pwdversion = encryptIndex + frame) >= 100) {
            pwdversion -= 100;
        }
        if ((pwdversionStr = String.valueOf(pwdversion)).length() == 1) {
            pwdversionStr = "0" + pwdversionStr;
        }
        String signStr = String.valueOf(Integer.parseInt(String.valueOf(sign).substring(4)));
        int appentLen = this.enctyption.getSignLen() - signStr.length();
        if (appentLen < 0) {
            throw new ProfessionalException(GeneralInternational.\u6807\u8bc6\u957f\u5ea6\u8d85\u957f);
        }
        for (int i = 0; i < appentLen; ++i) {
            signStr = i + signStr;
        }
        signStr = appentLen + signStr;
        StringBuffer buffer = new StringBuffer().append(this.enctyption.getPrefix()).append(frameStr).append(sysversionStr).append(pwdversionStr).append(signStr).append(this.bulidTimestamp(frame));
        return buffer.toString();
    }

    public String bulidPaycodeWithEncryption(long sign) throws ProfessionalException {
        String paycode = this.bulidPaycode(sign);
        return this.enctyptionAndDectyption(paycode, this.enctyption.getEncryptDictionaries()[this.paycodePwdversion(paycode)]);
    }

    public String enctyptionAndDectyption(String paycode, int[] dictionary) {
        String content = paycode.substring(8);
        StringBuffer buffer = new StringBuffer(paycode.substring(0, 8));
        for (int i = 0; i < content.length() / 2; ++i) {
            int val = Integer.parseInt(content.substring(i * 2, i * 2 + 2));
            String part = String.valueOf(dictionary[val]);
            if (part.length() % 2 != 0) {
                part = "0" + part;
            }
            buffer.append(part);
        }
        return buffer.toString();
    }

    public synchronized String bulidTimestamp(int frame) throws ProfessionalException {
        String counterStr;
        if (Objects.isNull(this.enctyption)) {
            throw new ProfessionalException(GeneralInternational.\u52a0\u5bc6\u5b57\u5178\u4e0d\u5b58\u5728);
        }
        long min = Long.parseLong(String.valueOf(System.currentTimeMillis() / 60000L));
        long unix = min - this.enctyption.getUnix();
        Integer counter = this.uninMap.get(unix);
        if (counter == null) {
            counter = 1;
            this.uninMap.clear();
            this.uninMap.put(unix, counter);
        } else {
            counter = counter + 1;
            this.uninMap.put(unix, counter);
        }
        String unixStr = String.valueOf(unix);
        int appentLen = 6 - unixStr.length();
        for (int i = 0; i < appentLen; ++i) {
            unixStr = i + unixStr;
        }
        unixStr = appentLen + unixStr;
        int counterval = counter + frame;
        if (counterval >= 100) {
            counterval -= 100;
        }
        if ((counterStr = String.valueOf(counterval)).length() == 1) {
            counterStr = "0" + counterStr;
        }
        return unixStr + counterStr;
    }

    public String paycodeSysversion(String paycode) throws ProfessionalException {
        String sysversion;
        if (StringUtils.isBlank((CharSequence)paycode)) {
            throw new ProfessionalException(GeneralInternational.\u4ed8\u6b3e\u7801\u4e0d\u5b58\u5728);
        }
        int frame = Integer.parseInt(paycode.substring(2, 4));
        int version = Integer.parseInt(paycode.substring(4, 6)) - frame;
        if (version < 0) {
            version += 100;
        }
        if ((sysversion = String.valueOf(version)).length() == 1) {
            sysversion = "0" + sysversion;
        }
        return sysversion;
    }

    public int paycodePwdversion(String paycode) throws ProfessionalException {
        if (StringUtils.isBlank((CharSequence)paycode)) {
            throw new ProfessionalException(GeneralInternational.\u4ed8\u6b3e\u7801\u4e0d\u5b58\u5728);
        }
        int frame = Integer.parseInt(paycode.substring(2, 4));
        int pwdversion = Integer.parseInt(paycode.substring(6, 8)) - frame;
        if (pwdversion < 0) {
            pwdversion += 100;
        }
        return pwdversion;
    }

    public long unpackPaycodeWithDncryption(String paycode) throws ProfessionalException {
        if (StringUtils.isBlank((CharSequence)paycode)) {
            throw new ProfessionalException(GeneralInternational.\u4ed8\u6b3e\u7801\u4e0d\u5b58\u5728);
        }
        if (Objects.isNull(this.dectyption)) {
            throw new ProfessionalException(GeneralInternational.\u89e3\u5bc6\u5b57\u5178\u4e0d\u5b58\u5728);
        }
        paycode = this.enctyptionAndDectyption(paycode, this.dectyption.getDecryptDictionaries()[this.paycodePwdversion(paycode)]);
        return this.unpackPaycode(paycode);
    }

    public long unpackPaycode(String paycode) throws ProfessionalException {
        int pwdversion;
        if (StringUtils.isBlank((CharSequence)paycode)) {
            throw new ProfessionalException(GeneralInternational.\u4ed8\u6b3e\u7801\u4e0d\u5b58\u5728);
        }
        if (Objects.isNull(this.dectyption)) {
            throw new ProfessionalException(GeneralInternational.\u89e3\u5bc6\u5b57\u5178\u4e0d\u5b58\u5728);
        }
        if (!paycode.startsWith(this.dectyption.getPrefix())) {
            throw new ProfessionalException(GeneralInternational.\u4ed8\u6b3e\u7801\u524d\u7f00\u4e0d\u6b63\u786e);
        }
        int frame = Integer.parseInt(paycode.substring(2, 4));
        int sysversion = Integer.parseInt(paycode.substring(4, 6)) - frame;
        if (sysversion < 0) {
            sysversion += 100;
        }
        if ((pwdversion = Integer.parseInt(paycode.substring(6, 8)) - frame) < 0) {
            pwdversion += 100;
        }
        int signAppentLen = Integer.parseInt(paycode.substring(8, 9));
        String signStr = paycode.substring(9, 9 + this.dectyption.getSignLen());
        String timestamp = paycode.substring(9 + this.dectyption.getSignLen());
        this.unpackTimestamp(timestamp, frame);
        signStr = signStr.substring(signAppentLen);
        signAppentLen = 12 - signStr.length();
        for (int i = 0; i < signAppentLen; ++i) {
            signStr = "0" + signStr;
        }
        signStr = SequenceRule.\u5ba2\u6237\u7f16\u53f7.getPrefix() + signStr;
        return Long.parseLong(signStr);
    }

    public long unpackPaycode(IDectyptionActuator actuator, String paycode) throws GeneralException {
        try {
            Object dectyption;
            String sysversionStr;
            if (StringUtils.isBlank((CharSequence)paycode)) {
                throw new ProfessionalException(GeneralInternational.\u4ed8\u6b3e\u7801\u4e0d\u5b58\u5728);
            }
            if (Objects.isNull(actuator)) {
                throw new ProfessionalException(GeneralInternational.\u52a0\u8f7d\u5b57\u5178\u6267\u884c\u5668\u4e0d\u5b58\u5728);
            }
            int frame = Integer.parseInt(paycode.substring(2, 4));
            int sysversion = Integer.parseInt(paycode.substring(4, 6)) - frame;
            if (sysversion < 0) {
                sysversion += 100;
            }
            if ((sysversionStr = String.valueOf(sysversion)).length() == 1) {
                sysversionStr = "0" + sysversionStr;
            }
            if (Objects.isNull(dectyption = actuator.getDictionary(sysversionStr))) {
                throw new ProfessionalException(GeneralInternational.\u89e3\u5bc6\u5b57\u5178\u4e0d\u5b58\u5728);
            }
            if (!paycode.startsWith(((Dectyption)dectyption).getPrefix())) {
                throw new ProfessionalException(GeneralInternational.\u4ed8\u6b3e\u7801\u524d\u7f00\u4e0d\u6b63\u786e);
            }
            int pwdversion = Integer.parseInt(paycode.substring(6, 8)) - frame;
            if (pwdversion < 0) {
                pwdversion += 100;
            }
            paycode = this.enctyptionAndDectyption(paycode, ((Dectyption)dectyption).getDecryptDictionaries()[pwdversion]);
            int signAppentLen = Integer.parseInt(paycode.substring(8, 9));
            String signStr = paycode.substring(9, 9 + ((Dectyption)dectyption).getSignLen());
            String timestamp = paycode.substring(9 + ((Dectyption)dectyption).getSignLen());
            this.unpackTimestamp((Dectyption)dectyption, timestamp, frame);
            signStr = signStr.substring(signAppentLen);
            signAppentLen = 12 - signStr.length();
            for (int i = 0; i < signAppentLen; ++i) {
                signStr = "0" + signStr;
            }
            signStr = SequenceRule.\u5ba2\u6237\u7f16\u53f7.getPrefix() + signStr;
            long usSign = Long.parseLong(signStr);
            actuator.otherCheck(dectyption, paycode, usSign);
            return usSign;
        }
        catch (ProfessionalException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TechnologyException((Throwable)e, GeneralInternational.\u4ed8\u6b3e\u7801\u89e3\u6790\u5931\u8d25);
        }
    }

    public long unpackPaycode(Dectyption dectyption, String paycode) throws ProfessionalException {
        int pwdversion;
        if (StringUtils.isBlank((CharSequence)paycode)) {
            throw new ProfessionalException(GeneralInternational.\u4ed8\u6b3e\u7801\u4e0d\u5b58\u5728);
        }
        if (Objects.isNull(dectyption)) {
            throw new ProfessionalException(GeneralInternational.\u89e3\u5bc6\u5b57\u5178\u4e0d\u5b58\u5728);
        }
        if (!paycode.startsWith(dectyption.getPrefix())) {
            throw new ProfessionalException(GeneralInternational.\u4ed8\u6b3e\u7801\u524d\u7f00\u4e0d\u6b63\u786e);
        }
        int frame = Integer.parseInt(paycode.substring(2, 4));
        int sysversion = Integer.parseInt(paycode.substring(4, 6)) - frame;
        if (sysversion < 0) {
            sysversion += 100;
        }
        if ((pwdversion = Integer.parseInt(paycode.substring(6, 8)) - frame) < 0) {
            pwdversion += 100;
        }
        int signAppentLen = Integer.parseInt(paycode.substring(8, 9));
        String signStr = paycode.substring(9, 9 + dectyption.getSignLen());
        String timestamp = paycode.substring(9 + dectyption.getSignLen());
        this.unpackTimestamp(dectyption, timestamp, frame);
        signStr = signStr.substring(signAppentLen);
        signAppentLen = 12 - signStr.length();
        for (int i = 0; i < signAppentLen; ++i) {
            signStr = "0" + signStr;
        }
        signStr = SequenceRule.\u5ba2\u6237\u7f16\u53f7.getPrefix() + signStr;
        return Long.parseLong(signStr);
    }

    public long unpackTimestamp(String timestamp, int frame) throws ProfessionalException {
        if (StringUtils.isBlank((CharSequence)timestamp)) {
            throw new ProfessionalException(GeneralInternational.\u4ed8\u6b3e\u7801\u4e0d\u5b58\u5728);
        }
        if (Objects.isNull(this.dectyption)) {
            throw new ProfessionalException(GeneralInternational.\u89e3\u5bc6\u5b57\u5178\u4e0d\u5b58\u5728);
        }
        int timestampAppentLen = Integer.parseInt(timestamp.substring(0, 1));
        String timestampPart = timestamp.substring(timestampAppentLen + 1, timestamp.length() - 2);
        int counter = Integer.parseInt(timestamp.substring(timestamp.length() - 2));
        if ((counter -= frame) < 0) {
            counter += 100;
        }
        if ((long)counter > this.dectyption.getMinMax()) {
            throw new ProfessionalException(GeneralInternational.\u4ed8\u6b3e\u7801\u9891\u7387\u8d85\u9650);
        }
        long paytimestamp = Long.parseLong(timestampPart) + this.dectyption.getUnix();
        long nowtimestamp = Long.parseLong(String.valueOf(System.currentTimeMillis() / 60000L));
        long timeDiff = nowtimestamp - paytimestamp;
        if (timeDiff < 0L) {
            throw new ProfessionalException(GeneralInternational.\u4ed8\u6b3e\u7801\u65e0\u6548);
        }
        if (timeDiff > this.dectyption.getInvalid()) {
            throw new ProfessionalException(GeneralInternational.\u4ed8\u6b3e\u7801\u8fc7\u671f);
        }
        return paytimestamp;
    }

    public long unpackTimestamp(Dectyption dectyption, String timestamp, int frame) throws ProfessionalException {
        if (StringUtils.isBlank((CharSequence)timestamp)) {
            throw new ProfessionalException(GeneralInternational.\u4ed8\u6b3e\u7801\u4e0d\u5b58\u5728);
        }
        if (Objects.isNull(dectyption)) {
            throw new ProfessionalException(GeneralInternational.\u89e3\u5bc6\u5b57\u5178\u4e0d\u5b58\u5728);
        }
        int timestampAppentLen = Integer.parseInt(timestamp.substring(0, 1));
        String timestampPart = timestamp.substring(timestampAppentLen + 1, timestamp.length() - 2);
        int counter = Integer.parseInt(timestamp.substring(timestamp.length() - 2));
        if ((counter -= frame) < 0) {
            counter += 100;
        }
        if ((long)counter > dectyption.getMinMax()) {
            throw new ProfessionalException(GeneralInternational.\u4ed8\u6b3e\u7801\u9891\u7387\u8d85\u9650);
        }
        long paytimestamp = Long.parseLong(timestampPart) + dectyption.getUnix();
        long nowtimestamp = Long.parseLong(String.valueOf(System.currentTimeMillis() / 60000L));
        long timeDiff = nowtimestamp - paytimestamp;
        if (timeDiff < 0L) {
            throw new ProfessionalException(GeneralInternational.\u4ed8\u6b3e\u7801\u65e0\u6548);
        }
        if (timeDiff > dectyption.getInvalid()) {
            throw new ProfessionalException(GeneralInternational.\u4ed8\u6b3e\u7801\u8fc7\u671f);
        }
        return paytimestamp;
    }

    private static class Singleton {
        private static PaycodeManager paycodeManager = new PaycodeManager();

        private Singleton() {
        }
    }
}

