/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.common.ysscale;

import com.jhscale.common.model.device.UnitType;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public enum UnitEnum {
    \u8ba1\u91cd("1", UnitType.\u8ba1\u91cd, "\u91cd\u91cf"),
    \u8ba1\u4ef6("2", UnitType.\u8ba1\u4ef6, "\u4ef6"),
    kg("3", UnitType.\u8ba1\u91cd, "kg"),
    g("4", UnitType.\u8ba1\u91cd, "g"),
    ton("5", UnitType.\u8ba1\u91cd, "ton"),
    lb("6", UnitType.\u8ba1\u91cd, "lb"),
    g500("7", UnitType.\u8ba1\u91cd, "500g"),
    g100("8", UnitType.\u8ba1\u91cd, "100g"),
    lb1_4("9", UnitType.\u8ba1\u91cd, "1/4lb");

    private final String val;
    private final UnitType type;
    private final String name;

    private UnitEnum(String val, UnitType type, String name) {
        this.val = val;
        this.type = type;
        this.name = name;
    }

    public static UnitEnum unit(Integer unit) {
        if (Objects.nonNull(unit)) {
            for (UnitEnum unitEnum : UnitEnum.values()) {
                if (!unit.equals(Integer.parseInt(unitEnum.getVal()))) continue;
                return unitEnum;
            }
        }
        return \u8ba1\u4ef6;
    }

    public static UnitEnum unit(String unit) {
        if (StringUtils.isNotBlank((CharSequence)unit)) {
            for (UnitEnum unitEnum : UnitEnum.values()) {
                if (!unitEnum.getVal().equals(unit)) continue;
                return unitEnum;
            }
        }
        return \u8ba1\u4ef6;
    }

    public static UnitEnum name(String name) {
        if (StringUtils.isNotBlank((CharSequence)name)) {
            for (UnitEnum unitEnum : UnitEnum.values()) {
                if (!unitEnum.getName().equalsIgnoreCase(name)) continue;
                return unitEnum;
            }
        }
        return \u8ba1\u4ef6;
    }

    public static BigDecimal EcsCal_Unit_Value_Kg_Convert(BigDecimal value, UnitEnum oldUnit) {
        UnitEnum newUnit = UnitType.\u8ba1\u4ef6.equals((Object)oldUnit.getType()) ? \u8ba1\u4ef6 : kg;
        BigDecimal val = UnitEnum.EcsCal_Unit_ValueConvert(value, oldUnit, newUnit);
        if (UnitType.\u8ba1\u4ef6.equals((Object)newUnit.getType())) {
            return val.setScale(0, RoundingMode.HALF_UP);
        }
        return val.setScale(3, RoundingMode.HALF_UP);
    }

    public static BigDecimal EcsCal_Unit_ValueConvert_Format(BigDecimal value, UnitEnum oldUnit, UnitEnum newUnit) {
        BigDecimal val = UnitEnum.EcsCal_Unit_ValueConvert(value, oldUnit, newUnit);
        if (UnitType.\u8ba1\u4ef6.equals((Object)newUnit.getType())) {
            return val.setScale(0, RoundingMode.HALF_UP);
        }
        return val.setScale(3, RoundingMode.HALF_UP);
    }

    public static BigDecimal EcsCal_Unit_ValueConvert(BigDecimal value, UnitEnum oldUnit, UnitEnum newUnit) {
        if (Objects.isNull((Object)oldUnit) || Objects.isNull((Object)newUnit)) {
            return value;
        }
        if (oldUnit.equals((Object)newUnit)) {
            return value;
        }
        if (\u8ba1\u91cd.equals((Object)oldUnit) || \u8ba1\u91cd.equals((Object)newUnit)) {
            return value;
        }
        BigDecimal oldpack = UnitEnum.EcsCal_Unit_LoadPack(oldUnit);
        if (oldpack.compareTo(BigDecimal.ZERO) == 0) {
            return value;
        }
        BigDecimal newpack = UnitEnum.EcsCal_Unit_LoadPack(newUnit);
        if (newpack.compareTo(BigDecimal.ZERO) == 0) {
            return value;
        }
        return value.multiply(oldpack).divide(newpack, 7, RoundingMode.HALF_UP);
    }

    private static BigDecimal EcsCal_Unit_LoadPack(UnitEnum unit) {
        if (\u8ba1\u4ef6.equals((Object)unit)) {
            return new BigDecimal(1000);
        }
        if (unit.val() < 2 || unit.val() > 9) {
            return new BigDecimal(1000);
        }
        if (unit.val() == 3) {
            return new BigDecimal("1000");
        }
        if (unit.val() == 4) {
            return new BigDecimal("1");
        }
        if (unit.val() == 5) {
            return new BigDecimal("1000000");
        }
        if (unit.val() == 6) {
            return new BigDecimal("453.592");
        }
        if (unit.val() == 7) {
            return new BigDecimal("500");
        }
        if (unit.val() == 8) {
            return new BigDecimal("100");
        }
        if (unit.val() == 9) {
            return new BigDecimal("113.398");
        }
        return new BigDecimal(1000);
    }

    public String getVal() {
        return this.val;
    }

    public Integer val() {
        return Integer.valueOf(this.val);
    }

    public UnitType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }
}

