/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.test.biz;

import com.jhscale.common.exception.GeneralException;
import com.jhscale.common.exception.ProfessionalException;
import com.jhscale.common.model.simple.JSONModel;
import com.jhscale.common.utils.JSONUtils;
import com.jhscale.common.utils.paycode.Dectyption;
import com.jhscale.common.utils.paycode.Enctyption;
import com.jhscale.common.utils.paycode.IDectyptionActuator;
import com.jhscale.common.utils.paycode.PWDDictionary;
import com.jhscale.common.utils.paycode.PWDDictionaryUtils;
import com.jhscale.common.utils.paycode.PWDDictionayBulid;
import com.jhscale.common.utils.paycode.PaycodeManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class PaycodeTest {
    public static void main(String[] args) throws Exception {
        PaycodeTest.unpackPaycode2();
    }

    private static void unpackPaycode2() throws GeneralException {
        long l = PaycodeManager.getInstance().unpackPaycode(new IDectyptionActuator(){

            public Dectyption getDictionary(String sysversion) {
                try {
                    int len = 0;
                    char[] buffer = new char[1024];
                    InputStreamReader inputStream = new InputStreamReader(new FileInputStream(new File("E:\\JHScale\\Resources\\codebook-prod.json")));
                    StringBuffer sb = new StringBuffer();
                    while (-1 != (len = inputStream.read(buffer))) {
                        sb.append(new String(buffer, 0, len));
                    }
                    Dectyption dectyption = JSONUtils.jsonToObject(sb.toString(), Dectyption.class);
                    return dectyption;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }, "887639374321950051353920");
        System.out.println(l);
    }

    private static void parseTextcode() {
        String text = "[[47,73,69,20,52,35,39,66,79,72,43,32,29,36,93,77,61,54,91,62,64,0,97,22,13,6,19,95,51,71,1,68,10,83,4,60,80,58,14,94,38,11,34,99,75,63,55,76,74,65,49,2,8,17,45,50,87,15,7,3,23,25,12,46,85,57,98,40,88,82,44,89,18,67,81,5,86,70,84,78,37,21,92,48,59,16,28,31,27,24,42,53,30,33,9,56,26,96,90,41],[6,76,16,64,31,10,80,20,99,2,1,0,71,3,34,74,57,93,13,26,29,87,4,33,94,59,9,79,98,41,73,30,12,96,22,51,61,32,53,19,69,42,50,48,43,40,37,88,8,5,83,63,58,81,70,91,78,72,25,23,86,77,89,11,62,27,14,46,18,45,84,36,47,97,67,92,66,7,38,75,60,90,17,82,68,85,44,21,95,56,15,24,54,52,35,65,39,49,28,55],[47,27,91,7,56,75,86,13,90,40,26,69,39,99,17,1,63,97,33,79,29,96,42,48,78,5,66,4,95,94,74,67,58,64,53,25,50,24,62,60,8,35,43,65,38,31,68,87,93,28,32,57,55,61,23,44,3,88,16,80,51,83,10,84,6,73,59,21,0,82,11,85,89,15,41,30,77,81,19,34,2,49,46,9,98,36,70,92,76,72,71,18,22,12,14,54,20,37,45,52],[37,21,83,44,81,51,65,89,91,60,57,36,20,82,88,94,77,72,87,92,53,68,86,38,95,71,84,2,39,46,56,3,98,40,80,28,9,18,79,52,69,15,13,22,7,24,58,74,11,85,25,23,76,27,29,67,12,48,17,34,49,64,99,55,78,73,63,54,6,4,62,93,14,16,26,41,0,75,43,1,45,47,97,19,70,61,66,59,33,5,50,90,8,10,96,35,31,30,32,42],[61,44,97,89,12,65,22,10,53,81,93,52,86,75,63,49,11,24,48,88,21,50,62,8,90,47,14,70,18,78,66,17,42,0,19,69,36,38,56,67,73,34,29,68,9,96,30,13,27,77,84,58,98,37,43,6,76,95,85,4,7,28,23,25,39,60,94,74,41,3,55,79,31,15,32,82,80,99,2,72,64,57,92,26,87,83,33,1,5,51,20,91,40,59,35,54,71,16,45,46],[8,86,15,83,70,63,90,66,34,9,36,3,67,95,85,75,50,22,6,21,52,47,25,69,5,72,61,18,28,58,46,45,29,96,76,31,11,32,84,53,27,73,33,20,37,71,51,79,7,35,97,13,39,30,88,41,77,16,40,48,59,17,26,57,10,74,92,44,62,19,80,81,78,49,42,4,60,93,68,2,87,91,65,38,0,99,14,94,23,54,43,64,98,89,56,1,55,82,24,12],[46,65,78,39,11,83,35,45,58,85,53,10,62,43,76,55,56,89,22,75,64,48,49,41,24,95,32,5,77,37,73,91,1,87,25,82,47,81,93,9,18,52,80,17,66,15,31,44,30,88,94,79,74,60,13,7,19,2,59,99,72,90,38,57,27,40,71,70,84,23,12,69,33,16,34,29,50,97,0,92,86,20,8,98,28,26,6,4,42,68,14,36,96,51,67,63,54,61,21,3],[76,33,95,26,6,56,30,31,9,78,98,32,59,8,74,25,63,14,70,34,53,66,27,15,37,88,93,45,75,29,11,2,52,61,41,54,72,10,16,79,51,1,86,89,50,40,82,20,36,48,67,90,77,4,42,21,60,24,84,17,43,69,83,91,38,85,49,28,80,81,13,71,23,3,55,73,58,22,44,18,46,68,57,19,39,5,94,99,35,7,97,87,92,96,65,12,0,47,62,64],[44,13,25,11,87,57,84,49,33,40,21,47,98,15,34,41,9,69,16,58,55,80,65,70,83,20,27,66,76,35,96,81,46,31,52,79,97,63,90,7,62,78,51,48,6,28,85,56,75,30,26,8,42,88,60,77,10,73,12,89,23,43,3,29,74,72,61,5,68,39,0,14,86,32,53,94,50,45,93,24,59,36,92,54,18,91,37,1,4,82,2,71,17,22,19,95,38,64,99,67],[54,3,36,63,39,69,66,74,0,12,79,71,32,57,20,9,87,40,78,80,48,90,41,60,92,91,46,99,10,13,33,89,11,23,29,58,75,37,38,96,49,94,25,50,21,88,19,8,83,70,17,42,73,98,18,84,82,62,27,45,22,64,61,72,55,7,2,6,52,86,67,51,85,59,43,47,16,15,24,4,56,30,81,26,34,76,53,65,77,68,97,35,44,31,1,5,28,14,93,95],[76,51,19,34,49,41,6,29,88,71,35,39,43,91,98,15,36,66,82,89,45,2,1,77,33,24,56,53,28,31,5,4,87,96,12,3,20,10,40,8,85,18,67,78,64,52,9,27,70,0,50,90,13,38,86,83,37,74,95,42,32,47,72,16,55,75,59,17,62,63,7,46,84,11,73,92,30,79,97,81,99,60,22,54,93,57,94,58,26,21,48,14,23,61,69,68,44,65,80,25],[63,57,99,61,21,7,51,67,2,24,1,87,39,40,72,90,54,26,49,89,5,82,33,20,6,80,88,44,8,70,30,18,3,55,91,17,10,37,31,13,12,71,48,97,69,29,96,9,83,22,11,76,86,38,84,34,42,45,60,16,32,93,62,46,68,23,98,0,58,94,81,41,85,77,28,4,27,15,79,75,47,66,65,73,95,14,64,74,50,78,52,35,59,92,19,53,43,36,25,56],[20,78,26,99,23,14,10,53,58,92,81,8,60,4,83,6,43,96,91,63,19,41,39,62,66,25,69,29,57,42,37,72,84,33,61,48,50,2,56,67,5,54,13,82,24,12,70,94,40,0,21,11,30,75,88,36,46,86,38,90,77,51,73,9,35,68,47,7,65,79,32,98,89,3,76,28,80,18,64,71,17,45,16,27,49,87,15,95,74,1,52,59,22,55,34,31,97,44,93,85],[27,93,7,28,87,47,33,30,43,96,2,31,40,78,86,0,55,45,58,52,9,77,83,41,35,90,13,74,59,20,53,70,98,32,92,21,82,26,68,19,72,48,42,17,75,36,69,22,16,5,84,39,18,63,54,57,99,14,50,10,80,11,34,23,8,4,85,65,94,62,46,44,66,15,6,3,88,61,89,71,51,64,67,37,76,38,95,25,29,12,1,81,60,73,24,49,91,97,79,56],[52,32,97,31,53,43,24,7,68,74,99,55,63,0,45,84,80,93,98,11,65,4,39,38,79,3,87,89,57,50,66,51,46,77,69,37,72,56,1,13,47,41,23,48,8,95,49,76,88,42,20,70,35,67,30,14,91,26,12,36,60,96,2,85,17,94,33,62,44,61,10,21,5,90,82,25,64,81,54,18,40,58,71,29,83,78,34,28,75,9,15,92,73,19,27,22,86,59,16,6],[37,67,77,92,24,99,88,12,22,74,21,69,17,95,20,49,30,79,19,9,48,3,44,96,65,11,91,16,76,56,47,15,2,32,0,93,42,39,34,54,31,75,51,52,81,1,71,36,53,18,72,87,43,90,4,8,62,73,55,5,10,89,97,27,86,50,29,60,25,23,40,61,85,38,64,58,46,82,94,28,80,68,84,13,33,45,7,57,59,66,78,6,14,98,83,26,70,35,41,63],[44,62,39,28,7,14,56,93,86,13,22,49,60,18,46,87,91,54,1,19,2,83,73,10,41,25,92,8,15,55,24,84,11,33,99,64,82,74,51,36,4,61,48,47,88,42,69,5,95,50,43,85,78,96,79,52,66,57,68,0,17,12,53,63,71,72,45,80,97,77,38,40,98,26,34,67,30,94,31,76,75,81,21,16,70,9,20,89,3,37,32,35,6,65,58,27,23,29,59,90],[69,24,30,7,53,27,87,6,80,41,74,91,65,14,48,3,61,62,57,68,50,22,4,55,84,70,36,18,71,5,75,86,26,33,66,32,92,67,58,8,56,20,60,52,49,19,96,0,64,97,1,82,73,29,10,9,23,81,15,47,38,2,94,11,77,83,34,28,35,40,79,78,93,72,31,85,88,25,90,99,43,59,54,95,46,16,21,63,98,45,39,17,51,89,44,12,37,42,13,76],[61,22,24,86,81,3,31,75,74,48,80,39,43,5,72,88,30,90,6,46,93,52,92,12,84,35,73,25,1,36,58,44,51,94,98,63,26,66,59,89,77,65,82,40,42,54,9,95,15,83,68,41,53,14,8,49,23,78,34,62,18,85,19,20,45,38,97,4,0,69,10,28,50,57,37,55,76,67,32,29,11,71,87,64,7,47,16,13,2,17,91,21,96,99,56,33,27,79,70,60],[24,2,62,99,74,83,66,92,41,16,77,63,45,14,22,84,79,75,19,54,31,87,4,65,46,70,43,1,23,11,3,53,89,30,39,60,97,32,86,76,81,91,9,93,90,78,80,69,0,38,67,98,13,42,51,37,29,20,36,72,96,61,28,68,25,48,64,85,5,88,21,50,8,7,26,10,73,18,56,47,58,27,82,34,94,33,52,71,44,17,49,12,95,6,35,57,55,15,40,59],[84,82,86,94,8,49,32,91,28,61,10,11,60,18,99,4,74,36,44,14,85,7,17,30,59,33,67,19,16,21,95,93,57,66,97,3,35,83,5,88,80,79,70,75,24,78,38,98,76,29,0,77,9,71,55,68,89,50,34,27,20,12,72,48,23,40,47,87,25,46,58,73,26,63,64,42,15,62,51,81,22,90,1,54,96,13,2,6,37,69,45,43,41,65,31,92,39,56,53,52],[65,22,1,25,8,32,24,56,82,80,48,67,96,34,15,57,10,52,92,16,18,7,21,36,3,93,69,89,78,40,45,37,6,41,86,2,39,44,50,76,49,54,46,26,42,28,81,12,31,91,75,71,95,59,60,97,66,61,83,29,72,4,33,11,13,62,87,38,77,79,84,68,55,43,70,90,64,27,53,94,74,98,99,14,0,19,51,17,58,30,63,20,9,35,5,73,47,85,88,23],[8,9,24,23,49,38,3,39,93,81,99,15,32,85,10,36,84,41,46,40,18,91,94,19,12,7,92,11,60,35,65,14,1,74,25,22,87,28,33,56,76,17,63,50,48,31,68,89,61,55,97,57,67,52,20,37,62,27,90,86,2,47,26,16,29,70,69,59,45,72,82,34,53,4,21,6,54,51,71,79,88,66,78,83,98,64,58,5,75,13,43,30,80,95,77,96,73,42,0,44],[96,63,7,56,69,78,40,33,92,62,45,50,30,90,85,88,38,21,83,27,77,5,41,34,15,70,29,86,55,19,42,76,71,18,10,0,46,94,11,20,31,61,28,68,57,35,73,82,23,4,37,52,22,74,54,91,2,81,26,60,58,65,25,66,14,84,89,59,16,53,93,44,79,99,80,47,51,67,36,3,43,64,9,48,98,1,97,8,6,87,24,75,49,17,13,72,39,95,32,12],[50,4,69,12,61,20,94,41,14,31,71,89,11,87,73,51,43,66,76,33,53,25,46,67,27,30,72,65,1,40,88,19,37,55,23,95,82,42,77,93,24,74,70,85,3,98,91,7,80,58,5,28,18,29,78,44,56,54,99,83,34,62,13,39,21,48,26,79,0,60,6,36,15,8,9,52,32,35,92,59,75,68,45,81,10,97,96,90,84,17,22,57,38,63,49,64,86,16,2,47],[37,72,82,91,77,97,86,94,46,6,49,63,10,41,22,15,85,20,59,64,48,87,54,28,8,74,38,2,31,81,26,12,42,24,14,66,39,58,70,17,51,93,80,57,60,78,79,40,71,62,32,13,25,55,99,27,61,83,67,45,3,43,50,4,65,76,0,56,89,23,5,84,33,96,69,68,18,95,1,47,92,16,53,29,21,7,88,19,73,75,98,36,34,30,11,9,90,35,52,44],[16,18,96,90,56,0,65,3,52,4,68,41,73,81,43,22,98,38,94,74,39,91,6,27,83,57,47,77,37,42,82,59,48,87,84,24,19,58,7,54,72,44,70,13,55,34,92,51,71,9,93,23,29,11,63,76,75,49,78,10,66,12,45,40,2,60,50,89,21,5,46,97,85,88,99,53,35,14,25,28,30,61,69,33,95,26,79,15,80,36,20,62,86,64,1,8,67,17,32,31],[57,52,54,86,77,22,11,17,15,72,39,53,76,61,31,2,62,82,23,9,1,26,18,20,79,94,24,51,5,55,3,92,6,32,46,4,13,71,43,97,64,14,0,42,35,95,74,66,30,33,85,8,37,83,34,36,73,87,90,50,16,41,80,69,38,40,91,10,28,88,25,63,99,47,19,67,44,27,89,58,56,45,68,60,29,49,21,70,59,7,96,93,84,65,98,78,81,48,12,75],[2,19,75,46,18,54,97,91,11,10,77,32,93,88,42,51,44,41,78,86,68,24,71,8,59,9,38,56,23,67,84,17,98,73,82,16,65,81,60,94,79,1,69,26,34,21,80,63,66,87,83,61,25,57,4,85,29,39,27,33,92,96,50,47,22,99,64,37,14,89,3,28,15,72,13,40,35,7,76,0,12,95,62,36,52,30,70,90,53,20,45,58,31,5,55,6,74,43,49,48],[98,22,37,51,34,49,17,80,32,65,68,55,25,45,26,63,29,86,71,75,8,9,11,96,89,42,82,38,77,72,23,57,13,41,12,73,4,93,94,81,28,20,33,47,40,43,18,91,31,62,27,97,56,76,69,70,60,5,87,88,85,15,36,83,59,52,66,64,3,21,24,58,95,30,10,6,90,44,54,1,61,14,78,2,16,7,99,0,46,92,74,84,53,67,79,35,50,19,39,48],[36,39,45,89,23,57,99,79,95,72,21,44,13,54,22,32,16,74,98,65,25,78,75,14,80,52,88,20,59,55,49,90,3,86,18,73,81,69,8,56,34,85,70,60,51,17,42,48,43,96,2,40,41,91,63,46,50,76,7,92,6,9,58,94,66,87,30,19,5,93,35,28,84,68,82,4,11,37,33,1,53,10,26,71,12,27,47,29,31,64,97,83,62,0,15,77,24,38,61,67],[34,56,64,41,32,42,78,30,50,25,27,91,67,69,4,29,55,49,22,89,39,3,90,97,24,19,26,6,31,53,76,10,68,58,23,82,71,43,65,95,96,44,77,93,28,98,70,54,81,16,46,59,7,18,85,8,2,11,66,62,94,1,45,35,40,88,12,83,72,60,61,20,15,92,33,73,52,51,0,36,79,75,14,57,86,38,80,74,48,87,13,37,17,99,63,21,47,5,84,9],[49,15,36,45,52,24,39,60,8,21,90,72,54,35,57,47,95,74,22,34,13,20,76,99,86,14,68,62,4,63,85,59,58,71,30,84,89,55,0,44,73,77,1,26,2,41,42,51,9,3,27,18,78,40,33,64,53,66,7,32,19,48,67,79,50,75,82,88,98,96,12,37,81,70,65,87,92,46,11,16,6,23,91,10,29,5,61,25,43,80,28,56,83,17,38,97,31,93,94,69],[44,40,29,57,18,25,21,80,19,30,47,39,5,46,64,53,20,82,9,13,6,49,65,7,99,67,17,74,35,10,81,45,15,97,63,75,51,92,94,98,66,77,3,90,83,33,56,36,23,96,62,87,71,69,88,61,50,55,28,27,79,68,78,42,43,91,11,2,32,26,41,16,14,52,24,54,95,37,0,58,70,59,48,86,89,73,4,38,34,76,85,31,22,72,8,12,84,93,60,1],[39,98,86,32,29,27,8,77,80,97,57,95,90,40,24,51,78,34,81,9,15,38,63,3,22,88,7,89,46,64,14,1,62,48,0,92,91,19,11,76,74,4,55,66,31,75,2,65,37,12,70,49,69,10,20,23,71,35,61,84,96,13,42,6,59,36,17,43,16,45,47,94,68,93,82,54,26,28,72,99,67,53,73,85,50,33,56,41,21,5,25,18,79,83,52,60,44,58,30,87],[17,25,64,0,24,58,30,97,93,9,28,50,22,92,19,46,52,1,18,70,87,98,82,31,77,76,4,12,94,39,53,80,13,8,3,2,21,14,27,99,5,36,11,88,56,81,85,86,89,44,42,51,49,15,72,7,45,57,73,20,47,16,95,35,66,32,48,10,54,74,71,26,34,43,40,37,60,67,55,84,59,75,90,23,38,91,96,69,33,83,63,79,78,62,41,68,65,6,61,29],[71,13,11,56,30,5,28,61,7,93,22,70,27,43,45,95,63,18,0,50,10,32,14,62,48,86,74,72,96,15,66,83,23,69,26,73,9,52,80,79,77,25,60,75,81,67,38,46,55,17,35,12,84,6,21,37,53,88,68,39,92,36,24,94,64,47,44,76,40,42,89,85,49,90,29,41,4,54,58,2,99,65,59,20,19,91,87,16,33,97,57,82,31,98,8,51,3,34,78,1],[5,73,17,51,95,90,43,63,81,15,87,7,9,56,4,53,24,61,75,50,55,84,68,93,40,27,46,91,98,66,25,67,72,57,60,74,30,45,34,99,47,10,86,0,28,44,64,32,59,22,89,19,41,2,70,36,16,82,11,39,79,42,71,62,48,1,26,14,54,13,20,92,76,69,12,94,8,31,52,18,21,3,85,35,29,33,88,23,80,37,38,49,78,6,77,97,65,58,96,83],[5,9,4,92,14,2,80,34,60,98,87,15,82,45,76,71,91,30,23,72,39,42,49,29,73,61,44,50,51,17,1,65,6,78,27,58,68,66,37,7,47,43,25,32,67,95,56,48,88,41,13,53,81,22,18,75,16,0,55,12,31,96,62,8,35,28,10,19,86,93,70,84,46,83,20,11,36,52,54,21,64,24,3,40,38,90,33,26,57,89,85,74,97,77,63,69,79,99,59,94],[84,40,86,22,9,45,62,23,61,55,91,11,63,71,25,60,68,51,95,49,5,36,21,54,24,13,56,30,18,87,70,2,64,31,1,75,41,65,15,80,7,52,39,66,14,69,3,94,76,77,81,12,85,98,93,97,83,46,53,8,96,73,37,10,59,32,48,17,88,43,4,67,19,16,28,58,57,33,27,29,92,82,99,47,26,78,6,38,90,20,72,44,35,79,0,50,89,42,74,34],[43,92,44,80,62,0,56,70,77,58,3,14,12,71,4,39,25,49,31,30,69,38,13,89,29,91,95,26,34,83,86,16,18,73,90,22,67,60,27,87,19,24,63,57,20,5,65,21,55,41,52,32,35,53,7,37,59,28,99,61,50,74,51,2,97,72,40,47,79,66,88,98,78,11,96,23,68,17,93,1,10,84,75,36,8,45,82,15,48,46,33,64,42,54,85,94,81,76,6,9],[66,88,75,39,94,56,60,37,95,51,9,23,16,49,32,64,65,77,5,69,59,76,27,42,6,4,84,98,15,96,67,8,38,47,78,24,19,45,73,91,21,93,36,46,25,70,35,71,11,97,68,34,26,22,3,87,90,52,0,54,2,57,53,99,28,33,92,40,80,89,41,30,13,29,1,55,31,48,79,63,18,44,43,17,58,83,20,82,10,86,72,14,61,12,7,74,62,81,50,85],[36,25,13,7,40,50,37,28,4,72,1,6,99,51,22,61,29,70,41,91,94,23,80,49,53,30,38,27,12,83,0,8,18,16,26,71,63,90,47,60,64,85,35,42,58,59,82,88,21,45,52,86,44,43,66,33,87,81,5,89,84,54,78,56,46,75,55,31,95,98,65,67,57,93,39,3,15,34,10,96,2,17,24,73,32,19,20,48,9,69,62,74,76,77,79,11,97,14,92,68],[16,55,91,43,93,76,85,71,97,36,41,23,87,15,40,25,39,66,35,72,95,4,5,73,17,88,62,65,26,77,32,68,78,80,63,19,75,3,54,33,22,96,9,52,61,21,1,44,49,47,50,10,24,27,53,29,92,90,18,83,38,74,98,12,86,34,82,59,0,13,70,81,45,37,64,89,69,51,60,20,7,31,67,11,8,84,79,6,57,94,58,48,2,42,28,30,99,46,14,56],[52,96,33,16,40,22,4,3,76,50,79,15,99,38,26,37,12,35,25,72,42,70,0,93,65,58,77,30,51,55,78,56,49,71,86,21,69,19,9,41,43,90,14,61,87,74,88,73,20,6,27,92,17,48,62,44,46,60,54,63,1,7,85,31,8,5,47,36,91,2,98,53,10,82,57,39,68,66,94,28,81,29,97,23,84,75,13,34,32,67,64,45,89,95,59,80,18,11,24,83],[20,48,5,59,85,66,2,0,24,98,8,35,30,72,43,17,83,69,6,39,1,53,79,21,46,56,31,4,23,13,71,78,73,44,26,74,94,92,49,41,3,81,68,82,76,57,29,47,95,58,50,14,18,67,99,62,88,38,70,61,77,93,65,32,12,51,34,63,91,37,96,25,40,84,60,19,86,97,15,90,22,11,55,42,87,64,52,9,80,16,89,45,28,33,7,10,36,75,27,54],[52,34,62,12,78,46,40,99,57,10,80,82,42,22,81,61,68,38,32,63,1,39,85,91,93,49,35,31,37,19,43,44,18,74,17,6,71,79,96,75,0,23,14,58,29,89,8,11,16,60,70,98,86,69,47,27,26,87,4,92,94,3,41,88,24,97,25,21,77,2,90,45,20,65,66,30,72,54,84,33,48,7,55,13,76,56,28,53,73,95,83,67,15,51,5,59,64,9,50,36],[4,43,11,56,82,73,95,6,99,65,97,87,17,52,25,47,40,89,12,41,31,93,21,78,77,5,9,68,58,15,69,36,50,81,71,80,53,83,90,44,48,42,33,8,91,88,10,84,92,0,60,66,37,51,24,39,30,22,1,29,61,18,59,46,76,62,70,16,45,26,19,38,86,75,55,7,96,35,2,13,27,23,74,85,94,79,20,32,14,3,54,63,98,64,49,67,57,34,72,28],[37,90,45,16,96,92,54,91,1,53,58,36,35,60,43,44,72,17,74,98,61,51,75,24,50,83,93,12,13,73,80,57,86,33,47,64,89,70,67,42,40,87,6,82,59,95,85,22,9,15,68,29,28,81,26,55,65,97,76,62,18,77,11,30,79,66,7,38,69,48,2,52,8,20,0,41,99,34,88,78,56,10,21,84,49,5,27,32,71,3,25,23,31,39,94,4,46,63,14,19],[12,23,52,3,58,86,99,46,9,14,47,89,29,41,10,18,24,8,80,30,73,59,83,76,28,48,50,25,34,53,40,91,6,21,1,20,87,66,69,54,19,88,94,39,95,85,31,0,97,82,33,90,27,81,7,72,65,84,37,61,79,67,71,5,78,70,96,93,36,44,11,16,55,2,56,62,57,49,42,15,68,4,13,64,92,17,74,60,77,22,32,38,63,35,45,26,43,98,75,51],[9,15,19,52,95,40,66,67,74,18,25,14,86,5,21,92,16,4,72,80,84,98,81,43,91,30,39,61,57,36,35,0,58,2,48,83,26,38,8,23,59,93,60,79,70,6,11,20,17,37,90,64,10,96,27,47,28,41,71,97,49,69,94,73,85,68,77,22,63,78,24,87,3,89,1,29,45,7,46,31,82,56,34,65,12,32,75,42,50,53,51,62,76,99,44,13,33,88,55,54],[19,75,24,26,61,77,93,29,70,5,83,35,98,81,97,66,6,20,40,79,54,69,13,31,45,95,99,76,60,65,0,86,41,48,68,32,59,89,18,87,12,64,53,52,94,15,73,36,85,25,46,37,90,92,21,10,30,8,3,34,82,38,74,14,28,7,63,58,78,44,9,22,72,50,56,17,47,33,2,67,1,11,49,57,80,39,27,84,43,91,62,55,4,88,51,16,42,71,23,96],[66,88,96,83,63,65,34,4,46,21,40,45,24,32,20,41,68,47,84,14,80,26,56,11,10,15,77,30,51,92,97,52,28,0,13,23,31,33,76,49,98,87,19,9,71,22,48,5,78,54,79,36,72,17,35,55,95,90,81,69,50,64,62,27,82,67,53,42,74,1,6,29,60,94,93,85,99,61,86,2,91,39,73,59,58,25,12,18,70,3,43,38,57,75,44,7,37,89,8,16],[72,40,92,84,43,17,74,44,98,26,89,79,68,90,49,27,85,7,13,4,76,16,33,22,38,99,71,87,57,88,19,42,24,53,75,31,46,96,9,66,58,97,23,1,29,65,21,62,59,35,0,15,30,80,54,83,93,6,55,41,56,70,47,64,63,91,50,37,78,60,82,77,20,51,48,95,69,73,18,8,34,10,94,3,81,5,11,67,2,14,61,32,12,28,86,52,36,25,39,45],[65,18,94,86,84,78,10,0,43,37,26,91,66,51,90,30,46,45,23,88,95,82,60,68,93,72,6,19,52,55,89,4,98,15,92,34,59,74,69,87,36,21,22,77,75,61,1,5,27,73,44,76,53,32,81,85,58,2,83,29,49,25,62,63,80,57,11,9,97,47,12,39,3,14,50,8,33,70,56,7,54,16,48,99,38,41,79,42,40,64,13,20,71,96,17,35,67,31,28,24],[15,31,75,32,80,16,10,8,88,59,70,99,84,17,95,14,21,74,86,73,28,41,11,1,66,23,82,43,45,85,48,34,91,62,36,2,46,30,40,57,18,53,56,77,87,35,64,47,76,26,3,24,9,55,42,50,27,19,89,25,39,90,29,33,79,13,67,4,0,58,96,97,6,83,44,98,60,61,7,69,94,68,22,12,81,37,78,65,38,63,49,71,51,54,20,93,72,52,92,5],[41,11,70,55,93,26,0,34,98,14,75,56,74,60,46,22,62,2,51,78,66,32,30,73,94,7,63,12,35,15,71,83,21,10,91,25,88,87,82,4,72,24,8,36,39,40,28,23,37,6,38,65,18,5,77,52,44,79,76,67,59,95,49,19,69,33,3,61,16,84,53,54,58,1,47,92,86,97,64,31,29,96,68,42,45,50,48,57,43,90,85,9,80,89,20,13,17,81,99,27],[30,57,20,32,68,67,61,37,49,14,4,15,74,46,75,85,21,62,23,45,86,26,82,95,41,54,88,13,77,81,1,60,48,3,33,8,38,55,28,27,98,24,16,25,73,66,2,5,18,42,36,34,43,99,53,63,40,80,92,69,31,87,10,72,94,22,84,58,44,11,93,71,78,96,97,65,39,76,35,79,51,6,50,83,7,17,89,9,91,59,52,90,56,47,70,19,64,29,0,12],[36,16,49,25,42,61,59,17,60,73,35,40,81,46,57,45,39,50,93,18,4,96,89,27,11,32,9,14,66,68,48,84,63,21,20,58,1,70,62,2,31,76,72,12,29,91,86,10,43,97,83,54,41,30,99,0,7,8,3,98,78,26,15,44,51,55,67,82,71,22,52,77,37,47,85,75,34,28,87,74,88,80,38,19,56,95,23,13,69,24,6,79,53,92,94,5,90,33,64,65],[7,81,94,86,57,5,68,45,21,12,0,31,93,88,65,47,87,64,25,27,91,69,58,52,39,43,14,60,17,11,4,20,19,35,92,1,75,41,38,42,53,26,13,90,83,78,59,77,49,18,70,29,79,61,89,2,32,15,73,3,24,16,50,56,98,62,76,46,54,95,67,63,10,96,85,40,33,84,44,23,28,37,9,6,55,8,22,82,36,72,51,74,48,80,30,66,97,71,99,34],[96,94,16,18,50,54,81,31,61,13,55,69,44,65,11,79,80,22,62,93,32,71,86,78,28,77,20,33,52,10,23,37,75,30,70,21,68,27,98,66,26,3,8,56,59,72,39,2,34,7,60,51,53,24,90,85,74,57,97,83,91,12,87,49,19,38,0,45,63,84,46,48,82,9,64,89,29,67,6,36,4,73,76,42,35,95,5,1,88,40,41,47,17,43,58,25,14,92,15,99],[73,98,85,46,63,51,40,11,25,70,44,52,43,16,8,82,55,31,66,17,94,33,42,6,7,87,75,35,84,12,80,36,89,29,58,57,97,72,21,20,9,67,18,86,19,38,49,39,0,32,23,62,74,2,77,90,34,92,69,78,30,14,64,93,26,4,27,91,3,61,60,68,96,47,88,5,1,56,48,71,53,10,95,65,50,37,22,28,99,83,81,54,13,76,59,24,45,79,41,15],[6,77,89,30,73,46,32,52,79,44,14,86,27,56,95,24,65,26,96,87,25,71,82,54,33,17,13,10,94,69,72,92,38,5,85,1,12,3,43,8,93,20,7,22,84,83,18,66,45,61,98,51,34,0,75,11,41,29,70,9,91,55,40,81,35,78,60,36,59,90,49,80,63,74,23,4,97,57,42,2,39,48,64,21,31,58,50,88,68,15,37,99,16,19,47,62,76,28,67,53],[35,43,54,15,10,96,64,67,61,57,26,0,18,87,59,32,97,11,20,14,88,72,76,46,60,48,16,17,28,91,6,80,1,92,12,58,21,29,40,98,56,94,25,42,65,82,34,55,36,89,24,44,8,5,37,90,83,70,38,31,75,39,62,50,22,2,85,71,3,77,23,95,79,47,69,51,78,68,53,27,4,63,30,9,81,49,99,33,93,84,41,19,52,7,74,73,45,13,66,86],[13,12,68,24,46,28,74,14,50,42,65,35,93,47,63,38,84,17,61,45,41,44,34,30,78,3,20,48,79,7,66,6,25,86,88,60,39,90,22,51,23,33,85,40,57,18,19,67,32,27,15,53,96,58,76,82,54,73,95,72,10,1,43,62,37,89,69,4,80,11,81,31,5,71,94,52,16,87,8,9,2,59,0,64,29,70,55,77,99,26,98,75,56,92,91,49,97,83,21,36],[21,17,92,67,24,68,95,2,62,98,87,45,20,65,5,8,93,59,1,82,25,77,37,74,97,15,10,86,36,81,73,44,31,30,72,3,71,58,12,75,63,96,9,69,26,76,90,61,23,49,91,19,27,38,57,66,46,80,42,54,29,64,94,13,60,39,7,85,55,88,0,16,11,78,83,50,35,89,14,84,70,32,51,40,53,56,41,34,52,99,4,47,43,22,18,48,79,33,6,28],[92,76,49,2,70,5,93,10,29,56,95,23,65,75,47,51,40,55,57,33,37,12,69,54,1,90,13,66,67,24,88,83,42,36,94,48,21,14,73,39,52,38,71,45,89,68,79,74,41,99,3,81,98,78,50,16,6,20,27,64,43,19,34,80,4,8,82,17,97,63,32,7,59,60,58,15,86,44,28,87,85,9,11,96,26,18,25,22,77,91,53,31,84,35,62,61,30,72,46,0],[76,15,89,95,83,65,82,11,71,25,7,6,21,73,75,52,63,41,96,35,77,19,88,97,98,31,64,29,45,23,24,51,70,60,42,27,53,30,99,39,57,43,49,2,62,56,58,55,18,5,16,91,68,79,22,20,10,69,32,34,33,74,90,93,0,81,66,9,80,38,37,28,44,87,14,67,46,78,3,4,61,85,86,36,8,54,59,48,72,13,17,94,47,26,84,12,1,40,92,50],[15,98,13,76,96,18,41,57,67,24,31,58,5,84,56,51,72,52,61,73,78,27,21,9,92,4,14,12,47,30,87,81,65,97,40,48,37,63,75,20,77,74,66,59,7,46,86,33,29,45,99,6,44,80,11,60,16,85,19,53,79,88,0,32,62,69,42,3,22,71,68,34,83,38,90,64,94,23,82,26,55,17,1,50,89,2,54,25,28,39,8,91,35,10,49,36,95,43,93,70],[32,94,64,98,26,58,5,34,60,68,23,69,27,78,17,54,35,95,8,41,22,38,6,92,31,39,77,80,53,81,36,20,86,12,48,15,82,7,47,65,83,16,21,79,96,99,84,44,74,40,63,73,13,3,67,42,91,9,30,25,55,43,70,75,87,29,4,62,11,97,49,1,85,57,51,89,24,88,28,59,14,71,52,76,50,45,33,46,19,37,93,0,56,10,2,90,66,18,61,72],[22,14,27,81,9,45,93,26,60,12,61,48,77,78,3,42,95,89,25,40,32,41,75,44,66,7,8,34,15,46,96,54,92,36,80,43,21,1,24,76,71,13,16,19,58,72,91,70,82,20,85,64,49,0,31,62,38,87,4,90,23,79,68,94,35,55,73,59,67,88,10,98,11,5,30,69,39,65,57,37,97,33,83,50,52,63,18,84,86,17,47,99,56,53,29,51,28,74,6,2],[40,29,92,45,21,35,69,19,72,85,98,14,81,31,9,52,4,23,54,95,13,93,87,58,57,49,65,78,97,36,83,77,3,55,2,70,64,22,50,71,10,48,60,63,8,7,28,27,30,75,56,47,37,68,24,67,74,86,33,59,15,44,96,34,17,90,61,84,25,11,73,82,32,42,6,99,20,80,5,88,18,0,51,26,79,89,41,94,66,62,12,46,43,39,91,1,38,16,76,53],[99,7,45,21,89,22,95,5,59,25,0,79,76,38,23,66,26,13,47,64,73,97,6,63,57,92,84,39,96,74,81,68,83,67,27,93,37,36,85,87,44,2,51,10,77,71,65,48,33,80,46,17,42,1,72,11,82,14,61,91,55,15,75,16,28,53,29,90,4,88,12,49,31,43,9,60,70,98,18,8,40,56,34,58,94,78,54,86,24,62,3,30,69,41,19,32,50,52,35,20],[79,56,12,29,70,35,96,88,83,22,26,0,82,60,44,78,3,15,63,62,10,40,30,37,64,50,48,43,93,51,97,28,4,34,31,36,80,72,14,11,69,99,58,19,45,94,85,68,2,98,42,76,32,75,86,21,71,92,52,89,53,66,73,84,41,55,27,49,59,18,17,25,33,38,20,90,24,13,9,8,5,57,74,95,54,46,7,1,61,81,47,6,91,65,39,77,16,67,23,87],[89,68,76,5,71,73,43,90,29,9,37,58,91,50,51,11,24,88,77,8,2,25,84,62,64,40,78,44,65,67,86,22,35,27,49,15,57,55,56,94,85,13,17,72,30,52,61,99,16,82,38,10,93,39,69,48,34,3,4,47,7,19,36,81,14,41,63,97,53,54,31,42,59,95,0,6,92,20,33,70,1,60,32,98,18,74,87,46,26,28,79,12,23,66,96,45,75,21,83,80],[34,7,8,74,20,22,66,3,25,69,18,53,86,39,4,38,19,28,57,68,9,72,92,26,30,5,36,75,90,63,37,98,42,91,93,94,58,32,60,97,51,13,88,84,6,67,47,55,11,80,43,40,71,99,82,89,77,50,45,52,21,59,33,15,17,48,76,95,81,70,83,27,10,87,96,29,16,41,44,1,79,62,61,64,0,49,14,54,12,24,85,31,2,65,73,56,23,78,35,46],[35,45,65,96,60,36,85,97,98,77,86,43,1,64,40,3,37,32,89,56,39,76,8,7,69,11,29,99,46,55,73,26,25,9,27,41,34,80,88,24,67,6,90,47,44,50,71,30,13,93,54,59,58,70,92,17,49,16,82,12,42,91,21,52,48,31,81,68,19,74,5,14,79,18,63,22,75,95,4,38,33,23,28,15,2,72,94,62,53,51,57,0,83,66,10,61,20,78,84,87],[65,80,18,21,26,54,92,39,74,60,32,10,59,30,3,88,40,50,43,45,48,34,23,36,27,79,51,9,13,61,91,49,24,28,64,97,25,96,57,77,55,41,56,86,99,83,67,66,6,84,82,76,58,4,42,78,35,98,73,2,87,52,46,70,15,69,7,71,38,68,89,19,75,47,5,12,53,85,22,93,20,63,17,62,8,11,72,90,1,14,44,16,0,95,37,94,33,31,81,29],[27,83,29,23,31,81,44,41,9,16,35,49,84,14,0,30,85,46,15,42,94,98,54,12,76,45,89,53,26,57,71,82,87,58,61,74,36,52,80,90,64,47,68,63,92,22,48,25,20,77,75,67,93,34,78,55,62,28,3,91,19,10,24,5,79,97,65,7,73,38,8,50,88,39,96,70,99,95,60,33,37,51,40,72,1,13,32,66,43,11,56,2,59,6,4,86,18,17,21,69],[15,38,91,7,58,9,26,54,23,99,88,3,33,8,73,14,1,40,61,60,29,41,36,44,34,65,87,55,75,25,19,66,85,86,6,64,4,5,67,46,94,62,43,49,16,84,27,22,57,77,48,0,31,51,47,82,32,50,81,12,37,72,52,90,92,24,2,59,70,97,80,96,98,45,30,18,95,89,76,20,63,74,53,11,10,42,78,83,39,28,68,13,17,35,21,79,69,93,71,56],[36,85,53,6,1,73,7,14,95,92,97,13,33,27,18,60,49,74,80,22,90,89,77,25,98,62,81,9,39,30,82,24,59,4,26,17,38,71,93,69,75,66,19,86,29,35,37,55,76,67,68,43,0,78,32,15,20,31,64,12,48,56,58,63,8,84,88,70,3,46,21,42,10,91,72,2,51,83,65,5,16,11,79,87,23,44,41,96,57,99,45,28,61,34,47,40,52,54,94,50],[91,95,22,40,15,1,29,35,78,64,79,49,3,60,96,31,24,42,33,17,12,59,48,8,51,44,65,36,34,47,6,45,13,39,19,80,0,30,68,94,67,89,85,9,82,75,98,56,14,63,77,66,27,81,28,10,37,92,90,2,87,76,25,52,23,43,83,72,61,16,32,26,58,69,7,46,11,99,74,4,38,86,62,73,88,55,41,18,20,84,50,70,97,5,93,71,54,57,53,21],[64,77,22,20,54,36,12,9,84,57,60,79,16,52,87,72,32,29,44,2,63,69,28,3,11,24,26,92,89,91,61,68,35,99,83,75,7,51,85,34,94,48,66,21,39,23,27,47,76,82,30,0,58,70,67,8,14,49,96,74,90,97,62,38,42,37,31,78,59,95,43,88,4,46,6,15,1,41,56,53,81,17,93,71,18,13,55,45,33,65,86,80,98,40,10,19,73,50,5,25],[78,59,61,48,46,89,2,51,65,67,76,77,24,69,70,1,12,96,22,20,64,56,25,38,32,5,80,28,41,87,36,44,9,8,47,29,10,82,98,15,66,21,19,42,17,85,92,30,26,52,91,49,11,7,63,71,43,37,14,54,40,39,31,72,94,50,62,27,86,6,88,93,95,97,18,16,75,84,83,55,53,13,34,90,58,81,99,23,60,79,35,4,45,74,73,68,3,0,57,33],[95,23,82,49,5,20,70,9,12,78,27,48,96,14,16,21,99,64,54,4,1,36,41,8,15,60,68,29,33,93,22,35,57,74,24,52,39,79,19,50,86,83,32,72,75,85,56,71,44,10,81,84,62,40,37,76,66,80,91,55,18,65,38,92,43,47,67,2,61,28,3,98,31,58,17,30,94,46,51,69,97,63,59,88,0,77,25,87,6,11,73,90,7,34,42,53,45,26,13,89],[35,98,49,24,74,59,94,77,68,36,26,19,57,17,41,21,75,25,48,96,5,87,39,30,72,54,10,66,86,0,43,90,3,53,67,12,16,85,78,47,81,88,11,99,60,22,62,51,23,37,52,6,34,9,91,28,56,64,93,31,42,61,84,13,8,92,38,89,27,80,73,33,46,83,40,20,76,1,65,58,71,14,50,97,95,18,79,82,32,45,70,2,15,63,7,44,69,55,29,4],[64,17,52,80,81,9,62,19,48,59,42,20,75,5,14,57,12,68,10,25,8,30,4,58,39,46,50,82,40,91,32,97,54,29,31,72,84,96,35,2,86,51,63,53,18,47,38,16,87,26,92,88,71,60,27,76,70,7,0,44,83,43,24,55,3,69,6,85,41,77,94,49,89,79,13,65,21,28,93,15,36,56,98,11,78,90,74,33,61,1,34,73,66,45,22,67,37,95,23,99],[37,92,5,93,85,64,32,41,10,39,97,1,21,53,28,35,55,87,88,95,65,17,19,43,99,6,13,60,94,23,0,38,20,74,70,2,30,9,15,8,42,52,83,36,34,62,58,26,22,61,56,71,98,80,54,91,51,89,63,44,75,76,45,81,90,50,66,12,11,16,29,46,82,84,78,40,96,4,67,25,69,57,33,68,14,79,7,18,73,59,31,86,27,47,48,49,72,77,3,24],[96,10,97,56,68,30,0,66,70,37,86,81,74,20,15,98,85,18,99,41,42,23,95,61,82,91,80,11,40,83,26,57,62,24,36,52,9,3,16,13,27,78,4,73,90,77,71,7,88,28,5,59,12,92,34,55,32,94,43,63,58,53,84,64,31,39,87,38,8,67,22,49,45,60,17,1,14,51,19,48,47,93,46,29,75,65,6,35,54,79,76,50,69,72,33,44,89,25,21,2],[39,77,33,87,19,59,58,83,11,2,36,9,66,74,38,52,25,92,56,81,31,29,57,65,24,26,34,7,64,28,15,3,22,78,47,18,85,45,32,53,70,48,80,73,44,46,21,50,95,76,43,60,10,68,54,51,69,98,13,41,79,8,14,37,55,12,23,88,97,62,84,72,6,63,40,27,17,99,91,20,42,82,94,61,49,1,5,93,30,89,67,86,4,35,16,0,96,71,90,75],[17,67,88,83,16,90,12,28,15,51,54,89,24,63,10,55,3,52,23,44,31,33,30,60,66,9,0,74,79,4,78,39,81,95,20,48,91,21,75,13,36,61,82,5,6,69,45,37,8,92,41,42,65,97,25,40,96,72,53,11,34,35,71,77,85,64,38,7,73,1,29,46,56,98,18,22,76,19,57,87,86,43,50,59,84,2,99,58,32,62,47,68,14,94,70,27,26,49,80,93],[52,61,46,88,35,41,36,68,99,16,18,38,6,82,96,27,24,43,0,72,78,2,89,39,71,95,45,5,34,58,77,70,65,76,12,85,29,98,8,19,83,21,44,75,63,9,97,74,73,79,31,20,54,37,26,13,48,22,4,32,84,64,3,40,14,15,50,81,59,62,23,25,11,86,10,60,69,17,57,47,42,80,53,30,66,67,90,93,7,92,55,87,91,56,33,94,28,49,51,1],[16,60,51,58,1,55,36,32,22,69,42,18,95,45,65,27,83,78,59,57,61,5,3,66,11,90,72,99,12,75,0,91,39,17,81,48,26,56,87,37,25,33,92,73,93,20,28,68,67,88,14,98,23,2,46,80,52,89,13,47,8,7,15,10,62,82,19,94,84,63,96,4,6,35,43,77,50,53,70,44,31,97,9,54,79,49,74,76,71,30,40,24,64,38,41,86,29,85,21,34],[39,12,57,59,65,56,41,10,0,61,23,90,26,88,66,71,29,60,5,80,83,4,72,89,54,16,24,58,6,47,81,37,95,99,33,28,49,69,75,9,86,8,17,94,96,68,98,78,13,93,32,30,43,55,7,87,84,1,92,19,36,64,2,67,27,91,97,42,44,73,50,76,15,22,63,46,48,18,35,62,77,70,52,21,53,79,11,25,3,20,38,40,34,31,14,45,85,51,82,74],[64,0,68,97,42,51,83,86,6,94,59,21,84,89,75,26,5,8,41,78,74,44,9,76,81,70,3,91,87,17,1,7,33,61,12,67,66,38,43,45,93,25,46,40,11,60,98,39,65,27,28,92,29,54,77,88,22,20,62,19,72,82,32,96,49,47,16,31,56,36,73,69,30,80,79,10,34,53,52,48,71,58,63,85,4,95,15,99,90,57,14,37,18,55,2,35,24,23,50,13],[34,81,3,56,76,40,44,78,61,25,84,60,38,14,30,45,57,64,31,37,29,55,85,21,36,91,71,62,92,0,20,35,18,94,9,5,73,79,82,96,41,8,42,7,68,54,87,28,10,51,99,50,52,98,59,33,24,83,63,11,43,48,1,47,17,74,22,90,32,46,53,86,89,6,27,2,16,4,49,95,66,12,69,80,75,26,70,19,77,65,58,39,93,67,13,88,72,97,15,23],[1,36,4,65,19,44,74,24,31,72,42,80,49,77,76,0,11,48,51,3,43,93,17,47,39,23,29,95,35,79,66,50,25,60,41,70,85,16,14,55,10,38,33,69,62,61,21,13,30,73,78,54,63,59,71,98,81,2,12,9,22,58,20,6,34,84,27,57,26,91,89,64,7,28,18,68,15,86,56,37,94,32,88,40,52,5,82,8,83,75,90,99,46,67,92,96,97,45,87,53],[24,72,66,19,35,60,26,64,4,84,8,69,12,54,10,76,92,13,20,3,59,11,74,17,90,22,89,29,31,49,63,36,40,43,25,98,55,16,34,42,5,1,2,50,94,65,70,73,38,82,27,80,45,77,9,75,67,32,78,62,15,47,46,86,99,97,21,91,61,81,87,96,51,33,68,88,14,18,85,93,39,56,95,0,53,7,48,44,41,37,71,30,79,23,6,57,83,58,28,52],[18,27,42,45,84,83,48,80,30,59,43,29,47,75,37,26,82,21,65,63,89,81,51,91,79,2,28,12,3,16,44,88,86,13,72,68,97,57,95,38,90,66,31,71,22,14,56,9,7,76,69,85,49,92,78,33,74,40,54,73,98,41,19,60,52,96,50,61,1,70,99,32,17,0,62,77,10,64,34,20,23,6,53,5,25,36,55,39,11,67,24,8,35,4,58,87,94,93,46,15],[26,60,42,57,45,34,61,68,15,50,16,3,98,43,37,28,93,88,56,22,66,85,5,59,53,49,58,87,39,2,73,18,75,14,55,41,81,54,33,36,35,62,29,80,79,47,82,69,48,12,27,25,65,94,4,17,70,92,32,23,13,91,76,95,19,67,63,74,83,0,6,77,30,84,89,46,40,96,24,7,8,52,78,1,20,10,9,86,97,99,31,72,51,21,11,71,44,38,64,90]]";
        int[][] dictionary = PWDDictionaryUtils.getDictionary(text);
        System.out.println(dictionary);
    }

    private static void cycleTest1() throws Exception {
        Long sign = 5000000000000001L;
        PWDDictionary dictionary = PaycodeTest.parsePWDDictionary();
        Enctyption enctyption = new Enctyption(dictionary.getPrefix(), dictionary.getVersion(), dictionary.getEncryptDictionaries(), dictionary.getUnix(), 6);
        Dectyption dectyption = new Dectyption(dictionary.getPrefix(), dictionary.getVersion(), dictionary.getEncryptDictionaries(), dictionary.getDecryptDictionaries(), dictionary.getUnix());
        PaycodeManager paycodeManager = PaycodeManager.getInstance().addEnctyption(enctyption).addDectyption(dectyption);
        ArrayList<Cycle> cycles = new ArrayList<Cycle>();
        for (int i = 0; i < 100; ++i) {
            String encryption = paycodeManager.bulidPaycodeWithEncryption(sign);
            String paycode = paycodeManager.enctyptionAndDectyption(encryption, dectyption.getDecryptDictionaries()[paycodeManager.paycodePwdversion(encryption)]);
            cycles.add(new Cycle(paycode, encryption));
            Thread.sleep(2000L);
        }
        for (Cycle cycle2 : cycles) {
            System.out.println(cycle2.toJSON());
            String dectypt = paycodeManager.enctyptionAndDectyption(cycle2.getEncryption(), dectyption.getDecryptDictionaries()[paycodeManager.paycodePwdversion(cycle2.getEncryption())]);
            long userSign = paycodeManager.unpackPaycodeWithDncryption(cycle2.getEncryption());
            cycle2.setDecryption(dectypt);
            cycle2.setResult(dectypt.equals(cycle2.getPaycode()));
            cycle2.setUserSign(userSign);
        }
        cycles.forEach(cycle -> System.out.println(cycle.toJSON()));
    }

    private static void encryptAndDecrypt() throws Exception {
        String paycode = "887371915432101321022773";
        PWDDictionary dictionary = PaycodeTest.parsePWDDictionary();
        System.out.println(paycode);
        String s1 = PaycodeManager.getInstance().enctyptionAndDectyption(paycode, dictionary.getEncryptDictionaries()[18]);
        System.out.println(s1);
        String s2 = PaycodeManager.getInstance().enctyptionAndDectyption(s1, dictionary.getDecryptDictionaries()[18]);
        System.out.println(s2);
    }

    private static void unpackPaycode() throws Exception {
        String paycode = "88840578343614185574188781";
        PWDDictionary dictionary = PaycodeTest.parsePWDDictionary();
        Dectyption dectyption = new Dectyption(dictionary.getPrefix(), dictionary.getVersion(), dictionary.getEncryptDictionaries(), dictionary.getDecryptDictionaries(), dictionary.getUnix(), 6);
        long l = PaycodeManager.getInstance().addDectyption(dectyption).unpackPaycode(paycode);
        System.out.println(l);
    }

    private static void unpackPaycodeWithDecrypt() throws Exception {
        String paycode = "889492879680638203396249";
        PWDDictionary dictionary = PaycodeTest.parsePWDDictionary();
        Dectyption dectyption = new Dectyption(dictionary.getPrefix(), dictionary.getVersion(), dictionary.getEncryptDictionaries(), dictionary.getDecryptDictionaries(), dictionary.getUnix(), 6);
        long l = PaycodeManager.getInstance().addDectyption(dectyption).unpackPaycodeWithDncryption(paycode);
        System.out.println(l);
    }

    private static void bulidPaycode() throws Exception {
        Long sign = 5000000000000001L;
        PWDDictionary dictionary = PaycodeTest.parsePWDDictionary();
        Enctyption enctyption = new Enctyption(dictionary.getPrefix(), dictionary.getVersion(), dictionary.getEncryptDictionaries(), dictionary.getUnix(), 6);
        String paycode = PaycodeManager.getInstance().addEnctyption(enctyption).bulidPaycodeWithEncryption(sign);
        System.out.println("\u4ed8\u6b3e\u7801\uff1a" + paycode);
        System.out.println("\u4ed8\u6b3e\u7801\u957f\u5ea6\uff1a" + paycode.length());
    }

    public static PWDDictionary parsePWDDictionary() throws Exception {
        int len = 0;
        char[] buffer = new char[1024];
        InputStreamReader inputStream = new InputStreamReader(new FileInputStream(new File("E:\\JHScale\\Resources\\JKY", "codebook-dev.json")));
        StringBuffer sb = new StringBuffer();
        while (-1 != (len = inputStream.read(buffer))) {
            sb.append(new String(buffer, 0, len));
        }
        PWDDictionary pwdDictionary = JSONUtils.jsonToObject(sb.toString(), PWDDictionary.class);
        return pwdDictionary;
    }

    private static void timestamp() throws ProfessionalException {
        long unix = Long.parseLong(String.valueOf(System.currentTimeMillis() / 60000L)) - 1440L;
        System.out.println(unix);
        Enctyption enctyption = new Enctyption();
        enctyption.setUnix(unix);
        PaycodeManager.getInstance().addEnctyption(enctyption);
        for (int i = 0; i < 20; ++i) {
            String timestamp = PaycodeManager.getInstance().bulidTimestamp((int)(Math.random() * 100.0));
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.out.println("\u4ed8\u6b3e\u7801\u65f6\u95f4\u6233\uff1a" + timestamp);
        }
    }

    public static void bulidPWDDictionary() {
        PWDDictionayBulid pwdDictionayBulid = PWDDictionayBulid.getInstance().addPrefix("88").addOffset(98, 2);
        List<PWDDictionary> bulid = pwdDictionayBulid.bulid();
        System.out.println(JSONUtils.objectToJSON(bulid));
        System.out.println("\u4e0b\u4e00\u4e2aOffset:" + pwdDictionayBulid.offset());
    }

    public static void encryptAndDecryptDictionary() {
        int[] encryptDictionary = PWDDictionaryUtils.getEncryptDictionary(PWDDictionaryUtils.dictionary);
        String s = PWDDictionaryUtils.formatDictionary(encryptDictionary);
        System.out.println(s);
        int[] decryptDictionary = PWDDictionaryUtils.getDecryptDictionary(encryptDictionary);
        String s2 = PWDDictionaryUtils.formatDictionary(decryptDictionary);
        System.out.println(s2);
    }

    public static void dictionary() {
        int[][] encryptDictionaries = PWDDictionaryUtils.getEncryptDictionaries(PWDDictionaryUtils.dictionary, 100);
        System.out.println(JSONUtils.objectToJSON(encryptDictionaries));
        String json = JSONUtils.objectToJSON(encryptDictionaries);
        List<List> lists = JSONUtils.jsonToList(json, List.class);
        int[][] result = new int[lists.size()][];
        for (int i = 0; i < lists.size(); ++i) {
            int[] dictionary = PWDDictionaryUtils.getDictionary(lists.get(i));
            result[i] = dictionary;
        }
        System.out.println(encryptDictionaries.equals(result));
        int[][] decryptDictionaries = PWDDictionaryUtils.getDecryptDictionaries(encryptDictionaries);
        System.out.println(JSONUtils.objectToJSON(decryptDictionaries));
    }

    public static class Cycle
    extends JSONModel {
        private String paycode;
        private String encryption;
        private String decryption;
        private boolean result;
        private Long userSign;

        public Cycle(String paycode, String encryption) {
            this.paycode = paycode;
            this.encryption = encryption;
        }

        public String getPaycode() {
            return this.paycode;
        }

        public void setPaycode(String paycode) {
            this.paycode = paycode;
        }

        public String getEncryption() {
            return this.encryption;
        }

        public void setEncryption(String encryption) {
            this.encryption = encryption;
        }

        public String getDecryption() {
            return this.decryption;
        }

        public void setDecryption(String decryption) {
            this.decryption = decryption;
        }

        public boolean isResult() {
            return this.result;
        }

        public void setResult(boolean result) {
            this.result = result;
        }

        public Long getUserSign() {
            return this.userSign;
        }

        public void setUserSign(Long userSign) {
            this.userSign = userSign;
        }
    }
}

