/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.elsearch.client;

import com.jhscale.elsearch.client.ElasticsearchTemplateConfig;
import com.jhscale.elsearch.client.model.SortInput;
import com.jhscale.elsearch.client.model.geo.GeoDistanceInput;
import com.jhscale.elsearch.client.model.high.PageSortHighLightInput;
import com.jhscale.elsearch.server.client.ESearchBuilder;
import com.jhscale.elsearch.server.client.context.ESearchContext;
import com.jhscale.elsearch.server.enums.ScriptType;
import com.jhscale.elsearch.server.repository.Attach;
import com.jhscale.elsearch.server.repository.HighLight;
import com.jhscale.elsearch.server.repository.PageList;
import com.jhscale.elsearch.server.repository.PageSortHighLight;
import com.jhscale.elsearch.server.repository.Sort;
import com.jhscale.elsearch.server.template.ScriptTemplate;
import com.jhscale.elsearch.server.utils.Constant;
import com.jhscale.elsearch.server.utils.IndexTools;
import com.jhscale.elsearch.server.utils.MetaData;
import com.jhscale.elsearch.server.utils.ObjectsUtils;
import com.ysscale.framework.model.page.PageQuery;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.geo.GeoDistance;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.GeoDistanceQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.GeoDistanceSortBuilder;
import org.elasticsearch.search.sort.ScriptSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class ElasticsearchTemplateClient<T, M>
extends ElasticsearchTemplateConfig {
    @Autowired
    private RestHighLevelClient restHighLevelClient;
    private ESearchContext context;

    @PostConstruct
    public void init() {
        this.context = new ESearchBuilder().builder(this.restHighLevelClient);
    }

    @Override
    public void create() throws Exception {
        this.context.getIeSearchIndexAPIClient().createIndex(this.getBaseInput().getClazz());
    }

    @Override
    public boolean exists() throws Exception {
        return this.context.getIeSearchIndexAPIClient().exists(this.getBaseInput().getClazz());
    }

    @Override
    public void dropIndex() throws Exception {
        this.context.getIeSearchIndexAPIClient().dropIndex(this.getBaseInput().getClazz());
    }

    public boolean save(T t) throws Exception {
        return this.context.getIeSearchBasics().save(t);
    }

    public boolean save(T t, String routing) throws Exception {
        return this.context.getIeSearchBasics().save(t, routing);
    }

    public BulkResponse save(List<T> list) throws Exception {
        return this.context.getIeSearchBasics().save(list);
    }

    public BulkResponse[] saveBatch(List<T> list) throws Exception {
        return this.context.getIeSearchBasics().saveBatch(list);
    }

    private BulkResponse savePart(List<T> list, String indexname, String indextype) throws Exception {
        return this.context.getIeSearchBasics().savePart(list, indexname, indextype);
    }

    public BulkResponse bulkUpdate(List<T> list) throws Exception {
        return this.context.getIeSearchBasics().bulkUpdate(list);
    }

    public BulkResponse[] bulkUpdateBatch(List<T> list) throws Exception {
        return this.context.getIeSearchBasics().bulkUpdateBatch(list);
    }

    private BulkResponse updatePart(List<T> list, String indexname, String indextype) throws Exception {
        return this.context.getIeSearchBasics().updatePart(list, indexname, indextype);
    }

    public boolean update(T t) throws Exception {
        return this.context.getIeSearchBasics().update(t);
    }

    private BulkResponse batchUpdate(List<T> list, String indexname, String indextype, T t) throws Exception {
        return this.context.getIeSearchBasics().batchUpdate(list, indexname, indextype, t);
    }

    public boolean delete(T t) throws Exception {
        return this.context.getIeSearchBasics().delete(t);
    }

    public boolean delete(T t, String routing) throws Exception {
        return this.context.getIeSearchBasics().delete(t, routing);
    }

    @Override
    public BulkByScrollResponse deleteByCondition() throws Exception {
        return this.context.getIeSearchBasics().deleteByCondition(this.getBaseInput().getQueryBuilder(), this.getBaseInput().getClazz());
    }

    public SearchResponse search(SearchRequest searchRequest) throws IOException {
        return this.context.getIeSearchQueryAPIClient().search(searchRequest);
    }

    @Override
    public List<T> search(PageQuery pageQuery, String ... indexs) throws Exception {
        IndexTools.getIndexType(this.getBaseInput().getClazz());
        SearchRequest searchRequest = new SearchRequest(indexs);
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query(this.getBaseInput().getQueryBuilder());
        if (!ObjectsUtils.isEmpty(pageQuery)) {
            searchSourceBuilder.from(pageQuery.getPage());
            searchSourceBuilder.size(pageQuery.getLimit());
        }
        searchRequest.source(searchSourceBuilder);
        return this.context.getIeSearchQueryAPIClient().search(searchRequest, this.getBaseInput().getClazz());
    }

    @Override
    public List<T> searchMore(int limitSize, String ... indexs) throws Exception {
        return this.context.getIeSearchQueryAPIClient().searchMore(this.getBaseInput().getQueryBuilder(), limitSize, this.getBaseInput().getClazz(), indexs);
    }

    public T getById(M id, Class<T> clazz) throws Exception {
        if (StringUtils.isEmpty(id)) {
            throw new Exception("ID cannot be empty");
        }
        MetaData metaData = IndexTools.getIndexType(clazz);
        String indexname = metaData.getIndexname();
        String indextype = metaData.getIndextype();
        GetRequest getRequest = new GetRequest(indexname, indextype, id.toString());
        return this.context.getIeSearchQueryAPIClient().getById(getRequest, clazz);
    }

    public PageList<T> search(PageSortHighLightInput input, Class<T> clazz, String ... indexs) throws Exception {
        BoolQueryBuilder booleanQueryBuilder = QueryBuilders.boolQuery();
        PageSortHighLight psh = new PageSortHighLight(input.getPageQuery().getPage(), input.getPageQuery().getLimit());
        List<SortInput> sortInputs = input.getSortInputs();
        this.setSortInput(psh, sortInputs, input);
        return this.context.getIeSearchQueryAPIClient().search((QueryBuilder)booleanQueryBuilder, psh, clazz, indexs);
    }

    @Override
    public PageList<T> searchAttach(PageSortHighLightInput input, String ... indexs) throws Exception {
        Attach attach = new Attach();
        attach.setSearchAfter(true);
        PageSortHighLight psh = new PageSortHighLight(input.getPageQuery().getPage(), input.getPageQuery().getLimit());
        List<SortInput> sortInputs = input.getSortInputs();
        this.setSortInput(psh, sortInputs, input);
        attach.setPageSortHighLight(psh);
        return this.context.getIeSearchQueryAPIClient().search(this.getBaseInput().getQueryBuilder(), attach, this.getBaseInput().getClazz(), indexs);
    }

    @Override
    public long count() throws Exception {
        return this.context.getIeSearchStatisticsAPIClient().count(this.getBaseInput().getQueryBuilder(), this.getBaseInput().getClazz());
    }

    @Override
    public long count(String ... indexs) throws Exception {
        return this.context.getIeSearchStatisticsAPIClient().count(this.getBaseInput().getQueryBuilder(), this.getBaseInput().getClazz(), indexs);
    }

    @Override
    public List<T> searchGeoDistance(Class resultClass, GeoDistanceInput input, boolean bool, String ... indexs) throws Exception {
        IndexTools.getIndexType(this.getBaseInput().getClazz());
        SearchRequest searchRequest = new SearchRequest(indexs);
        this.getSearchRequest(this.getBaseInput().getQueryBuilder(), input, searchRequest);
        return this.context.getIeSearchGeoDistanceQueryAPIClient().searchGeoDistance(searchRequest, this.getBaseInput().getClazz(), resultClass, bool, input);
    }

    @Override
    public PageList<T> searchGeoDistancePage(Class resultClass, GeoDistanceInput input, boolean bool, String ... indexs) throws Exception {
        IndexTools.getIndexType(this.getBaseInput().getClazz());
        SearchRequest searchRequest = new SearchRequest(indexs);
        this.getSearchRequest(this.getBaseInput().getQueryBuilder(), input, searchRequest);
        return this.context.getIeSearchGeoDistanceQueryAPIClient().searchGeoDistancePage(searchRequest, input, this.getBaseInput().getClazz(), resultClass, bool);
    }

    public List<T> geoDistance(Class<T> clazz, Class resultClass, GeoDistanceInput input, boolean bool, String ... indexs) throws Exception {
        MetaData metaData = IndexTools.getIndexType(clazz);
        metaData.getSearchIndexNames();
        BoolQueryBuilder booleanQueryBuilder = QueryBuilders.boolQuery();
        SearchRequest searchRequest = new SearchRequest(indexs);
        this.getSearchRequest((QueryBuilder)booleanQueryBuilder, input, searchRequest);
        return this.context.getIeSearchGeoDistanceQueryAPIClient().geoDistance(searchRequest, clazz, resultClass, bool, input);
    }

    public void getSearchRequest(QueryBuilder queryBuilder, GeoDistanceInput input, SearchRequest searchRequest) {
        GeoDistanceQueryBuilder distanceQueryBuilder = new GeoDistanceQueryBuilder(input.getSortFiledName());
        distanceQueryBuilder.point(input.getLatitude(), input.getLongitude());
        distanceQueryBuilder.distance(input.getDistance().doubleValue(), DistanceUnit.KILOMETERS);
        distanceQueryBuilder.geoDistance(GeoDistance.ARC);
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)distanceQueryBuilder);
        List<ScriptTemplate> scriptTemplateList = input.getScriptTemplates();
        scriptTemplateList.forEach(scriptTemplate -> {
            if (scriptTemplate.getFieldName().contains("location")) {
                GeoDistanceSortBuilder sort = SortBuilders.geoDistanceSort((String)input.getSortFiledName(), (double)input.getLatitude(), (double)input.getLongitude());
                sort.unit(DistanceUnit.KILOMETERS);
                sort.order(input.getSortOrder());
                sort.point(input.getLatitude(), input.getLongitude());
                searchSourceBuilder.sort((SortBuilder)sort);
            } else {
                searchSourceBuilder.sort((SortBuilder)this.getScriptSort((ScriptTemplate)scriptTemplate));
            }
        });
        searchSourceBuilder.query(queryBuilder);
        Integer page = input.getPageQuery().getPage() > 1 ? input.getPageQuery().getPage() * input.getPageQuery().getLimit() : 0;
        searchSourceBuilder.from(page.intValue());
        Integer pages = page <= 1 ? 1 : page;
        searchSourceBuilder.size(pages * input.getPageQuery().getLimit());
        searchRequest.source(searchSourceBuilder);
    }

    private ScriptSortBuilder getScriptSort(ScriptTemplate template) {
        String code = "doc['" + template.getFieldName() + "'].value ";
        Script scripts = new Script(code);
        ScriptSortBuilder.ScriptSortType scriptSortType = template.getFieldType().equals((Object)ScriptType.SCRIPT_INETGER) ? ScriptSortBuilder.ScriptSortType.NUMBER : (template.getFieldType().equals((Object)ScriptType.SCRIPT_STRING) ? ScriptSortBuilder.ScriptSortType.STRING : ScriptSortBuilder.ScriptSortType.STRING);
        ScriptSortBuilder sortBuilders = (ScriptSortBuilder)SortBuilders.scriptSort((Script)scripts, (ScriptSortBuilder.ScriptSortType)scriptSortType).order(template.getSortOrder());
        return sortBuilders;
    }

    private void high(PageSortHighLightInput input, HighLight highLight) {
        if (StringUtils.isEmpty((Object)input.getHighPreTag())) {
            highLight.setPreTag(Constant.HIGH_TEMPLAT_PRE_TAG);
            highLight.setPostTag(Constant.HIGH_TEMPLAT_POST_TAG);
        } else {
            highLight.setPreTag(input.getHighPreTag());
            highLight.setPostTag(input.getHighPostTag());
        }
    }

    private void setSortInput(PageSortHighLight psh, List<SortInput> sortInputs, PageSortHighLightInput input) {
        ArrayList<Sort.Order> orders = new ArrayList<Sort.Order>();
        if (!ObjectsUtils.isEmpty(sortInputs)) {
            sortInputs.forEach(sortInput -> {
                Sort.Order order = new Sort.Order(sortInput.getSortOrder(), sortInput.getSortFiledName());
                orders.add(order);
            });
            psh.setSort(new Sort(orders));
        }
        HighLight highLight = new HighLight();
        if (!StringUtils.isEmpty((Object)input.getHighName())) {
            highLight.field(input.getHighName());
        }
        this.high(input, highLight);
        psh.setHighLight(highLight);
    }
}

