/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.elsearch.server.base;

import com.jhscale.elsearch.server.annotation.ESSearchID;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class BaseAPICommonClient<T, M> {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static Map<Class, String> classIDMap = new ConcurrentHashMap<Class, String>();

    public void correctID(Class clazz, T t, M _id) {
        try {
            if (StringUtils.isEmpty(_id)) {
                return;
            }
            if (classIDMap.containsKey(clazz)) {
                Field field = clazz.getDeclaredField(classIDMap.get(clazz));
                field.setAccessible(true);
                if (field.get(t) == null) {
                    field.set(t, _id);
                }
                return;
            }
            for (int i = 0; i < clazz.getDeclaredFields().length; ++i) {
                Field field = clazz.getDeclaredFields()[i];
                field.setAccessible(true);
                if (field.getAnnotation(ESSearchID.class) == null) continue;
                classIDMap.put(clazz, field.getName());
                if (field.get(t) != null) continue;
                field.set(t, _id);
            }
        }
        catch (Exception e) {
            this.logger.error("correctID error!", (Throwable)e);
        }
    }

    public static Object mapToObject(Map map, Class<?> beanClass) throws Exception {
        Field[] fields;
        if (map == null) {
            return null;
        }
        Object obj = beanClass.newInstance();
        for (Field field : fields = obj.getClass().getDeclaredFields()) {
            int mod;
            if (map.get(field.getName()) == null || StringUtils.isEmpty(map.get(field.getName())) || Modifier.isStatic(mod = field.getModifiers()) || Modifier.isFinal(mod)) continue;
            field.setAccessible(true);
            if (!(map.get(field.getName()) instanceof HighlightField) || ((HighlightField)map.get(field.getName())).fragments().length <= 0) continue;
            field.set(obj, ((HighlightField)map.get(field.getName())).fragments()[0].string());
        }
        return obj;
    }
}

