/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.elsearch.server.client.api;

import com.jhscale.elsearch.server.utils.IndexTools;
import com.jhscale.elsearch.server.utils.JsonUtils;
import com.jhscale.elsearch.server.utils.MetaData;
import com.jhscale.elsearch.server.utils.Tools;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class IESearchBasicsAPIClient<T> {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private RestHighLevelClient client;

    public IESearchBasicsAPIClient(RestHighLevelClient client) {
        this.client = client;
    }

    public Response request(Request request) throws Exception {
        return this.client.getLowLevelClient().performRequest(request);
    }

    public boolean save(T t) throws Exception {
        return this.save(t, null);
    }

    public boolean save(T t, String routing) throws Exception {
        MetaData metaData = IndexTools.getIndexType(t.getClass());
        String indexname = metaData.getIndexname();
        String indextype = metaData.getIndextype();
        String id = Tools.getESSearchID(t);
        IndexRequest indexRequest = null;
        indexRequest = StringUtils.isEmpty((Object)id) ? new IndexRequest(indexname, indextype) : new IndexRequest(indexname, indextype, id);
        String source = JsonUtils.obj2String(t);
        this.logger.info(source);
        indexRequest.source(source, XContentType.JSON);
        if (!StringUtils.isEmpty((Object)routing)) {
            indexRequest.routing(routing);
        }
        IndexResponse indexResponse = null;
        indexResponse = this.client.index(indexRequest, RequestOptions.DEFAULT);
        if (indexResponse.getResult() == DocWriteResponse.Result.CREATED) {
            this.logger.info("INDEX CREATE SUCCESS");
        } else if (indexResponse.getResult() == DocWriteResponse.Result.UPDATED) {
            this.logger.info("INDEX UPDATE SUCCESS");
        } else {
            return false;
        }
        return true;
    }

    public BulkResponse save(List<T> list) throws Exception {
        if (list == null || list.size() == 0) {
            return null;
        }
        T t = list.get(0);
        MetaData metaData = IndexTools.getIndexType(t.getClass());
        String indexname = metaData.getIndexname();
        String indextype = metaData.getIndextype();
        return this.savePart(list, indexname, indextype);
    }

    public BulkResponse[] saveBatch(List<T> list) throws Exception {
        if (list == null || list.size() == 0) {
            return null;
        }
        T t = list.get(0);
        MetaData metaData = IndexTools.getIndexType(t.getClass());
        String indexname = metaData.getIndexname();
        String indextype = metaData.getIndextype();
        List<List<T>> lists = Tools.splitList(list, true);
        BulkResponse[] bulkResponses = new BulkResponse[lists.size()];
        for (int i = 0; i < lists.size(); ++i) {
            bulkResponses[i] = this.savePart(lists.get(i), indexname, indextype);
        }
        return bulkResponses;
    }

    public BulkResponse savePart(List<T> list, String indexname, String indextype) throws Exception {
        BulkRequest rrr = new BulkRequest();
        for (int i = 0; i < list.size(); ++i) {
            T tt = list.get(i);
            String id = Tools.getESSearchID(tt);
            String sourceJsonStr = JsonUtils.obj2String(tt);
            rrr.add(new IndexRequest(indexname, indextype, id).source(sourceJsonStr, XContentType.JSON));
        }
        BulkResponse bulkResponse = this.client.bulk(rrr, RequestOptions.DEFAULT);
        return bulkResponse;
    }

    public BulkResponse bulkUpdate(List<T> list) throws Exception {
        if (list == null || list.size() == 0) {
            return null;
        }
        T t = list.get(0);
        if (Tools.checkNested(t)) {
            throw new Exception("nested\u5bf9\u8c61\u66f4\u65b0\uff0c\u8bf7\u4f7f\u7528\u8986\u76d6\u66f4\u65b0");
        }
        MetaData metaData = IndexTools.getIndexType(t.getClass());
        String indexname = metaData.getIndexname();
        String indextype = metaData.getIndextype();
        return this.updatePart(list, indexname, indextype);
    }

    public BulkResponse[] bulkUpdateBatch(List<T> list) throws Exception {
        if (list == null || list.size() == 0) {
            return null;
        }
        T t = list.get(0);
        if (Tools.checkNested(t)) {
            throw new Exception("nested\u5bf9\u8c61\u66f4\u65b0\uff0c\u8bf7\u4f7f\u7528\u8986\u76d6\u66f4\u65b0");
        }
        MetaData metaData = IndexTools.getIndexType(t.getClass());
        String indexname = metaData.getIndexname();
        String indextype = metaData.getIndextype();
        List<List<T>> lists = Tools.splitList(list, true);
        BulkResponse[] bulkResponses = new BulkResponse[lists.size()];
        for (int i = 0; i < lists.size(); ++i) {
            bulkResponses[i] = this.updatePart(lists.get(i), indexname, indextype);
        }
        return bulkResponses;
    }

    public BulkResponse updatePart(List<T> list, String indexname, String indextype) throws Exception {
        BulkRequest rrr = new BulkRequest();
        for (int i = 0; i < list.size(); ++i) {
            T tt = list.get(i);
            String id = Tools.getESSearchID(tt);
            rrr.add(new UpdateRequest(indexname, indextype, id).doc(Tools.getFieldValue(tt)));
        }
        BulkResponse bulkResponse = this.client.bulk(rrr, RequestOptions.DEFAULT);
        return bulkResponse;
    }

    public boolean update(T t) throws Exception {
        MetaData metaData = IndexTools.getIndexType(t.getClass());
        String indexname = metaData.getIndexname();
        String indextype = metaData.getIndextype();
        String id = Tools.getESSearchID(t);
        if (StringUtils.isEmpty((Object)id)) {
            throw new Exception("ID cannot be empty");
        }
        if (Tools.checkNested(t)) {
            throw new Exception("nested\u5bf9\u8c61\u66f4\u65b0\uff0c\u8bf7\u4f7f\u7528\u8986\u76d6\u66f4\u65b0");
        }
        UpdateRequest updateRequest = new UpdateRequest(indexname, indextype, id);
        updateRequest.doc(Tools.getFieldValue(t));
        UpdateResponse updateResponse = null;
        updateResponse = this.client.update(updateRequest, RequestOptions.DEFAULT);
        if (updateResponse.getResult() == DocWriteResponse.Result.CREATED) {
            this.logger.info("INDEX CREATE SUCCESS");
        } else if (updateResponse.getResult() == DocWriteResponse.Result.UPDATED) {
            this.logger.info("INDEX UPDATE SUCCESS");
        } else {
            return false;
        }
        return true;
    }

    public BulkResponse batchUpdate(List<T> list, String indexname, String indextype, T tot) throws Exception {
        Map map = Tools.getFieldValue(tot);
        BulkRequest rrr = new BulkRequest();
        for (int i = 0; i < list.size(); ++i) {
            T tt = list.get(i);
            rrr.add(new UpdateRequest(indexname, indextype, Tools.getESSearchID(tt)).doc(map));
        }
        BulkResponse bulkResponse = this.client.bulk(rrr, RequestOptions.DEFAULT);
        return bulkResponse;
    }

    public boolean delete(T t) throws Exception {
        return this.delete(t, null);
    }

    public boolean delete(T t, String routing) throws Exception {
        MetaData metaData = IndexTools.getIndexType(t.getClass());
        String indexname = metaData.getIndexname();
        String indextype = metaData.getIndextype();
        String id = Tools.getESSearchID(t);
        if (StringUtils.isEmpty((Object)id)) {
            throw new Exception("ID cannot be empty");
        }
        DeleteRequest deleteRequest = new DeleteRequest(indexname, indextype, id);
        if (!StringUtils.isEmpty((Object)routing)) {
            deleteRequest.routing(routing);
        }
        DeleteResponse deleteResponse = null;
        deleteResponse = this.client.delete(deleteRequest, RequestOptions.DEFAULT);
        if (deleteResponse.getResult() != DocWriteResponse.Result.DELETED) {
            return false;
        }
        this.logger.info("INDEX DELETE SUCCESS");
        return true;
    }

    public BulkByScrollResponse deleteByCondition(QueryBuilder queryBuilder, Class<T> clazz) throws Exception {
        MetaData metaData = IndexTools.getIndexType(clazz);
        String[] indexname = metaData.getSearchIndexNames();
        DeleteByQueryRequest request = new DeleteByQueryRequest(indexname);
        request.setQuery(queryBuilder);
        BulkByScrollResponse bulkResponse = this.client.deleteByQuery(request, RequestOptions.DEFAULT);
        return bulkResponse;
    }
}

