/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.elsearch.server.client.api;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jhscale.elsearch.client.model.RLocation;
import com.jhscale.elsearch.client.model.geo.GeoDistanceInput;
import com.jhscale.elsearch.server.base.BaseAPICommonClient;
import com.jhscale.elsearch.server.repository.PageList;
import com.jhscale.elsearch.server.utils.IndexTools;
import com.jhscale.elsearch.server.utils.math.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.geo.GeoDistance;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IESearchGeoDistanceQueryAPIClient<T, M>
extends BaseAPICommonClient<T, M> {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private RestHighLevelClient restHighLevelClient;

    public IESearchGeoDistanceQueryAPIClient(RestHighLevelClient restHighLevelClient) {
        this.restHighLevelClient = restHighLevelClient;
    }

    public List<T> searchGeoDistance(SearchRequest searchRequest, Class<T> clazz, Class resultClass, boolean bool, GeoDistanceInput input) throws Exception {
        IndexTools.getIndexType(clazz);
        return this.geoDistance(searchRequest, clazz, resultClass, bool, input);
    }

    public List<T> geoDistance(SearchRequest searchRequest, Class<T> clazz, Class resultClass, boolean bool, GeoDistanceInput input) throws Exception {
        SearchResponse searchResponse = this.restHighLevelClient.search(searchRequest, RequestOptions.DEFAULT);
        SearchHits hits = searchResponse.getHits();
        SearchHit[] searchHits = hits.getHits();
        ArrayList arrayList = new ArrayList();
        BigDecimal bigDiv = BigDecimal.valueOf(1000L);
        Arrays.asList(searchHits).forEach(searchHit -> {
            Map hitMap = searchHit.getSourceAsMap();
            Object[] objects = searchHit.getSortValues();
            this.setdistance(hitMap, objects, BigDecimal.valueOf(input.getDistance()), bool, arrayList, null, input.getLatitude(), input.getLongitude());
        });
        if (resultClass == null) {
            resultClass = clazz;
        }
        return JSON.parseArray((String)JSON.toJSONString(arrayList), resultClass);
    }

    private void setdistance(Map<String, Object> hitMap, Object[] objects, BigDecimal distance, boolean bool, ArrayList<Map> arrayList, PageList<T> pageList, double lat, double lon) {
        if (ObjectUtils.allNotNull((Object[])objects)) {
            Object shopLocation = hitMap.get("location");
            ObjectMapper objectMapper = new ObjectMapper();
            RLocation rLocation = (RLocation)objectMapper.convertValue(shopLocation, RLocation.class);
            double bResult = GeoDistance.ARC.calculate(lat, lon, rLocation.getLat(), rLocation.getLon(), DistanceUnit.KILOMETERS);
            if (bool) {
                hitMap.put("distance", bResult);
                arrayList.add(hitMap);
                if (pageList != null) {
                    pageList.setSortValues(objects);
                }
            } else if (BigDecimalUtils.is(BigDecimal.valueOf(bResult)).lt(distance)) {
                hitMap.put("distance", bResult);
                arrayList.add(hitMap);
                if (pageList != null) {
                    pageList.setSortValues(objects);
                }
            }
        }
    }

    public PageList<T> searchGeoDistancePage(SearchRequest searchRequest, GeoDistanceInput input, Class<T> clazz, Class resultClass, boolean bool) throws Exception {
        IndexTools.getIndexType(clazz);
        return this.geoDistancePage(searchRequest, input, clazz, resultClass, bool);
    }

    public PageList<T> geoDistancePage(SearchRequest searchRequest, GeoDistanceInput input, Class<T> clazz, Class resultClass, boolean bool) throws Exception {
        PageList pageList = new PageList();
        SearchResponse searchResponse = this.restHighLevelClient.search(searchRequest, RequestOptions.DEFAULT);
        SearchHits hits = searchResponse.getHits();
        SearchHit[] searchHits = hits.getHits();
        Integer page = input.getPageQuery().getPage() > 1 ? input.getPageQuery().getPage() * input.getPageQuery().getLimit() : 0;
        pageList.setNowPage(page);
        Integer pages = page <= 1 ? 1 : page;
        pageList.setPageSize(pages * input.getPageQuery().getLimit());
        ArrayList arrayList = new ArrayList();
        Arrays.asList(searchHits).forEach(searchHit -> {
            Map hitMap = searchHit.getSourceAsMap();
            Object[] objects = searchHit.getSortValues();
            this.setdistance(hitMap, objects, BigDecimal.valueOf(input.getDistance()), bool, arrayList, pageList, input.getLatitude(), input.getLongitude());
        });
        if (resultClass == null) {
            resultClass = clazz;
        }
        pageList.setRows(JSON.parseArray((String)JSON.toJSONString(arrayList), resultClass));
        return pageList;
    }
}

