/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.elsearch.server.client.api;

import com.jhscale.elsearch.server.utils.IndexTools;
import com.jhscale.elsearch.server.utils.MappingData;
import com.jhscale.elsearch.server.utils.MetaData;
import java.io.IOException;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.get.GetIndexRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class IESearchIndexAPIClient<T> {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private RestHighLevelClient client;
    private static final String NESTED = "nested";

    public IESearchIndexAPIClient(RestHighLevelClient client) {
        this.client = client;
    }

    public void createIndex(Class<T> clazz) throws Exception {
        MetaData metaData = IndexTools.getMetaData(clazz);
        CreateIndexRequest request = new CreateIndexRequest(metaData.getIndexname());
        StringBuffer source = new StringBuffer();
        source.append("  {\n    \"" + metaData.getIndextype() + "\": {\n      \"properties\": {\n");
        MappingData[] mappingDataList = IndexTools.getMappingData(clazz);
        boolean isNgram = false;
        for (int i = 0; i < mappingDataList.length; ++i) {
            MappingData mappingData = mappingDataList[i];
            if (mappingData == null || mappingData.getField_name() == null) continue;
            source.append(" \"" + mappingData.getField_name() + "\": {\n");
            source.append(" \"type\": \"" + mappingData.getDatatype() + "\"\n");
            if (!mappingData.getDatatype().equals(NESTED)) {
                if (mappingData.isNgram() && (mappingData.getDatatype().equals("text") || mappingData.getDatatype().equals("keyword"))) {
                    isNgram = true;
                }
                source.append(this.oneField(mappingData));
            } else {
                source.append(" ,\"properties\": { ");
                if (mappingData.getNested_class() != null && mappingData.getNested_class() != Object.class) {
                    MappingData[] submappingDataList = IndexTools.getMappingData(mappingData.getNested_class());
                    for (int j = 0; j < submappingDataList.length; ++j) {
                        MappingData submappingData = submappingDataList[j];
                        if (submappingData == null || submappingData.getField_name() == null) continue;
                        source.append(" \"" + submappingData.getField_name() + "\": {\n");
                        source.append(" \"type\": \"" + submappingData.getDatatype() + "\"\n");
                        if (j == submappingDataList.length - 1) {
                            source.append(" }\n");
                            continue;
                        }
                        source.append(" },\n");
                    }
                } else {
                    throw new Exception("\u65e0\u6cd5\u8bc6\u522b\u7684Nested_class");
                }
                source.append(" }");
            }
            if (i == mappingDataList.length - 1) {
                source.append(" }\n");
                continue;
            }
            source.append(" },\n");
        }
        source.append(" }\n");
        source.append(" }\n");
        source.append(" }\n");
        System.out.println(source.toString());
        if (isNgram) {
            request.settings(Settings.builder().put("index.number_of_shards", metaData.getNumber_of_shards()).put("index.number_of_replicas", metaData.getNumber_of_replicas()).put("analysis.filter.autocomplete_filter.type", "edge_ngram").put("analysis.filter.autocomplete_filter.min_gram", 1).put("analysis.filter.autocomplete_filter.max_gram", 20).put("analysis.analyzer.autocomplete.type", "custom").put("analysis.analyzer.autocomplete.tokenizer", "standard").putList("analysis.analyzer.autocomplete.filter", new String[]{"lowercase", "autocomplete_filter"}));
        } else {
            request.settings(Settings.builder().put("index.number_of_shards", metaData.getNumber_of_shards()).put("index.number_of_replicas", metaData.getNumber_of_replicas()));
        }
        request.mapping(metaData.getIndextype(), source.toString(), XContentType.JSON);
        try {
            CreateIndexResponse createIndexResponse = this.client.indices().create(request, RequestOptions.DEFAULT);
            boolean acknowledged = createIndexResponse.isAcknowledged();
            this.logger.info("acknowledged---- > : " + acknowledged);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void dropIndex(Class<T> clazz) throws Exception {
        MetaData metaData = IndexTools.getIndexType(clazz);
        String indexname = metaData.getIndexname();
        DeleteIndexRequest request = new DeleteIndexRequest(indexname);
        this.client.indices().delete(request, RequestOptions.DEFAULT);
    }

    public boolean exists(Class<T> clazz) throws Exception {
        MetaData metaData = IndexTools.getIndexType(clazz);
        String indexname = metaData.getIndexname();
        String indextype = metaData.getIndextype();
        GetIndexRequest request = new GetIndexRequest();
        request.indices(new String[]{indexname});
        request.types(new String[]{indextype});
        boolean exists = this.client.indices().exists(request, RequestOptions.DEFAULT);
        return exists;
    }

    private String oneField(MappingData mappingData) {
        StringBuilder source = new StringBuilder();
        if (!StringUtils.isEmpty((Object)mappingData.getCopy_to())) {
            source.append(" ,\"copy_to\": \"" + mappingData.getCopy_to() + "\"\n");
        }
        if (!StringUtils.isEmpty((Object)mappingData.getNull_value())) {
            source.append(" ,\"null_value\": \"" + mappingData.getNull_value() + "\"\n");
        }
        if (!mappingData.isAllow_search()) {
            source.append(" ,\"index\": false\n");
        }
        if (mappingData.isNgram() && (mappingData.getDatatype().equals("text") || mappingData.getDatatype().equals("keyword"))) {
            source.append(" ,\"analyzer\": \"autocomplete\"\n");
            source.append(" ,\"search_analyzer\": \"standard\"\n");
        } else if (mappingData.getDatatype().equals("text")) {
            source.append(" ,\"analyzer\": \"" + mappingData.getAnalyzer() + "\"\n");
            source.append(" ,\"search_analyzer\": \"" + mappingData.getSearch_analyzer() + "\"\n");
        }
        if (mappingData.isKeyword() && !mappingData.getDatatype().equals("keyword") && mappingData.isSuggest()) {
            source.append(" \n");
            source.append(" ,\"fields\": {\n");
            source.append(" \"keyword\": {\n");
            source.append(" \"type\": \"keyword\",\n");
            source.append(" \"ignore_above\": " + mappingData.getIgnore_above());
            source.append(" },\n");
            source.append(" \"suggest\": {\n");
            source.append(" \"type\": \"completion\",\n");
            source.append(" \"analyzer\": \"" + mappingData.getAnalyzer() + "\"\n");
            source.append(" }\n");
            source.append(" }\n");
        } else if (mappingData.isKeyword() && !mappingData.getDatatype().equals("keyword") && !mappingData.isSuggest()) {
            source.append(" \n");
            source.append(" ,\"fields\": {\n");
            source.append(" \"keyword\": {\n");
            source.append(" \"type\": \"keyword\",\n");
            source.append(" \"ignore_above\": " + mappingData.getIgnore_above());
            source.append(" }\n");
            source.append(" }\n");
        } else if (!mappingData.isKeyword() && mappingData.isSuggest()) {
            source.append(" \n");
            source.append(" ,\"fields\": {\n");
            source.append(" \"suggest\": {\n");
            source.append(" \"type\": \"completion\",\n");
            source.append(" \"analyzer\": \"" + mappingData.getAnalyzer() + "\"\n");
            source.append(" }\n");
            source.append(" }\n");
        }
        return source.toString();
    }
}

