/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.elsearch.server.client.api;

import com.jhscale.elsearch.server.base.BaseAPICommonClient;
import com.jhscale.elsearch.server.repository.Attach;
import com.jhscale.elsearch.server.repository.HighLight;
import com.jhscale.elsearch.server.repository.PageList;
import com.jhscale.elsearch.server.repository.PageSortHighLight;
import com.jhscale.elsearch.server.repository.Sort;
import com.jhscale.elsearch.server.utils.BeanTools;
import com.jhscale.elsearch.server.utils.IndexTools;
import com.jhscale.elsearch.server.utils.JsonUtils;
import com.jhscale.elsearch.server.utils.MetaData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.util.StringUtils;

public class IESearchQueryAPIClient<T, M>
extends BaseAPICommonClient<T, M> {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private RestHighLevelClient restHighLevelClient;

    public IESearchQueryAPIClient(RestHighLevelClient restHighLevelClient) {
        this.restHighLevelClient = restHighLevelClient;
    }

    public SearchResponse search(SearchRequest searchRequest) throws IOException {
        return this.restHighLevelClient.search(searchRequest, RequestOptions.DEFAULT);
    }

    public List<T> search(SearchRequest searchRequest, Class<T> clazz) throws Exception {
        ArrayList list = new ArrayList();
        SearchResponse searchResponse = this.restHighLevelClient.search(searchRequest, RequestOptions.DEFAULT);
        SearchHits hits = searchResponse.getHits();
        SearchHit[] searchHits = hits.getHits();
        Arrays.asList(searchHits).forEach(searchHit -> {
            Object t = JsonUtils.string2Obj(searchHit.getSourceAsString(), clazz);
            this.correctID(clazz, t, searchHit.getId());
            list.add(t);
        });
        return list;
    }

    public List<T> searchMore(QueryBuilder queryBuilder, int limitSize, Class<T> clazz) throws Exception {
        MetaData metaData = IndexTools.getIndexType(clazz);
        String[] indexName = metaData.getSearchIndexNames();
        return this.searchMore(queryBuilder, limitSize, clazz, indexName);
    }

    public List<T> searchMore(QueryBuilder queryBuilder, int limitSize, Class<T> clazz, String ... indexs) throws Exception {
        PageSortHighLight pageSortHighLight = new PageSortHighLight(1, limitSize);
        PageList<T> pageList = this.search(queryBuilder, pageSortHighLight, clazz, indexs);
        return pageList != null ? pageList.getRows() : null;
    }

    public T getById(GetRequest getRequest, Class<T> clazz) throws Exception {
        GetResponse getResponse = this.restHighLevelClient.get(getRequest, RequestOptions.DEFAULT);
        return getResponse.isExists() ? (T)JsonUtils.string2Obj(getResponse.getSourceAsString(), clazz) : null;
    }

    public PageList<T> search(QueryBuilder queryBuilder, PageSortHighLight pageSortHighLight, Class<T> clazz, String ... indexs) throws Exception {
        if (pageSortHighLight == null) {
            throw new NullPointerException("PageSortHighLight\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        Attach attach = new Attach();
        attach.setPageSortHighLight(pageSortHighLight);
        return this.search(queryBuilder, attach, clazz, indexs);
    }

    public PageList<T> search(QueryBuilder queryBuilder, Attach attach, Class<T> clazz, String ... indexs) throws Exception {
        SearchHit[] searchHits;
        if (attach == null) {
            throw new NullPointerException("Attach\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        MetaData metaData = IndexTools.getIndexType(clazz);
        PageList pageList = new PageList();
        ArrayList<T> list = new ArrayList<T>();
        PageSortHighLight pageSortHighLight = attach.getPageSortHighLight();
        SearchRequest searchRequest = new SearchRequest(indexs);
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query(queryBuilder);
        boolean highLightFlag = false;
        boolean idSortFlag = false;
        if (pageSortHighLight != null) {
            HighLight highLight;
            pageList.setNowPage(pageSortHighLight.getCurrentPage());
            pageList.setPageSize(pageSortHighLight.getPageSize());
            if (pageSortHighLight.getPageSize() != 0) {
                if (!attach.isSearchAfter()) {
                    searchSourceBuilder.from(((pageSortHighLight.getCurrentPage() == 0 ? 1 : pageSortHighLight.getCurrentPage()) - 1) * pageSortHighLight.getPageSize());
                }
                searchSourceBuilder.size(pageSortHighLight.getPageSize());
            }
            if (pageSortHighLight.getSort() != null) {
                Sort sort = pageSortHighLight.getSort();
                List<Sort.Order> orders = sort.listOrders();
                for (Sort.Order order : orders) {
                    if (order.getProperty().equals("_id")) {
                        idSortFlag = true;
                    }
                    searchSourceBuilder.sort(new FieldSortBuilder(order.getProperty()).order(order.getDirection()));
                }
            }
            if ((highLight = pageSortHighLight.getHighLight()) != null && highLight.getHighLightList() != null && highLight.getHighLightList().size() != 0) {
                HighlightBuilder highlightBuilder = new HighlightBuilder();
                if (!StringUtils.isEmpty((Object)highLight.getPreTag()) && !StringUtils.isEmpty((Object)highLight.getPostTag())) {
                    highlightBuilder.preTags(new String[]{highLight.getPreTag()});
                    highlightBuilder.postTags(new String[]{highLight.getPostTag()});
                }
                for (int i = 0; i < highLight.getHighLightList().size(); ++i) {
                    highLightFlag = true;
                    highlightBuilder.field(highLight.getHighLightList().get(i), i);
                }
                highlightBuilder.fragmentSize(Integer.valueOf(80000));
                highlightBuilder.numOfFragments(Integer.valueOf(0));
                searchSourceBuilder.highlighter(highlightBuilder);
            }
        }
        if (attach.isSearchAfter()) {
            if (pageSortHighLight == null || pageSortHighLight.getPageSize() == 0) {
                searchSourceBuilder.size(10);
            } else {
                searchSourceBuilder.size(pageSortHighLight.getPageSize());
            }
            if (attach.getSortValues() != null && attach.getSortValues().length != 0) {
                searchSourceBuilder.searchAfter(attach.getSortValues());
            }
            if (!idSortFlag) {
                Sort.Order order = new Sort.Order(SortOrder.ASC, "_id");
                assert (pageSortHighLight != null);
                pageSortHighLight.getSort().and(new Sort(order));
                searchSourceBuilder.sort(new FieldSortBuilder("_id").order(SortOrder.ASC));
            }
        }
        if (attach.getExcludes() != null || attach.getIncludes() != null) {
            searchSourceBuilder.fetchSource(attach.getIncludes(), attach.getExcludes());
        }
        searchRequest.source(searchSourceBuilder);
        if (!StringUtils.isEmpty((Object)attach.getRouting())) {
            searchRequest.routing(attach.getRouting());
        }
        if (metaData != null && metaData.isPrintLog()) {
            this.logger.info(searchSourceBuilder.toString());
        }
        SearchResponse searchResponse = this.restHighLevelClient.search(searchRequest, RequestOptions.DEFAULT);
        SearchHits hits = searchResponse.getHits();
        for (SearchHit hit : searchHits = hits.getHits()) {
            Object t = JsonUtils.string2Obj(hit.getSourceAsString(), clazz);
            this.correctID(clazz, t, hit.getId());
            if (highLightFlag && t != null) {
                Map hmap = hit.getHighlightFields();
                hmap.forEach((k, v) -> {
                    try {
                        Object obj = IESearchQueryAPIClient.mapToObject(hmap, clazz);
                        BeanUtils.copyProperties((Object)obj, (Object)t, (String[])BeanTools.getNoValuePropertyNames(obj));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
            }
            list.add(t);
            pageList.setSortValues(hit.getSortValues());
        }
        pageList.setRows(list);
        return pageList;
    }
}

