/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.elsearch.server.client.api;

import com.jhscale.elsearch.server.utils.IndexTools;
import com.jhscale.elsearch.server.utils.MetaData;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.core.CountRequest;
import org.elasticsearch.client.core.CountResponse;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IESearchStatisticsAPIClient<T, M> {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private RestHighLevelClient restHighLevelClient;

    public IESearchStatisticsAPIClient(RestHighLevelClient restHighLevelClient) {
        this.restHighLevelClient = restHighLevelClient;
    }

    public long count(QueryBuilder queryBuilder, Class<T> clazz) throws Exception {
        MetaData metaData = IndexTools.getIndexType(clazz);
        String[] indexname = metaData.getSearchIndexNames();
        return this.count(queryBuilder, clazz, indexname);
    }

    public long count(QueryBuilder queryBuilder, Class<T> clazz, String ... indexs) throws Exception {
        IndexTools.getIndexType(clazz);
        CountRequest countRequest = new CountRequest(indexs);
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query(queryBuilder);
        countRequest.source(searchSourceBuilder);
        CountResponse countResponse = this.restHighLevelClient.count(countRequest, RequestOptions.DEFAULT);
        long count = countResponse.getCount();
        return count;
    }
}

