/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.elsearch.server.client.context;

import com.jhscale.elsearch.server.client.api.IESearchBasicsAPIClient;
import com.jhscale.elsearch.server.client.api.IESearchGeoDistanceQueryAPIClient;
import com.jhscale.elsearch.server.client.api.IESearchIndexAPIClient;
import com.jhscale.elsearch.server.client.api.IESearchQueryAPIClient;
import com.jhscale.elsearch.server.client.api.IESearchStatisticsAPIClient;
import com.jhscale.elsearch.server.client.config.ESearchConfiguration;
import org.elasticsearch.client.RestHighLevelClient;

public class ESearchContext {
    private IESearchBasicsAPIClient ieSearchBasics;
    private IESearchQueryAPIClient ieSearchQueryAPIClient;
    private IESearchStatisticsAPIClient ieSearchStatisticsAPIClient;
    private IESearchIndexAPIClient ieSearchIndexAPIClient;
    private IESearchGeoDistanceQueryAPIClient ieSearchGeoDistanceQueryAPIClient;
    public RestHighLevelClient client;

    public ESearchContext(ESearchConfiguration eSearchConfiguration, RestHighLevelClient client) {
        this.client = client;
        this.ieSearchBasics = new IESearchBasicsAPIClient(client);
        this.ieSearchQueryAPIClient = new IESearchQueryAPIClient(client);
        this.ieSearchStatisticsAPIClient = new IESearchStatisticsAPIClient(client);
        this.ieSearchIndexAPIClient = new IESearchIndexAPIClient(client);
        this.ieSearchGeoDistanceQueryAPIClient = new IESearchGeoDistanceQueryAPIClient(client);
    }

    public IESearchBasicsAPIClient getIeSearchBasics() {
        return this.ieSearchBasics;
    }

    public IESearchQueryAPIClient getIeSearchQueryAPIClient() {
        return this.ieSearchQueryAPIClient;
    }

    public IESearchStatisticsAPIClient getIeSearchStatisticsAPIClient() {
        return this.ieSearchStatisticsAPIClient;
    }

    public RestHighLevelClient getClient() {
        return this.client;
    }

    public IESearchIndexAPIClient getIeSearchIndexAPIClient() {
        return this.ieSearchIndexAPIClient;
    }

    public IESearchGeoDistanceQueryAPIClient getIeSearchGeoDistanceQueryAPIClient() {
        return this.ieSearchGeoDistanceQueryAPIClient;
    }
}

