/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.elsearch.server.config;

import com.jhscale.elsearch.server.config.ElasticsearchProperties;
import com.jhscale.elsearch.server.utils.Constant;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.util.StringUtils;

@Configuration
@ComponentScan(value={"com.jhscale"})
public class ElasticSearchConfig {
    @Autowired
    ElasticsearchProperties elasticsearchProperties;
    private RestHighLevelClient restHighLevelClient;

    @Bean(destroyMethod="close")
    @Scope(value="singleton")
    public RestHighLevelClient createInstance() {
        String host = this.elasticsearchProperties.getHost();
        String username = this.elasticsearchProperties.getUsername();
        String password = this.elasticsearchProperties.getPassword();
        try {
            if (StringUtils.isEmpty((Object)host)) {
                host = Constant.DEFAULT_ES_HOST;
            }
            String[] hosts = host.split(",");
            HttpHost[] httpHosts = new HttpHost[hosts.length];
            for (int i = 0; i < httpHosts.length; ++i) {
                String h = hosts[i];
                httpHosts[i] = new HttpHost(h.split(":")[0], Integer.parseInt(h.split(":")[1]), "http");
            }
            if (!StringUtils.isEmpty((Object)username)) {
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
                this.restHighLevelClient = new RestHighLevelClient(RestClient.builder((HttpHost[])httpHosts).setHttpClientConfigCallback(new RestClientBuilder.HttpClientConfigCallback((CredentialsProvider)credentialsProvider){
                    final /* synthetic */ CredentialsProvider val$credentialsProvider;
                    {
                        this.val$credentialsProvider = credentialsProvider;
                    }

                    public HttpAsyncClientBuilder customizeHttpClient(HttpAsyncClientBuilder httpClientBuilder) {
                        httpClientBuilder.disableAuthCaching();
                        return httpClientBuilder.setDefaultCredentialsProvider(this.val$credentialsProvider);
                    }
                }));
            } else {
                this.restHighLevelClient = new RestHighLevelClient(RestClient.builder((HttpHost[])httpHosts));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return this.restHighLevelClient;
    }
}

