/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.elsearch.server.utils;

import com.jhscale.elsearch.server.annotation.ESSearchMapping;
import com.jhscale.elsearch.server.annotation.ESSearchMetaData;
import com.jhscale.elsearch.server.utils.MappingData;
import com.jhscale.elsearch.server.utils.MetaData;
import com.jhscale.elsearch.server.utils.Tools;
import java.lang.reflect.Field;
import org.springframework.util.StringUtils;

public class IndexTools {
    public static MetaData getIndexType(Class<?> clazz) {
        String indexname = "";
        String indextype = "";
        if (clazz.getAnnotation(ESSearchMetaData.class) != null) {
            indexname = clazz.getAnnotation(ESSearchMetaData.class).indexName();
            if (indextype == null || indextype.equals("")) {
                indextype = "_doc";
            }
            MetaData metaData = new MetaData(indexname, indextype);
            metaData.setPrintLog(clazz.getAnnotation(ESSearchMetaData.class).printLog());
            if (Tools.arrayISNULL(clazz.getAnnotation(ESSearchMetaData.class).searchIndexNames())) {
                metaData.setSearchIndexNames(new String[]{indexname});
            } else {
                metaData.setSearchIndexNames(clazz.getAnnotation(ESSearchMetaData.class).searchIndexNames());
            }
            return metaData;
        }
        return null;
    }

    public static MetaData getShardsConfig(Class<?> clazz) {
        int number_of_shards = 0;
        int number_of_replicas = 0;
        if (clazz.getAnnotation(ESSearchMetaData.class) != null) {
            number_of_shards = clazz.getAnnotation(ESSearchMetaData.class).number_of_shards();
            number_of_replicas = clazz.getAnnotation(ESSearchMetaData.class).number_of_replicas();
            MetaData metaData = new MetaData(number_of_shards, number_of_replicas);
            metaData.setPrintLog(clazz.getAnnotation(ESSearchMetaData.class).printLog());
            return metaData;
        }
        return null;
    }

    public static MetaData getMetaData(Class<?> clazz) {
        String indexname = "";
        String indextype = "";
        int number_of_shards = 0;
        int number_of_replicas = 0;
        if (clazz.getAnnotation(ESSearchMetaData.class) != null) {
            indexname = clazz.getAnnotation(ESSearchMetaData.class).indexName();
            if (indextype == null || indextype.equals("")) {
                indextype = "_doc";
            }
            number_of_shards = clazz.getAnnotation(ESSearchMetaData.class).number_of_shards();
            number_of_replicas = clazz.getAnnotation(ESSearchMetaData.class).number_of_replicas();
            MetaData metaData = new MetaData(indexname, indextype, number_of_shards, number_of_replicas);
            metaData.setPrintLog(clazz.getAnnotation(ESSearchMetaData.class).printLog());
            if (Tools.arrayISNULL(clazz.getAnnotation(ESSearchMetaData.class).searchIndexNames())) {
                metaData.setSearchIndexNames(new String[]{indexname});
            } else {
                metaData.setSearchIndexNames(clazz.getAnnotation(ESSearchMetaData.class).searchIndexNames());
            }
            return metaData;
        }
        return null;
    }

    public static MappingData getMappingData(Field field) {
        if (field == null) {
            return null;
        }
        field.setAccessible(true);
        MappingData mappingData = new MappingData();
        mappingData.setField_name(field.getName());
        if (field.getAnnotation(ESSearchMapping.class) != null) {
            ESSearchMapping esMapping = field.getAnnotation(ESSearchMapping.class);
            mappingData.setDatatype(esMapping.datatype().toString().replaceAll("_type", ""));
            mappingData.setAnalyzer(esMapping.analyzer().toString());
            mappingData.setNgram(esMapping.ngram());
            mappingData.setIgnore_above(esMapping.ignore_above());
            mappingData.setSearch_analyzer(esMapping.search_analyzer().toString());
            if (mappingData.getDatatype().equals("text")) {
                mappingData.setKeyword(esMapping.keyword());
            } else {
                mappingData.setKeyword(false);
            }
            mappingData.setSuggest(esMapping.suggest());
            mappingData.setAllow_search(esMapping.allow_search());
            mappingData.setCopy_to(esMapping.copy_to());
            mappingData.setNested_class(esMapping.nested_class());
            if (!StringUtils.isEmpty((Object)esMapping.null_value())) {
                mappingData.setNull_value(esMapping.null_value());
            }
        } else {
            mappingData.setDatatype("text");
            mappingData.setAnalyzer("standard");
            mappingData.setNgram(false);
            mappingData.setIgnore_above(256);
            mappingData.setSearch_analyzer("standard");
            mappingData.setKeyword(true);
            mappingData.setSuggest(false);
            mappingData.setAllow_search(true);
            mappingData.setCopy_to("");
            mappingData.setNested_class(null);
        }
        return mappingData;
    }

    public static MappingData[] getMappingData(Class<?> clazz) {
        Field[] fields = clazz.getDeclaredFields();
        MappingData[] mappingDataList = new MappingData[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            if (fields[i].getName().equals("serialVersionUID")) continue;
            mappingDataList[i] = IndexTools.getMappingData(fields[i]);
        }
        return mappingDataList;
    }
}

