/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.elsearch.server.utils;

import com.jhscale.elsearch.server.annotation.ESSearchID;
import com.jhscale.elsearch.server.annotation.ESSearchMapping;
import com.jhscale.elsearch.server.enums.DataType;
import com.jhscale.elsearch.server.utils.Constant;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.util.StringUtils;

public class Tools {
    private static Map<Class, Boolean> checkNested = new HashMap<Class, Boolean>();

    public static String getESSearchID(Object obj) throws Exception {
        Field[] fields;
        for (Field f : fields = obj.getClass().getDeclaredFields()) {
            f.setAccessible(true);
            ESSearchID ESSearchID2 = f.getAnnotation(ESSearchID.class);
            if (ESSearchID2 == null) continue;
            Object value = f.get(obj);
            if (value == null) {
                return null;
            }
            return value.toString();
        }
        return null;
    }

    public static Map getFieldValue(Object o) throws IllegalAccessException {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        Field[] fs = o.getClass().getDeclaredFields();
        for (int i = 0; i < fs.length; ++i) {
            Field f = fs[i];
            f.setAccessible(true);
            if (f.get(o) == null) continue;
            retMap.put(f.getName(), f.get(o));
        }
        return retMap;
    }

    public static Class getSuperClassGenricType(Class clazz) {
        return Tools.getSuperClassGenricType(clazz, 0);
    }

    public static Class getSuperClassGenricType(Class clazz, int index) throws IndexOutOfBoundsException {
        Type genType = clazz.getGenericSuperclass();
        if (!(genType instanceof ParameterizedType)) {
            return Object.class;
        }
        Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
        if (index >= params.length || index < 0) {
            return Object.class;
        }
        if (!(params[index] instanceof Class)) {
            return Object.class;
        }
        return (Class)params[index];
    }

    public static String arraytostring(String[] strs) {
        if (StringUtils.isEmpty((Object)strs)) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        Arrays.asList(strs).stream().forEach(str -> sb.append((String)str).append(" "));
        return sb.toString();
    }

    public static boolean arrayISNULL(Object[] objs) {
        if (objs == null || objs.length == 0) {
            return true;
        }
        boolean flag = false;
        for (int i = 0; i < objs.length; ++i) {
            if (StringUtils.isEmpty((Object)objs[i])) continue;
            flag = true;
        }
        return !flag;
    }

    public static <T> List<List<T>> splitList(List<T> oriList, boolean isParallel) {
        if (oriList.size() <= Constant.BULK_COUNT) {
            ArrayList<List<T>> splitList = new ArrayList<List<T>>();
            splitList.add(oriList);
            return splitList;
        }
        int limit = (oriList.size() + Constant.BULK_COUNT - 1) / Constant.BULK_COUNT;
        if (isParallel) {
            return ((Stream)Stream.iterate(0, n -> n + 1).limit(limit).parallel()).map(a -> ((Stream)oriList.stream().skip(a * Constant.BULK_COUNT).limit(Constant.BULK_COUNT).parallel()).collect(Collectors.toList())).collect(Collectors.toList());
        }
        ArrayList splitList = new ArrayList();
        Stream.iterate(0, n -> n + 1).limit(limit).forEach(i -> splitList.add(oriList.stream().skip(i * Constant.BULK_COUNT).limit(Constant.BULK_COUNT).collect(Collectors.toList())));
        return splitList;
    }

    public static boolean checkNested(List list) {
        if (list == null || list.size() == 0) {
            return false;
        }
        return Tools.checkNested(list.get(0));
    }

    public static boolean checkNested(Object obj) {
        if (obj == null) {
            return false;
        }
        if (checkNested.containsKey(obj.getClass())) {
            return checkNested.get(obj.getClass());
        }
        for (int i = 0; i < obj.getClass().getDeclaredFields().length; ++i) {
            Field f = obj.getClass().getDeclaredFields()[i];
            if (f.getAnnotation(ESSearchMapping.class) == null || f.getAnnotation(ESSearchMapping.class).datatype() != DataType.nested_type && (f.getAnnotation(ESSearchMapping.class).nested_class() == null || f.getAnnotation(ESSearchMapping.class).nested_class() == Object.class)) continue;
            checkNested.put(obj.getClass(), true);
            return true;
        }
        checkNested.put(obj.getClass(), false);
        return false;
    }
}

