/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.elsearch.server.utils.math;

import java.math.BigDecimal;
import java.math.RoundingMode;

public class BigDecimalCalculation {
    private final BigDecimal amount;

    public BigDecimalCalculation(BigDecimal amount) {
        this.amount = amount;
    }

    public BigDecimalCalculation(String amount) {
        this.amount = new BigDecimal(amount);
    }

    public BigDecimalCalculation plus(BigDecimal value) {
        return new BigDecimalCalculation(this.amount.add(value));
    }

    public BigDecimalCalculation plus(String value) {
        return this.plus(new BigDecimal(value));
    }

    public BigDecimalCalculation minus(BigDecimal value) {
        return new BigDecimalCalculation(this.amount.subtract(value));
    }

    public BigDecimalCalculation minus(String value) {
        return this.minus(new BigDecimal(value));
    }

    public BigDecimalCalculation mul(BigDecimal value) {
        return new BigDecimalCalculation(this.amount.multiply(value));
    }

    public BigDecimalCalculation mul(String value) {
        return this.mul(new BigDecimal(value));
    }

    public BigDecimalCalculation div(BigDecimal value) {
        return new BigDecimalCalculation(this.amount.divide(value, RoundingMode.HALF_EVEN));
    }

    public BigDecimalCalculation div(String value) {
        return this.div(new BigDecimal(value));
    }

    public BigDecimalCalculation div(BigDecimal value, int scale) {
        return new BigDecimalCalculation(this.amount.divide(value, scale, RoundingMode.HALF_EVEN));
    }

    public BigDecimalCalculation div(String value, int scale) {
        return this.div(new BigDecimal(value), scale);
    }

    public BigDecimal result() {
        return this.amount;
    }
}

