/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.elsearch.server.utils.math;

import java.math.BigDecimal;

public class BigDecimalLogic {
    private static final int ZERO = 0;
    private final BigDecimal amount;

    public BigDecimalLogic(BigDecimal amount) {
        this.amount = amount;
    }

    public BigDecimalLogic(String amount) {
        this.amount = amount == null ? null : new BigDecimal(amount);
    }

    public boolean eq(BigDecimal bigDecimal) {
        return this.amount.compareTo(bigDecimal) == 0;
    }

    public boolean eq(String value) {
        return this.eq(new BigDecimal(value));
    }

    public boolean gt(BigDecimal bigDecimal) {
        return this.amount.compareTo(bigDecimal) > 0;
    }

    public boolean gt(String value) {
        return this.gt(new BigDecimal(value));
    }

    public boolean gteq(BigDecimal bigDecimal) {
        return this.amount.compareTo(bigDecimal) >= 0;
    }

    public boolean gteq(String value) {
        return this.gteq(new BigDecimal(value));
    }

    public boolean lt(BigDecimal bigDecimal) {
        return this.amount.compareTo(bigDecimal) < 0;
    }

    public boolean lt(String value) {
        return this.lt(new BigDecimal(value));
    }

    public boolean lteq(BigDecimal bigDecimal) {
        return this.amount.compareTo(bigDecimal) <= 0;
    }

    public boolean lteq(String value) {
        return this.lteq(new BigDecimal(value));
    }

    public boolean isZero() {
        return this.eq(BigDecimal.ZERO);
    }

    public boolean isNullOrZero() {
        return this.amount == null || this.isZero();
    }
}

