package com.jhscale.meter.ai;

import com.jhscale.meter.protocol.model.GlobalPara;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.*;

import static com.jhscale.meter.protocol.constant.TMS.Max_Per_Complex;
import static com.jhscale.meter.protocol.constant.TMS.Max_Using_Complex;

public class AIInfo {

    static class AIInfo_B {
        public String tip;
        public String des;

        public AIInfo_B(String tip, String des) {
            this.tip = tip;
            this.des = des;
        }
    }

    static class AIInfo_C {

        public Map<String, Double> parts = new HashMap();

        public AIInfo_C(String input) {
            try {
                String[] ps = input.split("%");
                for (int i = 0; i < ps.length; i++) {
                    int mpos = ps[i].indexOf("=");
                    if (mpos > 0) {
                        String tip = ps[i].substring(0, mpos);
                        Double percent = Double.parseDouble(ps[i].substring(mpos + 1));
                        if (percent >= 0.01)
                            parts.put(tip, percent);
                    }
                }
            } catch (Exception exp) {
                ;
            }
        }

        public AIInfo_C(Map<String, Double> input) {
            List<Map.Entry<String, Double>> list = new ArrayList<Map.Entry<String, Double>>(input.entrySet());
            Collections.sort(list, new Comparator<Map.Entry<String, Double>>() {
                public int compare(Map.Entry<String, Double> o1, Map.Entry<String, Double> o2) {
                    Double cp = o1.getValue() - o2.getValue();
                    if (cp == 0)
                        return 0;
                    else if (cp > 0)
                        return -1;
                    else
                        return 1;
                }
            });

            int MaxPerComplex = GlobalPara.getInstance().getTMS(Max_Per_Complex, 5);

            for (int i = 0; i < list.size() && i < MaxPerComplex; i++) {
                parts.put(list.get(i).getKey(), list.get(i).getValue());
            }
        }
    }


    @ApiModelProperty(value = "type", name = "类型，0=关，1=开，2=待训练")
    private int type;
    @ApiModelProperty(value = "aiMain", name = "主AI")
    private String aiMain = "";
    @ApiModelProperty(value = "aiB", name = "基础AI")
    private List<AIInfo_B> aiBs;
    @ApiModelProperty(value = "aiC", name = "复杂AI")
    private List<AIInfo_C> aiCs;

    private static final DecimalFormat df = new DecimalFormat("#.0000", new DecimalFormatSymbols(Locale.ENGLISH));

    public AIInfo() {
        this.type = 1;
        aiBs = new ArrayList<>();
        aiCs = new ArrayList<>();
    }

    public AIInfo(String input) {
        aiBs = new ArrayList<>();
        aiCs = new ArrayList<>();
        type = 0;
        String[] ts = input.split("#");
        if (ts.length > 1) {
            int cttype = Integer.parseInt(ts[0]);
            if (((cttype == 1) || (cttype == 2)) && (ts[1].length() > 0)) {
                type = cttype;
                String[] ids = ts[1].split("&");
                for (int i = 0; i < ids.length; i++) {
                    if (ids[i] == "")
                        continue;
                    else if (ids[i].contains("%")) {
                        AIInfo_C ac = new AIInfo_C(ids[i]);
                        if (ac.parts.size() > 0)
                            aiCs.add(ac);
                    } else {
                        int mpos = ids[i].indexOf(":");
                        if (mpos == 0)
                            ;
                        else {
                            if (mpos < 0)
                                aiBs.add(new AIInfo_B(ids[i], ""));
                            else
                                aiBs.add(new AIInfo_B(ids[i].substring(0, mpos), ids[i].substring(mpos + 1)));
                            if (aiMain == "")
                                aiMain = ids[i];
                        }
                    }
                }
            }
        }
    }

    /**
     * @description: 最大值
     **/
    private static Double getMaxValue_NoZero(Map<String, Double> input) {
        Double max = 0.0;
        if (input != null) {
            for (Map.Entry<String, Double> entry : input.entrySet()) {
                Double ct = entry.getValue();
                if (ct > max)
                    max = ct;
            }
        }
        if (max <= 0.0)
            max = 1.0;

        return max;
    }

    /**
     * @description: 识别
     **/
    public Double Check(Map<String, Double> input) {
        return Check(input, getMaxValue_NoZero(input));
    }

    /**
     * @description: 识别
     **/
    public Double Check(Map<String, Double> input, Double inmax) {
        Double max = 0.0;
        for (int i = 0; i < aiBs.size(); i++) {
            String tip = aiBs.get(i).tip;
            if (input.containsKey(tip)) {
                Double va = input.get(tip) / inmax;
                if (max < va)
                    max = va;
            }
        }
        for (int i = 0; i < aiCs.size(); i++) {
            Double totalLast = 0.0;
            Double totalDif = 0.0;
            for (Map.Entry<String, Double> entry : aiCs.get(i).parts.entrySet()) {
                Double ct = input.get(entry.getKey());
                ct = ct != null ? ct : 0.0;
                Double last = entry.getValue();
                totalLast += last * last;
                totalDif += (last - ct) * (last - ct);
            }
            if (totalDif < totalLast) {
                //Double va = 1.0 - Math.sqrt(totalDif)/Math.sqrt(totalLast);
                Double va = Math.sqrt(totalLast) / (Math.sqrt(totalLast) + Math.sqrt(totalDif));
                if (max < va)
                    max = va;
            }
        }
        return Double.parseDouble(df.format(max));
    }

    /**
     * @description: 学习
     **/
    public void Learn(Map<String, Double> input) {
        AIInfo_C ac = new AIInfo_C(input);
        if (ac.parts.size() > 0) {
            aiCs.add(ac);
            while (aiCs.size() > GlobalPara.getInstance().getTMS(Max_Using_Complex, 10))
                aiCs.remove(0);
        }
    }

    public String GetString() {
        String output = Integer.toString(this.type);
        boolean first = true;
        if ((type == 1) || (type == 2)) {
            for (int i = 0; i < aiBs.size(); i++) {
                if (first) {
                    output += "#";
                    first = false;
                } else
                    output += "&";
                AIInfo_B aiB = aiBs.get(i);
                if (aiB.des == "")
                    output += aiB.tip;
                else
                    output += aiB.tip + ":" + aiB.des;
            }
            for (int i = 0; i < aiCs.size(); i++) {
                if (first) {
                    output += "#";
                    first = false;
                } else
                    output += "&";

                List<Map.Entry<String, Double>> list = new ArrayList<Map.Entry<String, Double>>(aiCs.get(i).parts.entrySet());
                Collections.sort(list, new Comparator<Map.Entry<String, Double>>() {
                    public int compare(Map.Entry<String, Double> o1, Map.Entry<String, Double> o2) {
                        Double cp = o1.getValue() - o2.getValue();
                        if (cp == 0)
                            return 0;
                        else if (cp > 0)
                            return -1;
                        else
                            return 1;
                    }
                });

                for (int k = 0; k < list.size(); k++) {
                    BigDecimal tv = new BigDecimal(list.get(k).getValue() * 100).setScale(0, BigDecimal.ROUND_HALF_UP).divide(new BigDecimal(100));
                    output += list.get(k).getKey() + "=" + tv.toString() + "%";
                }
            }
        }
        return output;
    }

}
