package com.jhscale.meter.ai;

import com.jhscale.common.ai.ProbablyScore;
import com.jhscale.common.model.device.plu.module.DAIType;
import com.jhscale.common.model.inter.GJSONModel;

import java.util.List;

/**
 * @author wang lie
 * @title: AIRecord
 * @projectName meter-jar
 * @description: AI样板信息
 * @date 2023/6/2215:08
 */
public class AIRecord implements GJSONModel {

    // 商品编号 (训练时必传)
    private Integer pluno;

    // 商品原图
    private String source;

    // 识别数据 (训练时必传)
    private List<ProbablyScore> scores;

    // AI信息 (训练结束更新数据库数据)
    private DAIType daiType;

    public Integer getPluno() {
        return pluno;
    }

    public AIRecord setPluno(Integer pluno) {
        this.pluno = pluno;
        return this;
    }

    public String getSource() {
        return source;
    }

    public AIRecord setSource(String source) {
        this.source = source;
        return this;
    }

    public List<ProbablyScore> getScores() {
        return scores;
    }

    public AIRecord setScores(List<ProbablyScore> scores) {
        this.scores = scores;
        return this;
    }

    public DAIType getDaiType() {
        return daiType;
    }

    public AIRecord setDaiType(DAIType daiType) {
        this.daiType = daiType;
        return this;
    }
}
