package com.jhscale.meter.ai;

import com.jhscale.common.model.inter.GJSONModel;

import java.util.HashMap;
import java.util.Map;

/**
 * @author lie_w
 * @title: ConverResult
 * @projectName meter-jar
 * @description: TODO
 * @date 2023/6/259:29
 */
public class EscapeResult implements GJSONModel {

    private Map<String, Double> result;

    private Double max;

    public EscapeResult() {
    }

    public EscapeResult(Map<String, Double> result, Double max) {
        this.result = result;
        this.max = max;
    }

    /**
     * @description: 添加采样数据
     **/
    public EscapeResult add(String key, Double value) {
        if (this.result == null) this.result = new HashMap<>();
        this.result.put(key, value);
        return this;
    }

    public Map<String, Double> getResult() {
        return result;
    }

    public void setResult(Map<String, Double> result) {
        this.result = result;
    }

    public Double getMax() {
        return max;
    }

    public void setMax(Double max) {
        this.max = max;
    }

    /**
     * @description: 获取最大值
     **/
    public void compare(double dv) {
        if (max == null || max < dv) max = dv;
    }
}
