package com.jhscale.meter.auncel;

import com.jhscale.meter.auncel.cmd.*;
import com.jhscale.meter.auncel.em.CPT;
import com.jhscale.meter.auncel.entity.AuncelRequest;
import com.jhscale.meter.auncel.entity.AuncelResponse;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.io.PortManager;
import com.jhscale.meter.io.control.DeviceControl;
import com.jhscale.meter.io.listener.DeviceClientEventListener;
import com.jhscale.meter.model.device.SerialDevice;
import com.jhscale.meter.protocol.model.GlobalPara;
import com.jhscale.meter.utils.ByteUtils;
import org.apache.commons.lang3.StringUtils;

import static com.jhscale.meter.auncel.AuncelUtils.END;
import static com.jhscale.meter.auncel.AuncelUtils.TOP;


/**
 * @author wang lie
 * @version 1.0
 * @projectName meter-jar
 * @title AuncelManager
 * @description
 * @create 2024/1/4 19:06
 */
public class AuncelManager {

    private PortManager portManager;

    // 请求超时间
    private long timeout = 500;

    // 重试次数
    private int recount = 3;

    // 等待结果休眠时间
    private long cycle_timeout = 10;

    // 等待周期
    private int cycle_count = 100;

    private String cache = "";

    // 请求对象
    private AuncelRequest request;

    // 响应对象
    private AuncelResponse response;

    // 回调通知
    private AuncelNotify notify;

    // 通讯密钥
    private String seed;

    private Read_Weight_Thread read_weight_thread;

    private long read_cycle = 100;

    private AuncelManager() {
    }

    private static class SingleAuncelManagerFactory {
        private static final AuncelManager INSTANCE = new AuncelManager();
    }

    public static AuncelManager getInstance() {
        return AuncelManager.SingleAuncelManagerFactory.INSTANCE;
    }

    /**
     * @description: 超时设置
     **/
    public AuncelManager Settings(long timeout, Integer recount, long cycle_timeout, long read_cycle) {
        this.timeout = timeout;
        this.recount = recount;
        this.cycle_timeout = cycle_timeout;
        this.cycle_count = (int) (this.timeout / this.cycle_timeout) + 1;
        this.read_cycle = read_cycle;
        return this;
    }

    /**
     * @description: 通讯器初始化
     **/
    public boolean Init_Manager(DeviceControl control, SerialDevice device, AuncelNotify notify) throws MeterException {
        if (this.portManager != null) {
            this.portManager.closePort();
            this.portManager = null;
        }

        this.Execute_Reset();

        this.seed = null;

        this.portManager = new PortManager(control, device, new DeviceClientEventListener() {

            /**
             * @param bytes
             * @description: 连接监听
             */
            @Override
            public void onClientEvent(byte[] bytes) throws MeterException {
                long timestamp = System.currentTimeMillis();

                String accept = cache + ByteUtils.bytes2HexString(bytes);

                System.out.printf("%s 串口监听 内容： %s%n", timestamp, accept);

                while (StringUtils.isNotBlank(accept)) {
                    int start_index = ByteUtils.indexOf(accept, TOP);
                    if (start_index == -1) return;
                    accept = accept.substring(start_index);
                    int end_index = ByteUtils.indexOf(accept, END);
                    if (end_index == -1) {
                        cache = accept;
                        return;
                    }
                    String command = accept.substring(0, end_index + 2);

                    System.out.printf("%s 串口监听 有效数据包 内容 %s%n", timestamp, AuncelUtils.hexPrint(command));

                    AuncelResponse auncelResponse = new AuncelResponse(command).execute();

                    System.out.printf("%s [%s] 接受数据包： %s %s%n", timestamp, auncelResponse.getNid(), auncelResponse.getClass().getName(), auncelResponse.toJSON());

                    if (auncelResponse instanceof AL_Handle_Reset_Notify) {
                        Execute_Reset();
                        GlobalPara.getInstance().executor().execute(() -> {
                            try {
                                al_handle();
                            } catch (MeterException e) {
                                throw new RuntimeException(e);
                            }
                        });
                        // if (!al_handle()) throw new MeterException(MeterStateEnum.TP初始化握手失败);
                    } else {
                        response = auncelResponse;
                    }
                    accept = accept.substring(end_index + 2);
                }
            }

            /**
             * @param e
             * @description: 连接异常监听
             */
            @Override
            public void onClientEventExp(MeterException e) {
                if (notify != null) notify.exp(e);
            }
        });
        boolean result = this.portManager.openPort();
        if (!result) {
            this.portManager = null;
        } else {
            this.notify = notify;
        }
        return result;
    }

    /**
     * @description: 天平握手
     **/
    private synchronized boolean al_handle() throws MeterException {
        if (this.read_weight_thread != null) {
            this.read_weight_thread.action = false;
            this.read_weight_thread = null;
        }

        Handle1Response handle1Response = this.execute(new Handle1Request());
        if (handle1Response != null && handle1Response.isResult()) {
            Handle2Response handle2Response = this.execute(new Handle2Request().setCpt(CPT.Color_Acl).setSeed(handle1Response.getSeed()));
            if (handle2Response != null && handle2Response.isResult()) {
                this.seed = handle1Response.getSeed();

                this.read_weight_thread = new Read_Weight_Thread();
                this.read_weight_thread.start();

                return true;
            }
        }
        return false;
    }

    /**
     * @description: 发送请求 数据
     **/
    public synchronized <T extends AuncelRequest, U extends AuncelResponse> U execute(AuncelRequest<T, U> request) throws MeterException {
        if (this.request != null) throw new MeterException(MeterStateEnum.TP请求中稍后再试);

        long timestamp = System.currentTimeMillis();

        String command = request.execute().over();

        System.out.printf("%s [%s] 发送数据包： %s %s%n", timestamp, request.getNid(), request.getClass().getName(), request.toJSON());

        AuncelResponse response = null;
        try {
            if (this.read_weight_thread != null) this.read_weight_thread.pause();

            this.request = request;

            int recount = 0;
            while (recount < this.recount) {

                System.out.printf("%s 串口发送 内容： %s%n", timestamp, AuncelUtils.hexPrint(command));

                // 发送数据
                this.portManager.writeDataImmediately(ByteUtils.fromHexString(command));

                int cycle_count = 0;
                while (cycle_count < this.cycle_count) {
                    this.cycle_sleep();
                    if (this.response != null) {
                        response = this.response;
                        break;
                    }
                    cycle_count++;
                }

                if (response != null) break;
                recount++;
            }

            this.Execute_Reset();
        } finally {
            if (this.read_weight_thread != null) this.read_weight_thread.pause();
        }

        return (U) response;
    }

    /**
     * @description: 请求对象重置
     **/
    public AuncelManager Execute_Reset() {
        this.request = null;
        this.response = null;
        this.cache = "";
        return this;
    }

    /**
     * @description: 等待周期循环
     **/
    private void cycle_sleep() {
        try {
            Thread.sleep(this.cycle_timeout);
        } catch (InterruptedException e) {
        }
    }

    public String getSeed() {
        return seed;
    }

    /**
     * @description: 读取 重量线程
     **/
    public class Read_Weight_Thread extends Thread {

        private boolean action = true;

        private boolean pause = false;

        @Override
        public void run() {
            while (action) {
                if (!pause) {
                    try {
                        AL_0B_ReadWeightResponse al_0B_readWeightResponse = execute(new AL_0B_ReadWeightRequest());
                        if (notify != null) notify.notify(al_0B_readWeightResponse);
                    } catch (MeterException e) {
                        if (notify != null) notify.exp(e);
                    }
                }

                try {
                    Thread.sleep(read_cycle);
                } catch (InterruptedException e) {
                }
            }
        }

        public void pause() {
            this.pause = !this.pause;
        }
    }
}
