package com.jhscale.meter.auncel;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.utils.AesHexUtils;
import com.jhscale.meter.utils.ByteUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;

/**
 * @author wang lie
 * @version 1.0
 * @projectName meter-jar
 * @title AuncelUtils
 * @description
 * @create 2024/1/3 18:13
 */
public class AuncelUtils {

    private AuncelUtils() {
    }

    public static final String TOP = "A5";
    public static final int TOP_V = 165;
    public static final String TOP_T = "85";
    public static final int TOP_TV = 133;

    public static final String END = "5A";
    public static final int END_V = 90;
    public static final String END_T = "7A";
    public static final int END_TV = 122;

    public static final String REPLACE = "55";
    public static final int REPLACE_V = 85;
    public static final String REPLACE_T = "75";
    public static final int REPLACE_TV = 117;

    private static final String AES_KEY1 = "57A2F04822775D16875B6398E9C51E37";

    private static final int[] Protocal2_Encode1 = {
            0xC9, 0x59, 0x14, 0x52, 0x6C, 0x04, 0xEC, 0xAD, 0x43, 0xA6, 0xAA, 0xD0, 0x07, 0x74, 0x68, 0x71,    //000000
            0x8F, 0x1E, 0x62, 0xDF, 0xFE, 0x3E, 0x96, 0x69, 0xA0, 0x8D, 0x0E, 0x8A, 0x3C, 0xBE, 0xE2, 0xC4,    //000010
            0x53, 0xE5, 0xC3, 0x3D, 0x70, 0x0D, 0xF9, 0x9A, 0x72, 0x7F, 0x85, 0xE9, 0x41, 0xB1, 0xE7, 0x36,    //000020
            0xF4, 0x0B, 0x47, 0xD6, 0xC6, 0xBC, 0xA1, 0x0F, 0x77, 0x26, 0x2E, 0x38, 0x01, 0x5E, 0xB8, 0xF7,    //000030
            0x20, 0x6E, 0xF6, 0xCC, 0x9C, 0x3F, 0x4D, 0xF2, 0x76, 0x5B, 0x35, 0x55, 0x45, 0x30, 0x2C, 0x31,    //000040
            0xE8, 0xCD, 0xAE, 0x7E, 0x63, 0x1A, 0x42, 0x9D, 0x1B, 0x10, 0x09, 0xE0, 0xCA, 0x8E, 0x88, 0x75,    //000050
            0x87, 0x58, 0x91, 0xDD, 0xB4, 0x02, 0x6F, 0x5A, 0x54, 0x9B, 0xC2, 0x33, 0xFC, 0x6D, 0x98, 0x5C,    //000060
            0x94, 0x84, 0xA5, 0x3A, 0x4A, 0x8B, 0xEA, 0xD1, 0xD7, 0x7C, 0xD5, 0x24, 0xE6, 0x39, 0x56, 0x16,    //000070
            0x65, 0x1D, 0x2F, 0x79, 0x48, 0x19, 0xE4, 0x57, 0xB2, 0x18, 0x9F, 0xBF, 0xF8, 0x5F, 0x2A, 0x12,    //000080
            0xEB, 0x00, 0xF0, 0xFF, 0x28, 0x6B, 0x80, 0x6A, 0xAC, 0xED, 0xF5, 0x0A, 0xBB, 0x81, 0x2B, 0xB5,    //000090
            0xCE, 0xDB, 0x97, 0x37, 0x32, 0x8C, 0x93, 0xD9, 0x1C, 0xA8, 0xD2, 0x23, 0xFD, 0x3B, 0x46, 0xB9,    //0000A0
            0x9E, 0x83, 0xDE, 0x29, 0x66, 0x5D, 0xAB, 0xB6, 0xC0, 0x7A, 0x4C, 0xB0, 0x95, 0x27, 0xBD, 0xD3,    //0000B0
            0xE1, 0x25, 0x7D, 0x21, 0xCF, 0xF1, 0x06, 0x82, 0xFB, 0xC1, 0x44, 0xD8, 0x67, 0x51, 0x50, 0x86,    //0000C0
            0x05, 0x7B, 0xA2, 0x89, 0x90, 0xDC, 0x2D, 0xA3, 0x4B, 0x4E, 0xF3, 0xB3, 0xFA, 0x08, 0x40, 0xBA,    //0000D0
            0xEF, 0x1F, 0x0C, 0xDA, 0x03, 0x49, 0x92, 0xA7, 0x4F, 0xEE, 0xA9, 0xC5, 0xAF, 0x64, 0xB7, 0x17,    //0000E0
            0xC7, 0x13, 0x60, 0xCB, 0xE3, 0x15, 0x11, 0xA4, 0xD4, 0x73, 0x34, 0x78, 0x99, 0x61, 0x22, 0xC8,    //0000F0
    };

    private static final int[] Protocal2_Encode2 = {
            0x7B, 0x57, 0xB3, 0x44, 0x2B, 0xFC, 0x38, 0x32, 0x0B, 0x29, 0x1E, 0x95, 0x22, 0x79, 0xBF, 0xDD,    //000000
            0x1D, 0x69, 0x56, 0x1F, 0x9D, 0xB2, 0xF2, 0xC7, 0x90, 0x67, 0xC2, 0x15, 0xBC, 0x0C, 0x4E, 0xBA,    //000010
            0x7D, 0x33, 0xEE, 0x23, 0x7E, 0x5E, 0xBB, 0xE9, 0x83, 0xE0, 0xD2, 0x30, 0xAA, 0x48, 0xA5, 0x76,    //000020
            0xF5, 0xFA, 0x8A, 0x81, 0x64, 0xAF, 0x65, 0x31, 0x5D, 0x9A, 0xEF, 0xD6, 0x0D, 0x6E, 0x73, 0xF4,    //000030
            0xB6, 0x4D, 0x71, 0x07, 0x2E, 0x42, 0x36, 0x50, 0xF3, 0x4C, 0x00, 0x8F, 0xCE, 0x85, 0xE8, 0x98,    //000040
            0xEC, 0xD8, 0x7F, 0xE6, 0x80, 0x8B, 0x66, 0x2F, 0x84, 0x1B, 0x54, 0x52, 0x49, 0x25, 0xAE, 0x08,    //000050
            0x24, 0xF0, 0xC8, 0x87, 0xD7, 0x72, 0x88, 0x0A, 0x91, 0xF8, 0x92, 0xE2, 0x59, 0x17, 0x70, 0x7A,    //000060
            0x2C, 0xD9, 0x4A, 0x13, 0x9B, 0x28, 0xA2, 0x18, 0x96, 0x40, 0xED, 0x21, 0x47, 0xA8, 0xA7, 0x3D,    //000070
            0x11, 0x5C, 0x6F, 0xC4, 0x6C, 0x77, 0x5B, 0xFE, 0xA1, 0x3A, 0x51, 0x10, 0xEB, 0xC3, 0x0E, 0xB5,    //000080
            0x5F, 0xFF, 0x3F, 0x2D, 0xE5, 0x8E, 0x3C, 0xB8, 0x16, 0x46, 0xBE, 0x6D, 0x05, 0x0F, 0x8D, 0xD0,    //000090
            0x9E, 0x86, 0x8C, 0xD1, 0x94, 0x1A, 0x37, 0xDE, 0x04, 0xC0, 0xCD, 0x3E, 0xFD, 0xCC, 0xA6, 0x9F,    //0000A0
            0x14, 0x41, 0xD5, 0x09, 0xC6, 0x27, 0xE4, 0xEA, 0xBD, 0xB7, 0x4F, 0xFB, 0x5A, 0xC5, 0x53, 0xB1,    //0000B0
            0x61, 0x35, 0x74, 0xAD, 0x58, 0xDA, 0xE7, 0xF6, 0xB4, 0x7C, 0x78, 0xB0, 0x19, 0xA3, 0x63, 0x39,    //0000C0
            0xF7, 0x3B, 0xD3, 0xCA, 0xDF, 0x55, 0xCF, 0xA0, 0xA4, 0x6B, 0x06, 0x01, 0x60, 0x6A, 0xA9, 0xD4,    //0000D0
            0x20, 0x75, 0x99, 0x4B, 0xCB, 0xAC, 0x03, 0xE1, 0x1C, 0xC9, 0x93, 0x43, 0x68, 0x89, 0x62, 0xAB,    //0000E0
            0x45, 0xE3, 0xB9, 0xDC, 0x02, 0x34, 0xDB, 0x12, 0x26, 0x82, 0x97, 0x9C, 0xF1, 0x2A, 0xC1, 0xF9,    //0000F0
    };

    private static final String AES_KEY2 = "C30A8F7E529B1D5F4C6E2B0D91438AE7";

    private static final int[] Protocal2_Encode3 = {
            0xAB, 0x43, 0xE8, 0x3E, 0x96, 0x75, 0x0B, 0x58, 0xD7, 0xC7, 0x24, 0x62, 0x33, 0x17, 0x7F, 0xC0,    //000000
            0xDF, 0xCC, 0x3D, 0x4D, 0xA0, 0x86, 0xC8, 0xE3, 0x60, 0xAF, 0x83, 0x88, 0xEF, 0x09, 0x5D, 0x59,    //000010
            0x30, 0x1B, 0xE7, 0xD4, 0xD0, 0x51, 0xFC, 0xA1, 0x69, 0x3A, 0x5C, 0xDB, 0x49, 0x6A, 0x22, 0xF6,    //000020
            0xCB, 0x19, 0x4F, 0xF4, 0xD3, 0x1A, 0xC5, 0xC9, 0x0D, 0xF3, 0x06, 0xA2, 0xD5, 0x14, 0x91, 0xE4,    //000030
            0x46, 0xDA, 0xB7, 0x40, 0x44, 0x67, 0x03, 0x0A, 0xAE, 0xF8, 0xEE, 0x97, 0x4C, 0xC2, 0x1F, 0x21,    //000040
            0x7E, 0x02, 0x66, 0xEB, 0x87, 0x42, 0x0C, 0xFF, 0xD6, 0x36, 0x5B, 0xCF, 0x71, 0x07, 0xBF, 0xCE,    //000050
            0x82, 0x8D, 0x26, 0x6B, 0x1C, 0x92, 0x5F, 0xB6, 0x95, 0x98, 0x25, 0x84, 0xEA, 0xA8, 0x72, 0x29,    //000060
            0xED, 0x37, 0x5A, 0x39, 0xA4, 0x76, 0xDC, 0xC6, 0x4E, 0x7B, 0x9A, 0x9F, 0x20, 0xB3, 0x7A, 0x81,    //000070
            0x6F, 0x77, 0x9B, 0xF9, 0xA9, 0x5E, 0x2D, 0x73, 0x9C, 0xA6, 0x28, 0x8B, 0x11, 0xE9, 0x04, 0x8E,    //000080
            0xB9, 0xB8, 0xA3, 0x6C, 0x56, 0x55, 0x01, 0xF0, 0x90, 0x94, 0x54, 0xBD, 0x53, 0xAC, 0x68, 0xAD,    //000090
            0x1E, 0x34, 0xFA, 0xF7, 0xCA, 0xB5, 0x13, 0x3C, 0xE6, 0x08, 0x12, 0x7D, 0x0F, 0xA5, 0x50, 0x1D,    //0000A0
            0xDE, 0xAA, 0xE2, 0xFE, 0x65, 0xDD, 0x7C, 0x64, 0x4B, 0x78, 0x48, 0x89, 0xE1, 0x23, 0x15, 0xF1,    //0000B0
            0x05, 0xD9, 0xC1, 0x3F, 0x3B, 0xBA, 0x00, 0xA7, 0xF2, 0x8C, 0xC3, 0x10, 0x80, 0xEC, 0x8F, 0x27,    //0000C0
            0xE5, 0x2B, 0xBE, 0x85, 0xCD, 0xBC, 0x2C, 0x63, 0x0E, 0x38, 0xFB, 0xB1, 0xD2, 0x2A, 0x79, 0x52,    //0000D0
            0xB2, 0x9E, 0x99, 0x18, 0x6E, 0x2F, 0x35, 0x4A, 0x93, 0x45, 0x32, 0xF5, 0x61, 0x41, 0xD1, 0x2E,    //0000E0
            0x57, 0x70, 0xBB, 0xE0, 0xB4, 0x47, 0x6D, 0xFD, 0x74, 0x31, 0x16, 0xB0, 0x8A, 0xD8, 0x9D, 0xC4,    //0000F0
    };

    private static final int[] Protocal2_Encode4 = {
            0xC6, 0x96, 0x51, 0x46, 0x8E, 0xC0, 0x3A, 0x5D, 0xA9, 0x1D, 0x47, 0x06, 0x56, 0x38, 0xD8, 0xAC,    //000000
            0xCB, 0x8C, 0xAA, 0xA6, 0x3D, 0xBE, 0xFA, 0x0D, 0xE3, 0x31, 0x35, 0x21, 0x64, 0xAF, 0xA0, 0x4E,    //000010
            0x7C, 0x4F, 0x2E, 0xBD, 0x0A, 0x6A, 0x62, 0xCF, 0x8A, 0x6F, 0xDD, 0xD1, 0xD6, 0x86, 0xEF, 0xE5,    //000020
            0x20, 0xF9, 0xEA, 0x0C, 0xA1, 0xE6, 0x59, 0x71, 0xD9, 0x73, 0x29, 0xC4, 0xA7, 0x12, 0x03, 0xC3,    //000030
            0x43, 0xED, 0x55, 0x01, 0x44, 0xE9, 0x40, 0xF5, 0xBA, 0x2C, 0xE7, 0xB8, 0x4C, 0x13, 0x78, 0x32,    //000040
            0xAE, 0x25, 0xDF, 0x9C, 0x9A, 0x95, 0x94, 0xF0, 0x07, 0x1F, 0x72, 0x5A, 0x2A, 0x1E, 0x85, 0x66,    //000050
            0x18, 0xEC, 0x0B, 0xD7, 0xB7, 0xB4, 0x52, 0x45, 0x9E, 0x28, 0x2D, 0x63, 0x93, 0xF6, 0xE4, 0x80,    //000060
            0xF1, 0x5C, 0x6E, 0x87, 0xF8, 0x05, 0x75, 0x81, 0xB9, 0xDE, 0x7E, 0x79, 0xB6, 0xAB, 0x50, 0x0E,    //000070
            0xCC, 0x7F, 0x60, 0x1A, 0x6B, 0xD3, 0x15, 0x54, 0x1B, 0xBB, 0xFC, 0x8B, 0xC9, 0x61, 0x8F, 0xCE,    //000080
            0x98, 0x3E, 0x65, 0xE8, 0x99, 0x68, 0x04, 0x4B, 0x69, 0xE2, 0x7A, 0x82, 0x88, 0xFE, 0xE1, 0x7B,    //000090
            0x14, 0x27, 0x3B, 0x92, 0x74, 0xAD, 0x89, 0xC7, 0x6D, 0x84, 0xB1, 0x00, 0x9D, 0x9F, 0x48, 0x19,    //0000A0
            0xFB, 0xDB, 0xE0, 0x7D, 0xF4, 0xA5, 0x67, 0x42, 0x91, 0x90, 0xC5, 0xF2, 0xD5, 0x9B, 0xD2, 0x5E,    //0000B0
            0x0F, 0xC2, 0x4D, 0xCA, 0xFF, 0x36, 0x77, 0x09, 0x16, 0x37, 0xA4, 0x30, 0x11, 0xD4, 0x5F, 0x5B,    //0000C0
            0x24, 0xEE, 0xDC, 0x34, 0x23, 0x3C, 0x58, 0x08, 0xFD, 0xC1, 0x41, 0x2B, 0x76, 0xB5, 0xB0, 0x10,    //0000D0
            0xF3, 0xBC, 0xB2, 0x17, 0x3F, 0xD0, 0xA8, 0x22, 0x02, 0x8D, 0x6C, 0x53, 0xCD, 0x70, 0x4A, 0x1C,    //0000E0
            0x97, 0xBF, 0xC8, 0x39, 0x33, 0xEB, 0x2F, 0xA3, 0x49, 0x83, 0xA2, 0xDA, 0x26, 0xF7, 0xB3, 0x57,    //0000F0
    };

    /**
     * @description: 字符串转码
     **/
    private static String code(String str, int[] arr) throws MeterException {
        if (StringUtils.isBlank(str) || str.length() % 2 != 0)
            throw new MeterException(MeterStateEnum.TP数据包格式错误);

        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < (str.length() / 2); i++) {
            int index = Integer.parseInt(str.substring(i * 2, i * 2 + 2), 16);
            String val = Integer.toHexString(arr[index]);
            if (val.length() != 2) {
                val = "0" + val;
            }
            stringBuffer.append(val);
        }
        return stringBuffer.toString().toUpperCase();
    }

    /**
     * @description: 握手1加密
     **/
    public static String handshake_ack(String seed) throws MeterException {
        byte[] ebs1 = AesHexUtils.encrypt_byte(code(seed, Protocal2_Encode1), AES_KEY1);
        byte[] ebs2 = reverse(ebs1);
        return ByteUtils.toHexString(ebs2);
    }

    /**
     * @description: Token
     **/
    public static String token(String seed) throws MeterException {
        return token(seed, null);
    }

    public static String token(String seed, String aeskey) throws MeterException {
        byte[] ebs1 = AesHexUtils.encrypt_byte(code(seed, Protocal2_Encode2), StringUtils.isNotBlank(aeskey) ? aeskey : AES_KEY2);
        byte[] ebs2 = reverse(ebs1);
        return ByteUtils.toHexString(ebs2);
    }

    /**
     * @description: 内容加解密
     **/
    public static String encrypt(String content, String seed) throws MeterException {
        byte[] ebs1 = AesHexUtils.encrypt_byte(code(content, Protocal2_Encode3), token(seed));
        byte[] ebs2 = reverse(ebs1);
        return ByteUtils.toHexString(ebs2);
    }

    public static String decrypt(String content, String seed) throws MeterException {
        byte[] eds1 = ByteUtils.fromHexString(content);
        byte[] eds2 = reverse(eds1);
        return code(AesHexUtils.decrypt_byte(eds2, token(seed)), Protocal2_Encode4);
    }

    /**
     * @description: 字节转换
     **/
    public static byte[] reverse(byte[] bs1) {
        byte[] bs2 = new byte[bs1.length];
        for (int i = 0; i < bs1.length; i = i + 4) {
            byte[] p = Arrays.copyOfRange(bs1, i, i + 4);
            for (int j = 0; j < p.length; j++) {
                bs2[i + j] = p[p.length - 1 - j];
            }
        }
        return bs2;
    }

    /**
     * @description: HEX 打印
     **/
    public static String hexPrint(String hex) {
        if (StringUtils.isBlank(hex)) return "";
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < hex.length(); i = i + 2) {
            builder.append(hex.substring(i, i + 2))
                    .append(" ");
        }
        return builder.toString();
    }

    public static void main(String[] args) throws MeterException {
        String str = "000102030405060708090A0B0C0D0E0F";
        byte[] ebs1 = AesHexUtils.encrypt_byte(str, str);
        byte[] ebs2 = reverse(ebs1);
        String encrypt = ByteUtils.toHexString(ebs2);
        System.out.println("加密后：" + encrypt);

        byte[] eds1 = ByteUtils.fromHexString(encrypt);
        byte[] eds2 = reverse(eds1);
        String decrypt = AesHexUtils.decrypt_byte(eds2, str);
        System.out.println("解密后：" + decrypt);
    }

    private static Integer nid;

    /**
     * @description: NID
     **/
    public synchronized static int nid() {
        if (nid == null) {
            nid = (int) (Math.random() * 255);
        } else {
            nid = nid + 1;
        }
        return nid;
    }
}
