package com.jhscale.meter.auncel.cmd;

import com.jhscale.common.utils.RandomUtils;
import com.jhscale.meter.auncel.em.CPT;
import com.jhscale.meter.auncel.entity.ALMack;
import com.jhscale.meter.auncel.entity.AuncelRequest;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.mqtt.em.ACK;
import com.jhscale.meter.mqtt.em.Confirm;
import com.jhscale.meter.mqtt.em.Encrypt;
import com.jhscale.meter.utils.ByteUtils;

/**
 * @author wang lie
 * @version 1.0
 * @projectName meter-jar
 * @title AL_05_LoginRequest
 * @description
 * @create 2024/1/4 9:29
 */
public class AL_05_LoginRequest extends AuncelRequest<AL_05_LoginRequest, AL_05_LoginResponse> {

    private int id;

    private String pwd;

    public AL_05_LoginRequest() {
        super(new ALMack()
                .setEncrypt(Encrypt.AES_Encrypt)
                .setAck(ACK.Request)
                .setConfirm(Confirm.WAIT)
                .setCpt(CPT.Color_Acl));
    }

    /**
     * @description: 内容体填充
     **/
    @Override
    protected void inner_execute() throws MeterException {
        this.source_inner.append("05")
                .append(ByteUtils.ten2Hex(this.id, 2))
                .append(ByteUtils.ten2Hex(this.pwd.length(), 2))
                .append(ByteUtils.ascii2Hex(this.pwd))
                .append(ByteUtils.ascii2Hex(RandomUtils.getRandomStringByLength(8 - this.pwd.length() + 4)))
                .append(this.inner_crc());
    }

    public int getId() {
        return id;
    }

    public AL_05_LoginRequest setId(int id) {
        this.id = id;
        return this;
    }

    public String getPwd() {
        return pwd;
    }

    public AL_05_LoginRequest setPwd(String pwd) {
        this.pwd = pwd;
        return this;
    }
}
