package com.jhscale.meter.auncel.cmd;

import com.jhscale.common.utils.RandomUtils;
import com.jhscale.meter.auncel.em.CPT;
import com.jhscale.meter.auncel.entity.ALMack;
import com.jhscale.meter.auncel.entity.AuncelRequest;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.mqtt.em.ACK;
import com.jhscale.meter.mqtt.em.Confirm;
import com.jhscale.meter.mqtt.em.Encrypt;
import com.jhscale.meter.utils.ByteUtils;

/**
 * @author wang lie
 * @version 1.0
 * @projectName meter-jar
 * @title AL_05_LoginRequest
 * @description
 * @create 2024/1/4 9:29
 */
public class AL_07_EditPWDRequest extends AuncelRequest<AL_07_EditPWDRequest, AL_07_EditPWDResponse> {

    private int id;

    private String oldPwd;

    private String newPwd;

    public AL_07_EditPWDRequest() {
        super(new ALMack()
                .setEncrypt(Encrypt.AES_Encrypt)
                .setAck(ACK.Request)
                .setConfirm(Confirm.WAIT)
                .setCpt(CPT.Color_Acl));
    }

    /**
     * @description: 内容体填充
     **/
    @Override
    protected void inner_execute() throws MeterException {
        this.source_inner.append("07")
                .append(ByteUtils.ten2Hex(this.id, 2))
                .append(ByteUtils.ten2Hex(this.oldPwd.length(), 2))
                .append(ByteUtils.ascii2Hex(this.oldPwd))
                .append(ByteUtils.ascii2Hex(RandomUtils.getRandomStringByLength(8 - this.oldPwd.length() + 5)))
                .append(ByteUtils.ten2Hex(this.newPwd.length(), 2))
                .append(ByteUtils.ascii2Hex(this.newPwd))
                .append(ByteUtils.ascii2Hex(RandomUtils.getRandomStringByLength(8 - this.newPwd.length() + 6)))
                .append(this.inner_crc());
    }

    public int getId() {
        return id;
    }

    public AL_07_EditPWDRequest setId(int id) {
        this.id = id;
        return this;
    }

    public String getOldPwd() {
        return oldPwd;
    }

    public AL_07_EditPWDRequest setOldPwd(String oldPwd) {
        this.oldPwd = oldPwd;
        return this;
    }

    public String getNewPwd() {
        return newPwd;
    }

    public AL_07_EditPWDRequest setNewPwd(String newPwd) {
        this.newPwd = newPwd;
        return this;
    }
}
