package com.jhscale.meter.auncel.cmd;

import com.jhscale.common.utils.RandomUtils;
import com.jhscale.meter.auncel.em.CPT;
import com.jhscale.meter.auncel.entity.ALMack;
import com.jhscale.meter.auncel.entity.AuncelRequest;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.mqtt.em.ACK;
import com.jhscale.meter.mqtt.em.Confirm;
import com.jhscale.meter.mqtt.em.Encrypt;
import com.jhscale.meter.utils.ByteUtils;

/**
 * @author wang lie
 * @version 1.0
 * @projectName meter-jar
 * @title AL_05_LoginRequest
 * @description
 * @create 2024/1/4 9:29
 */
public class AL_09_WriteOnlyRequest extends AuncelRequest<AL_09_WriteOnlyRequest, AL_09_WriteOnlyResponse> {

    private int weightProfile;

    private int printProfile;

    public AL_09_WriteOnlyRequest() {
        super(new ALMack()
                .setEncrypt(Encrypt.AES_Encrypt)
                .setAck(ACK.Request)
                .setConfirm(Confirm.WAIT)
                .setCpt(CPT.Color_Acl));
    }

    /**
     * @description: 内容体填充
     **/
    @Override
    protected void inner_execute() throws MeterException {
        this.source_inner.append("09")
                .append(ByteUtils.ten2Hex(weightProfile, 8))
                .append(ByteUtils.ten2Hex(printProfile, 8))
                .append(RandomUtils.getRandomStringByLength(6))
                .append(this.inner_crc());
    }

    public int getWeightProfile() {
        return weightProfile;
    }

    public AL_09_WriteOnlyRequest setWeightProfile(int weightProfile) {
        this.weightProfile = weightProfile;
        return this;
    }

    public int getPrintProfile() {
        return printProfile;
    }

    public AL_09_WriteOnlyRequest setPrintProfile(int printProfile) {
        this.printProfile = printProfile;
        return this;
    }
}
