package com.jhscale.meter.auncel.cmd;

import com.jhscale.common.utils.RandomUtils;
import com.jhscale.meter.auncel.em.CPT;
import com.jhscale.meter.auncel.entity.ALMack;
import com.jhscale.meter.auncel.entity.AuncelRequest;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.mqtt.em.ACK;
import com.jhscale.meter.mqtt.em.Confirm;
import com.jhscale.meter.mqtt.em.Encrypt;
import com.jhscale.meter.utils.ByteUtils;

/**
 * @author wang lie
 * @version 1.0
 * @projectName meter-jar
 * @title AL_05_LoginRequest
 * @description
 * @create 2024/1/4 9:29
 */
public class AL_0A_WriteRWRequest extends AuncelRequest<AL_0A_WriteRWRequest, AL_0A_WriteRWResponse> {

    private int bapPara;

    public AL_0A_WriteRWRequest() {
        super(new ALMack()
                .setEncrypt(Encrypt.AES_Encrypt)
                .setAck(ACK.Request)
                .setConfirm(Confirm.WAIT)
                .setCpt(CPT.Color_Acl));
    }

    /**
     * @description: 内容体填充
     **/
    @Override
    protected void inner_execute() throws MeterException {
        this.source_inner.append("0A")
                .append(ByteUtils.ten2Hex(bapPara, 8))
                .append(RandomUtils.getRandomStringByLength(13))
                .append(this.inner_crc());
    }

    public int getBapPara() {
        return bapPara;
    }

    public AL_0A_WriteRWRequest setBapPara(int bapPara) {
        this.bapPara = bapPara;
        return this;
    }
}
