package com.jhscale.meter.auncel.cmd;

import com.jhscale.meter.auncel.entity.AuncelResponse;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.mqtt.em.Confirm;
import com.jhscale.meter.utils.ByteUtils;

/**
 * @author wang lie
 * @version 1.0
 * @projectName meter-jar
 * @title AL_05_LoginRequest
 * @description
 * @create 2024/1/4 9:29
 */
public class AL_0B_ReadWeightResponse extends AuncelResponse<AL_0B_ReadWeightRequest, AL_0B_ReadWeightResponse> {

    private boolean result;

    // bit23	bit22	bit21	bit20	bit19-16	bit15	bit14	bit13	bit12-0
    // NR	    ADC	    OVFH	OVFL	REV	        LOG	    RxB	    ISO	    REV
    //
    // ADC：	 当秤体硬件发生问题时，该位置1
    // OVFH：	 超重时，该位置1
    // OVFL：	 欠重时，该位置1
    // NR：      Weight Not Ready
    private String err_code;

    // bit23	bit22	bit21	bit20	bit19	bit18	bit17-16	bit15	bit14	bit13	bit12-8	bit7-4	bit3	bit2-0
    // STB	    ZERO	TARE	NEG	    TareC	CMD	    REV	        LOG	    RxB	    ISO	    UNIT	DP	    REV	    NetH
    //
    // STB：     重量稳定时，该位置1
    // ZERO：    重为0时，该位置1
    // TARE：    皮重不为0时，该位置1
    // NEG：     净重为负时，该位置1
    // TareC:    Tare changed since last update.
    // RxB:      Data available in COM port
    // CMD:	     command in progress(ZERO,TARE,ect)
    // ISO:		 isoCAL need to be done
    // UNIT:	 Current unit
    // DP:		 Decimal point
    // LOG：	 login status
    // 0xF	0xE	0xD	0xC	0xB	0xA	    0x9	    0x8	    0x7	    0x6	    0x5	    0x4	    0x3	    0x2	    0x1	    0x0
    // 1000	100	10	1	0.1	0.01	0.001	1E-4	1E-5	1E-6	1E-7	1E-8	1E-9	1E-10	1E-11	1E-12
    // REV:	Reserved
    private String status;

    private String outCode;

    private String innerCode;

    public AL_0B_ReadWeightResponse() {
    }

    public AL_0B_ReadWeightResponse(AL_0B_ReadWeightRequest request, String content) {
        super(request, content);
    }

    /**
     * @description: 内容体填充
     **/
    @Override
    protected void inner_execute() throws MeterException {
        this.result = Confirm.SUCCESS.equals(this.alMack.getConfirm());
        if (!this.result) {
            this.err_code = ByteUtils.hex2Bin(this.source_inner.substring(2), 3);
            return;
        }

        this.inner_crc();

        this.status = ByteUtils.hex2Bin(this.source_inner.substring(2, 8), 3);
        this.outCode = ByteUtils.hex2Ascii(this.source_inner.substring(8, 14)).trim();
        this.innerCode = ByteUtils.hex2Ascii(this.source_inner.substring(14, 22)).trim();
    }

    public boolean isResult() {
        return result;
    }

    public String getErr_code() {
        return err_code;
    }

    public String getStatus() {
        return status;
    }

    public String getOutCode() {
        return outCode;
    }

    public String getInnerCode() {
        return innerCode;
    }
}
