package com.jhscale.meter.auncel.cmd;

import com.jhscale.meter.auncel.entity.AuncelResponse;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.mqtt.em.Confirm;
import com.jhscale.meter.utils.ByteUtils;

/**
 * @author wang lie
 * @version 1.0
 * @projectName meter-jar
 * @title AL_05_LoginRequest
 * @description
 * @create 2024/1/4 9:29
 */
public class AL_0C_ReadTareResponse extends AuncelResponse<AL_0C_ReadTareRequest, AL_0C_ReadTareResponse> {

    private boolean result;

    // bit23	bit22-16	bit15	bit14	bit13	bit12-0
    // NR	    REV	        LOG	    RxB	    ISO	    REV
    private String err_code;

    // bit23-16	bit15	bit14	bit13	bit12-8	bit7-4	bit3	bit2-0
    //  REV	    LOG	    RxB	    ISO	    UNIT	DP	    REV	    TareH
    private String status;

    private String outCode;

    private String innerCode;

    public AL_0C_ReadTareResponse() {
    }

    public AL_0C_ReadTareResponse(AL_0C_ReadTareRequest request, String content) {
        super(request, content);
    }

    /**
     * @description: 内容体填充
     **/
    @Override
    protected void inner_execute() throws MeterException {
        this.result = Confirm.SUCCESS.equals(this.alMack.getConfirm());
        if (!this.result) {
            this.err_code = ByteUtils.hex2Bin(this.source_inner.substring(2), 3);
            return;
        }

        this.inner_crc();

        this.status = ByteUtils.hex2Bin(this.source_inner.substring(2, 8), 3);
        this.outCode = ByteUtils.hex2Ascii(this.source_inner.substring(8, 14)).trim();
        this.innerCode = ByteUtils.hex2Ascii(this.source_inner.substring(14, 22)).trim();
    }

    public boolean isResult() {
        return result;
    }

    public String getErr_code() {
        return err_code;
    }

    public String getStatus() {
        return status;
    }

    public String getOutCode() {
        return outCode;
    }

    public String getInnerCode() {
        return innerCode;
    }
}
