package com.jhscale.meter.auncel.cmd;

import com.jhscale.meter.auncel.entity.AuncelResponse;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.mqtt.em.Confirm;
import com.jhscale.meter.utils.ByteUtils;

/**
 * @author wang lie
 * @version 1.0
 * @projectName meter-jar
 * @title AL_05_LoginRequest
 * @description
 * @create 2024/1/4 9:29
 */
public class AL_0E_SetZeroResponse extends AuncelResponse<AL_0E_SetZeroRequest, AL_0E_SetZeroResponse> {

    /**
     * @description: 随机码
     **/
    private boolean result;

    // 错误码
    // bit23	bit22	bit21	bit20	bit19-0
    // NR	    ORH	    ORL	    IC	    REV
    // ORH: Out of range high.
    // ORL: Out of range low.
    // IC: Invalid Command.
    private String err_code;

    public AL_0E_SetZeroResponse() {
    }

    public AL_0E_SetZeroResponse(AL_0E_SetZeroRequest request, String content) {
        super(request, content);
    }

    /**
     * @description: 内容体填充
     **/
    @Override
    protected void inner_execute() throws MeterException {
        this.result = Confirm.SUCCESS.equals(this.alMack.getConfirm());
        if (!this.result) this.err_code = ByteUtils.hex2Bin(this.source_inner.substring(2), 3);
    }

    public boolean isResult() {
        return result;
    }

    public String getErr_code() {
        return err_code;
    }
}
