package com.jhscale.meter.auncel.cmd;

import com.jhscale.meter.auncel.em.CPT;
import com.jhscale.meter.auncel.entity.ALMack;
import com.jhscale.meter.auncel.entity.AuncelRequest;
import com.jhscale.meter.mqtt.em.ACK;
import com.jhscale.meter.mqtt.em.Confirm;
import com.jhscale.meter.mqtt.em.Encrypt;

/**
 * @author wang lie
 * @version 1.0
 * @projectName meter-jar
 * @title HandleRequest
 * @description
 * @create 2024/1/3 15:50
 */
public class Handle1Request extends AuncelRequest<Handle1Request, Handle1Response> {

    // 握手1 随机码
    private String random = "00000000";

    public Handle1Request() {
        super(new ALMack()
                .setEncrypt(Encrypt.Not_Encrypt)
                .setAck(ACK.Request)
                .setConfirm(Confirm.WAIT)
                .setCpt(CPT.Handle));
    }

    /**
     * @description: 内容体填充
     **/
    @Override
    protected void inner_execute() {
        this.source_inner.append(this.random);
    }
}
