package com.jhscale.meter.auncel.cmd;

import com.jhscale.meter.auncel.AuncelUtils;
import com.jhscale.meter.auncel.em.CPT;
import com.jhscale.meter.auncel.entity.ALMack;
import com.jhscale.meter.auncel.entity.AuncelRequest;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.mqtt.em.ACK;
import com.jhscale.meter.mqtt.em.Confirm;
import com.jhscale.meter.mqtt.em.Encrypt;

/**
 * @author wang lie
 * @version 1.0
 * @projectName meter-jar
 * @title HandleRequest
 * @description
 * @create 2024/1/3 15:50
 */
public class Handle2Request extends AuncelRequest<Handle2Request, Handle2Response> {

    // 握手2 随机码
    private String random = "01010101";

    // 协议类型
    private CPT cpt;

    // token原始数据
    private String seed;

    public Handle2Request() {
        super(new ALMack()
                .setEncrypt(Encrypt.Not_Encrypt)
                .setAck(ACK.Request)
                .setConfirm(Confirm.WAIT));
    }

    /**
     * @description: 内容体填充
     **/
    @Override
    protected void inner_execute() throws MeterException {
        this.alMack.setCpt(this.cpt);
        this.source_inner.append(this.random)
                .append(AuncelUtils.handshake_ack(this.seed));
    }

    public CPT getCpt() {
        return cpt;
    }

    public Handle2Request setCpt(CPT cpt) {
        this.cpt = cpt;
        return this;
    }

    public String getSeed() {
        return seed;
    }

    public Handle2Request setSeed(String seed) {
        this.seed = seed;
        return this;
    }
}
