package com.jhscale.meter.auncel.cmd;

import com.jhscale.meter.auncel.entity.AuncelResponse;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.mqtt.em.Confirm;

/**
 * @author wang lie
 * @version 1.0
 * @projectName meter-jar
 * @title HandleRequest
 * @description
 * @create 2024/1/3 15:50
 */
public class Handle2Response extends AuncelResponse<Handle2Request, Handle2Response> {

    private boolean result;

    /**
     * @description: 随机码
     **/
    private String random;

    public Handle2Response() {
    }

    public Handle2Response(Handle2Request request, String content) {
        super(request, content);
    }

    /**
     * @description: 内容体填充
     **/
    @Override
    protected void inner_execute() throws MeterException {
        this.result= Confirm.SUCCESS.equals(this.alMack.getConfirm());
        this.random = this.source_inner.substring(0, 8);
    }

    public boolean isResult() {
        return result;
    }

    public String getRandom() {
        return random;
    }
}
