package com.jhscale.meter.auncel.em;

import org.apache.commons.lang3.StringUtils;

import java.util.Objects;

/**
 * @author wang lie
 * @version 1.0
 * @projectName meter-jar
 * @title CPT
 * @description
 * @create 2024/1/3 13:35
 */
public enum CPT {

    Handle(0, "0000", "握手协议"),
    LCD_Panel(1, "0001", "LCD panel"),
    Color_Acl(2, "0010", "彩屏天平协议");

    private Integer val;

    private String bit;

    private String description;

    CPT(Integer val, String bit, String description) {
        this.val = val;
        this.bit = bit;
        this.description = description;
    }

    /**
     * @description: 获取CD
     **/
    public static CPT val(Integer val) {
        if (Objects.nonNull(val)) {
            for (CPT cpt : CPT.values()) {
                if (val.equals(cpt.getVal())) return cpt;
            }
        }
        return null;
    }

    /**
     * @description: 获取CD
     **/
    public static CPT bit(String bit) {
        if (StringUtils.isNotBlank(bit)) {
            for (CPT cpt : CPT.values()) {
                if (bit.equals(cpt.getBit())) return cpt;
            }
        }
        return null;
    }

    public Integer getVal() {
        return val;
    }

    public String getBit() {
        return bit;
    }

    public String getDescription() {
        return description;
    }
}
