package com.jhscale.meter.auncel.entity;

import com.jhscale.common.model.simple.JSONModel;
import com.jhscale.meter.auncel.em.CPT;
import com.jhscale.meter.mqtt.em.ACK;
import com.jhscale.meter.mqtt.em.Confirm;
import com.jhscale.meter.mqtt.em.Encrypt;
import com.jhscale.meter.utils.MQTTUtils;

/**
 * @author wang lie
 * @version 1.0
 * @projectName meter-jar
 * @title ALMack
 * @description
 * @create 2024/1/3 13:53
 */
public class ALMack extends JSONModel {

    // 二进制标识
    private String bin;
    // 加密状态
    private Encrypt encrypt;
    // 请求响应标志
    private ACK ack;
    // 请求响应状态
    private Confirm confirm;
    // 指令标识
    private CPT cpt;

    public ALMack() {
    }

    /**
     * @description: 默认不加密
     **/
    public ALMack(ACK ack, Confirm confirm, CPT cpt) {
        this(Encrypt.Not_Encrypt, ack, confirm, cpt);
    }

    public ALMack(Encrypt encrypt, ACK ack, Confirm confirm, CPT cpt) {
        this.encrypt = encrypt;
        this.ack = ack;
        this.confirm = confirm;
        this.cpt = cpt;
    }

    public ALMack(String markContent) {
        this.bin = MQTTUtils.hex2Bit(markContent);
        this.encrypt = Encrypt.bit(this.bin.substring(0, 1));
        this.ack = ACK.bit(this.bin.substring(1, 2));
        this.confirm = Confirm.bit(this.bin.substring(2, 4));
        this.cpt = CPT.bit(this.bin.substring(4));
    }

    /**
     * @description: 组装Mark
     **/
    public String assembleMark() {
        String bin = new StringBuilder()
                .append(this.encrypt.getBit())
                .append(this.ack.getBit())
                .append(this.confirm.getBit())
                .append(this.cpt.getBit())
                .toString();
        this.bin = bin;
        return MQTTUtils.bit2Hex(bin);
    }

    public String getBin() {
        return bin;
    }

    public ALMack setBin(String bin) {
        this.bin = bin;
        return this;
    }

    public Encrypt getEncrypt() {
        return encrypt;
    }

    public ALMack setEncrypt(Encrypt encrypt) {
        this.encrypt = encrypt;
        return this;
    }

    public ACK getAck() {
        return ack;
    }

    public ALMack setAck(ACK ack) {
        this.ack = ack;
        return this;
    }

    public Confirm getConfirm() {
        return confirm;
    }

    public ALMack setConfirm(Confirm confirm) {
        this.confirm = confirm;
        return this;
    }

    public CPT getCpt() {
        return cpt;
    }

    public ALMack setCpt(CPT cpt) {
        this.cpt = cpt;
        return this;
    }

}
