package com.jhscale.meter.auncel.entity;

import com.jhscale.meter.auncel.AuncelManager;
import com.jhscale.meter.auncel.AuncelUtils;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.model.base.JSONMeter;
import com.jhscale.meter.mqtt.em.Encrypt;
import com.jhscale.meter.protocol.model.GlobalPara;
import com.jhscale.meter.utils.ByteUtils;
import com.jhscale.meter.utils.CrcUtils;

import static com.jhscale.meter.auncel.AuncelUtils.*;

/**
 * @author wang lie
 * @version 1.0
 * @projectName meter-jar
 * @title AuncelRequest
 * @description
 * @create 2024/1/3 15:45
 */
public abstract class AuncelRequest<T extends AuncelRequest, U extends AuncelResponse> implements JSONMeter {

    /**
     * @description: MARK
     **/
    protected ALMack alMack;

    /**
     * @description: 通讯标识
     **/
    protected Integer nid;

    /**
     * @description: 完整包
     **/
    protected StringBuilder builder;

    /**
     * @description: 指令缓冲区
     **/
    protected StringBuilder source_inner;

    /**
     * @description: 加密内包
     **/
    protected String aes_inner;

    public AuncelRequest() {
    }

    public AuncelRequest(ALMack mack) {
        this.alMack = mack;
    }

    /**
     * @description: 指令组装
     **/
    public T execute() throws MeterException {
        this.nid = AuncelUtils.nid();

        this.source_inner = new StringBuilder();
        // 填充内容体
        this.inner_execute();

        String mark = this.alMack.assembleMark();

        String frame = Integer.toHexString(this.nid);
        frame = (frame.length() % 2 != 0 ? ("0" + frame) : frame).toUpperCase();

        this.aes_inner = this.source_inner.toString();
        if (Encrypt.AES_Encrypt.equals(this.alMack.getEncrypt())) {
            int append = this.source_inner.length() / 2 % 16;
            append = append == 0 ? 0 : (16 - append);
            for (int i = 0; i < append; i++) {
                this.source_inner.append(ByteUtils.ten2Hex(i, 2));
            }
            this.aes_inner = AuncelUtils.encrypt(this.source_inner.toString(), AuncelManager.getInstance().getSeed());
        }

        int length = this.aes_inner.length() / 2 / 4 - 1;
        String len = Integer.toHexString(length);
        len = len.length() % 2 == 0 ? len : ("0" + len);

        this.builder = new StringBuilder(mark)
                .append(len)
                .append(frame)
                .append(this.aes_inner);

        String crc = CrcUtils.crc_0xff(this.builder.toString());
        this.builder.append(crc);

        // 字符转义
        this.builder = this.request_transfer();

        this.builder.insert(0, TOP)
                .append(END);
        return (T) this;
    }

    /**
     * @return
     * @description: 字符转移
     */
    private StringBuilder request_transfer() {
        String content = this.builder.toString();
        StringBuilder _content = new StringBuilder();
        for (int i = 0; i < content.length() / 2; i++) {
            String _c = content.substring(i * 2, i * 2 + 2);
            int _cv = Integer.parseInt(_c, 16);
            if (_cv == TOP_V) {
                _content.append(TOP_T);
            } else if (_cv == END_V) {
                _content.append(END_T);
            } else if (_cv == REPLACE_V) {
                _content.append(REPLACE_T);
            } else {
                _content.append(_c);
            }
        }
        if (GlobalPara.getInstance().isRunLog())
            System.out.printf("Transfer Before: [%s] After: [%s]%n", content, _content);
        return _content;
    }

    /**
     * @return
     * @description: 添加内包CRC
     */
    protected String inner_crc() throws MeterException {
        return CrcUtils.crc_0xff(this.source_inner.toString());
    }

    /**
     * @description: 内容体填充
     **/
    protected abstract void inner_execute() throws MeterException;

    public String over() {
        return this.builder.toString();
    }

    public ALMack getAlMack() {
        return alMack;
    }

    public Integer getNid() {
        return nid;
    }

    public StringBuilder getBuilder() {
        return builder;
    }

    public StringBuilder getSource_inner() {
        return source_inner;
    }

    public String getAes_inner() {
        return aes_inner;
    }
}
