package com.jhscale.meter.auncel.entity;

import com.jhscale.meter.auncel.AuncelManager;
import com.jhscale.meter.auncel.AuncelUtils;
import com.jhscale.meter.auncel.cmd.*;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.mqtt.em.Encrypt;
import com.jhscale.meter.protocol.model.GlobalPara;
import com.jhscale.meter.utils.CrcUtils;

import static com.jhscale.meter.auncel.AuncelUtils.*;

public class AuncelResponse<T extends AuncelRequest, U extends AuncelResponse> extends AuncelRequest {

    /**
     * @description: 请求信息
     **/
    private T request;

    public AuncelResponse() {
    }

    public AuncelResponse(String content) {
        this.builder = new StringBuilder(content);
    }

    public AuncelResponse(T request, String content) {
        this(content);
        this.request = request;
    }

    /**
     * @description: 内容解析
     **/
    public U execute() throws MeterException {
        // 字符转义
        this.builder = this.response_transfer();

        String crc = this.builder.substring(this.builder.length() - 4, this.builder.length() - 2);
        String _crc = CrcUtils.crc_0xff(this.builder.substring(2, this.builder.length() - 4));
        if (!crc.equalsIgnoreCase(_crc))
            throw new MeterException(MeterStateEnum.MQTT_CRC检查错误);

        this.alMack = new ALMack(this.builder.substring(2, 4));
        int len = (Integer.parseInt(this.builder.substring(4, 6)) + 1) * 4 * 2;
        this.nid = Integer.parseInt(this.builder.substring(6, 8), 16);

        this.aes_inner = this.builder.substring(8, 8 + len);
        this.source_inner = new StringBuilder(this.aes_inner);
        if (Encrypt.AES_Encrypt.equals(this.alMack.getEncrypt())) {
            this.source_inner = new StringBuilder(AuncelUtils.decrypt(this.aes_inner, AuncelManager.getInstance().getSeed()));
        }

        U u = (U) this;

        String command = this.source_inner.substring(0, 2);

        // System.out.printf("Command: %s%n", command);

        // if ("01".equals(command))
        //     System.out.printf("Command: %s%n", command);

        Class clazz = this.responseClass(this.alMack, command);
        if (!this.getClass().equals(clazz)) {
            try {
                u = (U) clazz.newInstance();
                u.builder = this.builder;
                u.alMack = this.alMack;
                u.nid = this.nid;
                u.aes_inner = this.aes_inner;
                u.source_inner = this.source_inner;
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        u.inner_execute();
        return u;
    }

    /**
     * @return
     * @description: 转移
     */
    private StringBuilder response_transfer() {
        String content = this.builder.substring(2, this.builder.length() - 2);
        StringBuilder _content = new StringBuilder();
        for (int i = 0; i < content.length() / 2; i++) {
            String _c = content.substring(i * 2, i * 2 + 2);
            int _cv = Integer.parseInt(_c, 16);
            if (_cv == TOP_TV) {
                _content.append(TOP);
            } else if (_cv == END_TV) {
                _content.append(END);
            } else if (_cv == REPLACE_TV) {
                _content.append(REPLACE);
            } else {
                _content.append(_c);
            }
        }
        if (GlobalPara.getInstance().isRunLog())
            System.out.printf("Transfer Before: [%s] After: [%s]%n", content, _content);
        return _content.insert(0, TOP)
                .append(END);
    }

    /**
     * @return
     * @description: 指令判断响应对象
     */
    private Class responseClass(ALMack alMack, String command) {
        Class clazz = null;
        if (alMack.getAck().isRequest()) {
            clazz = AL_Handle_Reset_Notify.class;
        } else {
            switch (command) {
                case "00":
                    clazz = Handle1Response.class;
                    break;
                case "01":
                    clazz = Handle2Response.class;
                    break;
                case "05":
                    clazz = AL_05_LoginResponse.class;
                    break;
                case "06":
                    clazz = AL_06_LogoutResponse.class;
                    break;
                case "07":
                    clazz = AL_07_EditPWDResponse.class;
                    break;
                case "08":
                    clazz = AL_08_ReadOnlyResponse.class;
                    break;
                case "09":
                    clazz = AL_09_WriteOnlyResponse.class;
                    break;
                case "0A":
                    clazz = AL_0A_WriteRWResponse.class;
                    break;
                case "0B":
                    clazz = AL_0B_ReadWeightResponse.class;
                    break;
                case "0C":
                    clazz = AL_0C_ReadTareResponse.class;
                    break;
                case "0D":
                    clazz = AL_0D_SetTareResponse.class;
                    break;
                case "0E":
                    clazz = AL_0E_SetZeroResponse.class;
                    break;
                case "0F":
                    clazz = AL_0F_ReadRWResponse.class;
                    break;
            }
        }
        return clazz;
    }

    /**
     * @return
     * @description: 添加内包CRC
     */
    @Override
    protected String inner_crc() throws MeterException {
        String crc = CrcUtils.crc_0xff(this.source_inner.substring(0, this.source_inner.length() - 2));
        String _crc = this.source_inner.substring(this.source_inner.length() - 2);
        if (!crc.equalsIgnoreCase(_crc)) throw new MeterException(MeterStateEnum.MQTT_CRC检查错误);
        return crc;
    }

    /**
     * @description: 内容体填充
     **/
    @Override
    protected void inner_execute() throws MeterException {

    }

    public T getRequest() {
        return request;
    }

    public void setRequest(T request) {
        this.request = request;
    }
}
