package com.jhscale.meter.call.agreement;

import com.alibaba.fastjson.JSON;
import com.jhscale.meter.call.entity.Request;
import com.jhscale.meter.call.entity.Response;
import com.jhscale.meter.call.model.Assemble;
import com.jhscale.meter.call.model.Parse;
import com.jhscale.meter.call.model.ParseData;
import com.jhscale.meter.call.service.IPort;
import com.jhscale.meter.utils.AConstant;
import com.jhscale.meter.utils.ByteUtils;
import com.jhscale.meter.utils.CodeUtils;
import com.jhscale.meter.utils.Constant;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * @author Loveven
 * @title: AbstractAgreement
 * @projectName jhscale-agreement
 * @description: TODO
 * @date 2019/9/215:24
 */
public class Agreement implements IAgreement, IPort {

    // 数据解析对象
    private Assemble assemble;

    // 待解析数据
    private String cmdData;

    // 执行类
    private IAgreement agreement;

    public Agreement() {
    }

    public Agreement(Request request) {
        this.assemble = new Assemble(request.getCmd(), request.getData());
        switch (this.assemble.getCmd()) {
            case "A":
                this.agreement = new A();
                break;
            case "I":
                this.agreement = new I(this.assemble);
                break;
            case "Z":
                this.agreement = new Z();
                break;
            default:
                this.agreement = new Agreement();
                break;
        }
    }

    public Agreement(String cmdData) {
        this.cmdData = cmdData;
    }

    @Override
    public boolean assembleCheck(Assemble assemble) throws Exception {
        if (StringUtils.isNotBlank(assemble.getData())) {
            assemble.setData("");
        }
        return true;
    }

    @Override
    public String assemble() {
        Response response = null;
        try {
            if (StringUtils.isBlank(assemble.getCmd()))
                throw new Exception(AConstant.DATA_P_CMD + "-数据指令为空");

            agreement.assembleCheck(assemble);

            int frameNum = (int) (Math.random() * 255);
            String frame = Integer.toHexString(frameNum);
            if (frame.length() % 2 != 0) frame = "0" + frame;

            String cmd = ByteUtils.ascii2Hex(assemble.getCmd());
            int cmdNum = Integer.parseInt(cmd, 16);
            int temp = cmdNum + CodeUtils.codeArr[(frameNum + 1) % 0x0100];
            if (temp > 0xff) temp -= 0x0100;
            cmd = Integer.toHexString(temp);
            if (cmd.length() % 2 != 0) cmd = "0" + cmd;

            int dataNum = 0;
            int assembleDataLength = 0;
            StringBuffer data = new StringBuffer();
            if (StringUtils.isNotBlank(assemble.getData())) {
                if (assemble.getData().length() % 2 != 0)
                    throw new Exception(AConstant.DATA_P_DATA + "-数据格式错误");

                assembleDataLength = assemble.getData().length();

                for (int i = 0; i < (assemble.getData().length() / 2); i++) {
                    String bit = assemble.getData().substring(i * 2, i * 2 + 2);
                    int bitVal = Integer.parseInt(bit, 16);
                    dataNum += bitVal;
                    bitVal += CodeUtils.codeArr[(frameNum + 2 + i) % 0x0100];
                    if (bitVal > 0xff) bitVal -= 0x0100;
                    String bitData = Integer.toHexString(bitVal);
                    if (bitData.length() % 2 != 0) {
                        data.append("0" + bitData);
                    } else {
                        data.append(bitData);
                    }
                }
            }

            String length = Integer.toHexString((cmd.length() + assembleDataLength) / 2);
            if (length.length() % 2 != 0)
                length = "0" + length;

            String verify = Integer.toHexString(frameNum + cmdNum + dataNum);
            verify = verify.substring(verify.length() - 2, verify.length());
            String cmdData = Constant.TOP + length + frame + cmd + data.toString() + verify + Constant.END;
            cmdData = CodeUtils.encode(cmdData);
            response = Response.success(cmdData);
        } catch (Exception e) {
            String message = e.getMessage();
            if (StringUtils.isNotBlank(message) && message.contains("-")) {
                String[] split = message.split("-");
                response = Response.fail(split[0], split[1]);
            } else {
                response = Response.fail(AConstant.FAIL, message);
            }
        }
        return JSON.toJSONString(response);
    }

    @Override
    public String parseCheck(String data) throws Exception {
        String decode = CodeUtils.decode(data.trim());
        return CodeUtils.checkData(decode);
    }

    @Override
    public String paese() {
        Response response = null;
        try {
            cmdData = parseCheck(cmdData);
            String lengthStr = cmdData.substring(0, 2);
            String frameStr = cmdData.substring(2, 4);
            String cmdStr = cmdData.substring(4, 6);
            String dataStr = cmdData.substring(6, cmdData.length() - 2);
            String verifyStr = cmdData.substring(cmdData.length() - 2, cmdData.length());
            int cLength = (cmdStr.length() + dataStr.length()) / 2;
            if (Integer.parseInt(lengthStr, 16) != cLength)
                throw new Exception(AConstant.DATA_INNER_LENGTH + "-数据包长度检查错误");

            int frame = Integer.parseInt(frameStr, 16);
            int cmdVal = Integer.parseInt(cmdStr, 16) - CodeUtils.codeArr[(frame + 1) % 0x0100];
            if (cmdVal < 0) cmdVal += 0x0100;
            String cmd = ByteUtils.hex2Ascii(Integer.toHexString(cmdVal)).toUpperCase();

            int dataVal = 0;
            String data = "";
            if (StringUtils.isNotBlank(dataStr)) {
                for (int i = 0; i < (dataStr.length() / 2); i++) {
                    String bit = dataStr.substring(i * 2, i * 2 + 2);
                    int bitVal = Integer.parseInt(bit, 16) - CodeUtils.codeArr[(frame + 2 + i) % 0x0100];
                    if (bitVal < 0) bitVal += 0x0100;
                    dataVal += bitVal;
                    String bitData = Integer.toHexString(bitVal);
                    if (bitData.length() % 2 != 0) {
                        data = data + "0" + bitData;
                    } else {
                        data += bitData;
                    }
                }
            }

            String cVerify = Integer.toHexString(frame + cmdVal + dataVal);
            cVerify = cVerify.substring(cVerify.length() - 2, cVerify.length());
            if (!cVerify.equalsIgnoreCase(verifyStr)) {
                throw new Exception(AConstant.DATA_VERIFY_CODE + "-校验码无效");
            }

            Parse parse = new Parse(Integer.parseInt(lengthStr, 16), cmd, data);
            IAgreement agreement = null;
            switch (parse.getYcmd().toUpperCase()) {
                case "B":
                    agreement = new B();
                    break;
                case "C":
                    agreement = new C();
                    break;
                case "D":
                    agreement = new D();
                    break;
                case "G":
                    agreement = new G();
                    break;
                default:
                    agreement = new Agreement();
                    break;
            }

            ParseData parseData = agreement.parseData(parse);
            String ret = "";
            if (parseData != null) {
                ret = parseData.getCmd() + "&&" + parseData.getData();
            }
            response = Response.success(ret);
        } catch (Exception e) {
            String message = e.getMessage();
            if (message.contains("-")) {
                String[] split = message.split("-");
                response = Response.fail(split[0], split[1]);
            } else {
                response = Response.fail(AConstant.FAIL, message);
            }
        }
        return JSON.toJSONString(response);
    }

    /**
     * @description: 解析后指令数据处理
     **/
    @Override
    public ParseData parseData(Parse parse) throws Exception {
        return new ParseData(parse.getYcmd(), ByteUtils.hex2Ascii(parse.getYdata()));
    }

    /**
     * @param responseStr
     * @description: 切取
     */
    @Override
    public List<String> split(String responseStr) {
        if (StringUtils.isNotBlank(responseStr)) {
            responseStr = responseStr.toUpperCase();
            if (responseStr.contains(Constant.CALL_SPLIT)) {
                List<String> responseStrs = new ArrayList<>();
                String[] split = responseStr.split(Constant.CALL_SPLIT);
                for (int i = 0; i < split.length; i++) {
                    if (i == 0) {
                        responseStrs.add(split[i] + Constant.CALL_END);
                    } else if (i == split.length - 1) {
                        responseStrs.add(Constant.CALL_TOP + split[i]);
                    } else {
                        responseStrs.add(Constant.CALL_TOP + split[i] + Constant.CALL_END);
                    }
                }
                return responseStrs;
            } else {
                return Arrays.asList(responseStr);
            }
        }
        return null;
    }
}
