package com.jhscale.meter.call.agreement;

import com.jhscale.meter.call.model.Parse;
import com.jhscale.meter.call.model.ParseData;
import com.jhscale.meter.utils.AConstant;
import com.jhscale.meter.utils.ByteUtils;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;
import java.util.Objects;

/**
 * @author Loveven
 * @title: C
 * @projectName jhscale-agreement
 * @description: TODO
 * @date 2019/9/221:12
 */
public class C extends Agreement {

    @Override
    public ParseData parseData(Parse parse) throws Exception {
        String data = parse.getYdata();
        String state = "";
        boolean negative = false;
        String sgin = ByteUtils.formatMark(data.substring(0, 2));
        for (int i = 0; i < sgin.length(); i++) {
            if ('1' == sgin.charAt(i)) {
                switch (i) {
                    case 0:
                        state += "ADC,";
                        break;
                    case 1:
                        state += "OVF,";
                        break;
                    case 2:
                        state += "STB,";
                        break;
                    case 3:
                        state += "ZERO,";
                        break;
                    case 4:
                        state += "TARE,";
                        break;
                    case 5:
                        negative = true;
                        state += "NEGATIVE,";
                        break;
                    case 6:
                        state += "LB,";
                        break;
                    case 7:
                        state += "ON,";
                        break;
                    default:
                        throw new Exception(AConstant.DATA_CALL_TYPE + "-状态标志识别错误");
                }
            }
        }
        if (StringUtils.isNotBlank(state)) state = state.substring(0, state.length() - 1);

        int floa, val = 0;
        String power = "";
        Integer val2 = null;
        String val2Symbol = null;
        if (parse.getLength() == 7) {
            // 带电池电压
            val = Integer.parseInt(data.substring(2, data.length() - 4), 16);
            floa = Integer.parseInt(data.substring(data.length() - 4, data.length() - 2), 16);
            power += "|" + new BigDecimal(Integer.parseInt(data.substring(data.length() - 2, data.length()), 16)).divide(new BigDecimal(10)).doubleValue();
        } else if (parse.getLength() == 10) {
            // 带皮重毛重
            val = Integer.parseInt(data.substring(2, 8), 16);
            floa = Integer.parseInt(data.substring(8, 10), 16);
            val2 = Integer.parseInt(data.substring(10, 16), 16);
            val2Symbol = ByteUtils.hex2Ascii(data.substring(16, 18));
        } else {
            // 不带电池电压
            val = Integer.parseInt(data.substring(2, data.length() - 2), 16);
            floa = Integer.parseInt(data.substring(data.length() - 2), 16);
        }
        int floaVal = 1;
        for (int i = 0; i < floa; i++) {
            floaVal = floaVal * 10;
        }

        BigDecimal weight = new BigDecimal(val).divide(new BigDecimal(floaVal));
        weight = negative ? new BigDecimal(0).subtract(weight) : weight;
        data = state + "|" + weight.doubleValue();

        if (StringUtils.isNotBlank(power)) {
            data += power;
        }

        if (Objects.nonNull(val2)) {
            BigDecimal tare = new BigDecimal(0);
            BigDecimal gross = new BigDecimal(0);
            if ("T".equalsIgnoreCase(val2Symbol)) {
                // 皮重
                tare = new BigDecimal(val2).divide(new BigDecimal(floaVal));
                gross = weight.add(tare);
            } else {
                // 毛重
                gross = new BigDecimal(val2).divide(new BigDecimal(floaVal));
                tare = gross.subtract(weight);
            }
            data += "|" + tare.doubleValue() + "|" + gross.doubleValue();
        }
        data += "|" + floa;
        return new ParseData(parse.getYcmd(), data);
    }
}
