package com.jhscale.meter.call.entity;

import com.jhscale.meter.utils.AConstant;
import com.jhscale.meter.utils.ByteUtils;
import org.apache.commons.lang3.StringUtils;

/**
 * @author Loveven
 * @title: Response
 * @projectName jhscale-agreement
 * @description: TODO
 * @date 2019/9/216:18
 */
public class Response {

    // 状态码
    private String code;

    // 错误描述
    private String err;

    // 返回值信息
    private String ret;

    /**
     * @description: 成功
     **/
    public static Response success(String ret) {
        Response response = new Response();
        response.setCode(AConstant.SUCCESS);
        response.setRet(ret);
        return response;
    }

    /**
     * @description: 失败
     **/
    public static Response fail(String code, String msg) {
        Response response = new Response();
        if (StringUtils.isBlank(code))
            code = AConstant.FAIL;
        response.setCode(code);
        response.setRet(msg);
        return response;
    }

    public boolean checkResult() {
        return AConstant.SUCCESS.equals(this.code);
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getErr() {
        return err;
    }

    public void setErr(String err) {
        this.err = err;
    }

    public String getRet() {
        return ret;
    }

    public void setRet(String ret) {
        this.ret = ret;
    }

    /**
     * @description: HEX内容转Str内容
     **/
    public String hexToStr() {
        return StringUtils.isNotBlank(this.ret) ? new String(ByteUtils.fromHexString(this.ret)) : "";
    }
}
