package com.jhscale.meter.call.link;

import com.jhscale.meter.call.entity.Response;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.utils.ByteUtils;
import com.jhscale.meter.utils.SerialTool;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;


/**
 * @author lie_w
 * @title: CallSerialMenssenger
 * @projectName jhscale-agreement
 * @description: 串口默认通讯方式
 * @date 2021-01-189:49
 */
public class DefaultSerialCallMenssenger implements CallMessenger {

    private String portName = "COM3";
    private int baudrate = 9600;
    private SerialPort serialPort;
    private ICallBack callBack;

    public DefaultSerialCallMenssenger() {
    }

    public DefaultSerialCallMenssenger(ICallBack callBack) {
        initMessenger(callBack);
    }

    public ICallBack getCallBack() {
        return callBack;
    }

    /**
     * @param callBack
     * @description: 通讯器初始化
     */
    @Override
    public void initMessenger(ICallBack callBack) {
        try {
            this.serialPort = SerialTool.openPort(portName, baudrate);
            this.callBack = callBack;
            SerialTool.addListener(this.serialPort, new SerialPortEventListener() {
                @Override
                public void serialEvent(SerialPortEvent serialPortEvent) {
                    switch (serialPortEvent.getEventType()) {
                        case SerialPortEvent.BI: // 10 通讯中断
                            break;
                        case SerialPortEvent.OE: // 7 溢位（溢出）错误
                            break;
                        case SerialPortEvent.FE: // 9 帧错误
                            break;
                        case SerialPortEvent.PE: // 8 奇偶校验错误
                            break;
                        case SerialPortEvent.CD: // 6 载波检测
                            break;
                        case SerialPortEvent.CTS: // 3 清除待发送数据
                            break;
                        case SerialPortEvent.DSR: // 4 待发送数据准备好了
                            break;
                        case SerialPortEvent.RI: // 5 振铃指示
                            break;
                        case SerialPortEvent.OUTPUT_BUFFER_EMPTY: // 2 输出缓冲区已清空
                            break;
                        case SerialPortEvent.DATA_AVAILABLE: // 1 串口存在可用数据
                            try {
                                Thread.sleep(50);
                                String accept = ByteUtils.toHexAscii(SerialTool.readFromPort(serialPort));
                                System.out.println("秤重串口收取数据： " + accept);
                                getCallBack().response(Response.success(accept));
                            } catch (MeterException e) {
                                e.printStackTrace();
                            } catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            break;
                    }
                }
            });
        } catch (MeterException e) {
            if (callBack != null)
                callBack.response(Response.fail(e.getMeterState().getCode(), e.getMeterState().getMsg() + e.getMessage()));
        }
    }

    /**
     * @param cmd
     * @param callBack
     * @description: 发送命令以及回调
     */
    @Override
    public void sendCmd(String cmd, ICallBack callBack) {
        try {
            this.callBack = callBack;
            SerialTool.sendToPort(this.serialPort, ByteUtils.fromHexString(cmd));
        } catch (MeterException e) {
            if (callBack != null)
                callBack.response(Response.fail(e.getMeterState().getCode(), e.getMeterState().getMsg() + e.getMessage()));
        }
    }
}
