package com.jhscale.meter.call.link;

import java.util.Objects;

/**
 * @author lie_w
 * @title: UpgradeParam
 * @projectName jhscale-agreement
 * @description: 升级参数
 * @date 2021-01-198:44
 */
public class UpgradeParam {
    // 握手重试次数
    private Integer shakeTryCount = 10;

    // 握手间隔时间
    private Long shakeSleep = 1000L;

    // 发送升级数据长度
    private Integer size = 4;

    // 发送升级后休眠时间
    private Long upgradeSleep = 12L;

    public UpgradeParam() {
    }

    public UpgradeParam(Integer shakeTryCount, Long shakeSleep, Integer size, Long upgradeSleep) {
        this.shakeTryCount = shakeTryCount;
        this.shakeSleep = shakeSleep;
        this.size = size;
        this.upgradeSleep = upgradeSleep;
    }

    public Integer getShakeTryCount() {
        return Objects.isNull(this.shakeTryCount) ? 10 : shakeTryCount;
    }

    public void setShakeTryCount(Integer shakeTryCount) {
        this.shakeTryCount = shakeTryCount;
    }

    public Long getShakeSleep() {
        return Objects.isNull(this.shakeSleep) ? 1000L : shakeSleep;
    }

    public void setShakeSleep(Long shakeSleep) {
        this.shakeSleep = shakeSleep;
    }

    public Integer getSize() {
        return Objects.isNull(this.size) ? 4 : size;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public Long getUpgradeSleep() {
        return Objects.isNull(this.upgradeSleep) ? 12L : upgradeSleep;
    }

    public void setUpgradeSleep(Long upgradeSleep) {
        this.upgradeSleep = upgradeSleep;
    }
}
