package com.jhscale.meter.call.service;

import com.jhscale.meter.call.entity.Request;
import com.jhscale.meter.call.link.CallMessenger;
import com.jhscale.meter.call.link.ICallBack;
import com.jhscale.meter.call.link.UpgradeParam;
import com.jhscale.meter.em.WeighingMode;
import com.jhscale.meter.exp.MeterException;

import java.io.File;
import java.io.InputStream;

/**
 * @author lie_w
 * @title: IWeight
 * @projectName jhscale-agreement
 * @description: 只负责秤重数据拼装解析
 * @date 2021-01-0814:42
 */
public interface IWeight {

    /**
     * @description: 数据拼装
     **/
    String assemble(Request request);

    /**
     * @description: 数据内容解析
     **/
    String parse(String cmd);

    /**
     * @description: 设置秤重模式
     **/
    String setModel(WeighingMode weighingMode);

    /**
     * @description: 置零操作
     **/
    String setZero();

    /**
     * @description: 去皮操作
     **/
    String setPeeling();

    /**
     * @description: 设置皮重
     **/
    String setPeeling(String weight);

    /**
     * @description: 关机操作
     **/
    String powerOff();

    /**
     * @description: 读取重量命令
     **/
    String readWeight();

    /**
     * @description: 响应数据解析 同时可以解析秤重
     **/
    String parseResponse(String responseStr);

    /**
     * @description: 读取重量解析
     **/
    String readWeight(String cmd);

    /**
     * @description: 读取MAC(蓝牙通讯时支持此操作)
     **/
    String readMac();

    /**
     * @description: 读取版本
     **/
    String readVersion();

    /**
     * @description: 获取升级参数
     **/
    UpgradeParam getUpgradeParam();

    /**
     * @description: 设置升级参数
     **/
    void setUpgradeParam(UpgradeParam param);

    /**
     * @description: 握手
     **/
    void shake(CallMessenger callMessenger, ICallBack callBack) throws MeterException;

    /**
     * @description: 文件升级
     **/
    void upgrade(File file, ICallBack callBack) throws MeterException;

    /**
     * @description: 文件流升级
     **/
    void upgrade(InputStream inputStream, ICallBack callBack) throws MeterException;
}
