package com.jhscale.meter.em;

import org.apache.commons.lang3.StringUtils;

import java.util.Objects;

/**
 * @author lie_w
 * @title: PayCode
 * @projectName meter-jar
 * @description: TODO
 * @date 2022/8/417:42
 */
public enum PayCode {

    ALI_PAY(1),
    WECHAT_PAY(2),
    CASH_PAY(3),
    JK_PAY(4),
    ORTHER_PAY(5),
    WECHAT_OA_PAY(6),
    UNION_T_PAY(7),
        UNION_PAY(70), // 云闪付
        JH_PAY(71),// 建行支付
        YZ_PAY(72),// 邮政支付
    QQ_PAY(8), // QQ
    /**
     * @description: 只用来统计
     **/
    TOTAL_PAY(10),
    UNKNOWN(9999);

    private int type;

    PayCode(Integer type) {
        this.type = type;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    @Override
    public String toString() {
        return String.valueOf(this.type);
    }

    /**
     * @description: 支付类型
     **/
    public static PayCode type(Integer type) {
        if (Objects.nonNull(type)) {
            for (PayCode payCode : PayCode.values()) {
                if (payCode.getType().equals(type)) return payCode;
            }
        }
        return null;
    }

    /**
     * @description: 支付类型
     **/
    public static PayCode type(String type) {
        if (StringUtils.isNotBlank(type)) {
            for (PayCode payCode : PayCode.values()) {
                if (payCode.getType().toString().equals(type)) return payCode;
            }
        }
        return null;
    }
}
