package com.jhscale.meter.em;

import org.apache.commons.lang3.StringUtils;

/**
 * @author lie_w
 * @title: WeightMode
 * @projectName meter-jar
 * @description: 重量模式
 * @date 2021/6/108:23
 */
public enum WeighingMode {

    Continuous("00", "连续发送模式"),
    Stable("01", "稳定发送模式"),
    Signle_Rzero("02", "单次回零发送模式"),
    Signle_Stable("03", "单次稳定发送模式"),
    Button_Send("04", "按键发送模式 (保留不使用)"),
    Answer("05", "应答模式"),

    Tare_Continuous("10", "连续发送模式 带皮重"),
    Tare_Stable("11", "稳定发送模式 带皮重"),
    Tare_Signle_Rzero("12", "单次回零发送模式 带皮重"),
    Tare_Signle_Stable("13", "单次稳定发送模式 带皮重"),
    Tare_Button_Send("14", "按键发送模式 带皮重 (保留不使用)"),
    Tare_Answer("15", "应答模式 带皮重"),

    Gross_Continuous("20", "连续发送模式 带毛重"),
    Gross_Stable("21", "稳定发送模式 带毛重"),
    Gross_Signle_Rzero("22", "单次回零发送模式 带毛重"),
    Gross_Signle_Stable("23", "单次稳定发送模式 带毛重"),
    Gross_Button_Send("24", "按键发送模式 带毛重 (保留不使用)"),
    Gross_Answer("25", "应答模式 带毛重"),

    Wave_Internal_Continuous("30", "连续发送模式 滤波重量内码+零位内码"),
    Wave_Internal_Stable("31", "稳定发送模式 滤波重量内码+零位内码"),
    Wave_Internal_Signle_Rzero("32", "单次回零发送模式 滤波重量内码+零位内码"),
    Wave_Internal_Signle_Stable("33", "单次稳定发送模式 滤波重量内码+零位内码"),
    Wave_Internal_Send("34", "按键发送模式 滤波重量内码+零位内码 (保留不使用)"),
    Wave_Internal_Answer("35", "应答模式 滤波重量内码+零位内码"),

    Instant_Internal_Continuous("40", "连续发送模式 瞬时重量内码"),
    Instant_Internal_Stable("41", "稳定发送模式 瞬时重量内码"),
    Instant_Internal_Signle_Rzero("42", "单次回零发送模式 瞬时重量内码"),
    Instant_Internal_Signle_Stable("43", "单次稳定发送模式 瞬时重量内码"),
    Instant_Internal_Send("44", "按键发送模式 瞬时重量内码 (保留不使用)"),
    Instant_Internal_Answer("45", "应答模式 瞬时重量内码"),;

    private String val;

    private String description;

    WeighingMode(String val, String description) {
        this.val = val;
        this.description = description;
    }

    public String getVal() {
        return val;
    }

    public String getDescription() {
        return description;
    }

    public static WeighingMode weighingMode(String val) {
        if (StringUtils.isBlank(val)) return null;
        for (WeighingMode weighingMode : WeighingMode.values()) {
            if (val.equals(weighingMode.getVal())) return weighingMode;
        }
        return null;
    }

    @Override
    public String toString() {
        return "WeighingMode{" +
                "val='" + val + '\'' +
                ", description='" + description + '\'' +
                '}';
    }
}
