package com.jhscale.meter.entity;

import com.jhscale.common.annotation.FieldName;
import com.jhscale.meter.entity.item.CAItem;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.protocol.print.PrintGeneralFactory;
import com.jhscale.meter.protocol.print.entity.para.Para;

import java.util.List;

/**
 * @author lie_w
 * @title: LogReport
 * @projectName meter-jar
 * @description: TODO
 * @date 2022/8/2511:21
 */
public class CPReport extends DeviceReport {


    @FieldName(sort = 1, name = "支付宝")
    private CAItem aliPay;

    @FieldName(sort = 2, name = "微信")
    private CAItem wechat;

    @FieldName(sort = 70, name = "云闪付")
    private CAItem union;

    @FieldName(sort = 71, name = "建行")
    private CAItem jh;

    @FieldName(sort = 72, name = "邮政")
    private CAItem yz;


    public CPReport() {
        super(PrintGeneralFactory.getInstance().dict("云支付报表"));
    }

    /**
     * @param money
     * @param weight
     * @description: 内容段
     */
    @Override
    public List<Para> innerPara(Integer money, Integer weight) throws MeterException {
        return this.fieldPara(money);
    }

    public CAItem getAliPay() {
        return aliPay;
    }

    public void setAliPay(CAItem aliPay) {
        this.aliPay = aliPay;
    }

    public CAItem getWechat() {
        return wechat;
    }

    public void setWechat(CAItem wechat) {
        this.wechat = wechat;
    }

    public CAItem getUnion() {
        return union;
    }

    public void setUnion(CAItem union) {
        this.union = union;
    }

    public CAItem getJh() {
        return jh;
    }

    public void setJh(CAItem jh) {
        this.jh = jh;
    }

    public CAItem getYz() {
        return yz;
    }

    public void setYz(CAItem yz) {
        this.yz = yz;
    }
}
